/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;

public class SIPCommTextButton
extends JButton {
    private static final long serialVersionUID = 0L;
    private static final String UIClassID = "BasicButtonUI";
    private final float[] borderColor = Color.DARK_GRAY.getRGBComponents(null);
    private Image bgImage;

    public SIPCommTextButton() {
        this("", (Image)null);
    }

    public SIPCommTextButton(String text) {
        this(text, (Image)null);
    }

    public SIPCommTextButton(String text, Image bgImage) {
        super(text);
        this.bgImage = bgImage;
        MouseRolloverHandler mouseHandler = new MouseRolloverHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.setIcon(null);
        this.setIconTextGap(0);
        this.setContentAreaFilled(false);
    }

    public void setBgImage(Image image) {
        this.bgImage = image;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g1 = (Graphics2D)g.create();
        try {
            this.internalPaintComponent(g1);
        }
        finally {
            g1.dispose();
        }
        super.paintComponent(g);
    }

    private void internalPaintComponent(Graphics2D g) {
        float visibility;
        AntialiasingManager.activateAntialiasing(g);
        FadeTracker fadeTracker = FadeTracker.getInstance();
        float f = visibility = this.getModel().isRollover() ? 1.0f : 0.0f;
        if (fadeTracker.isTracked(this, FadeKind.ROLLOVER)) {
            visibility = fadeTracker.getFade(this, FadeKind.ROLLOVER);
        }
        if ((visibility /= 2.0f) != 0.0f) {
            g.setColor(new Color(this.borderColor[0], this.borderColor[1], this.borderColor[2], visibility));
            if (this.bgImage != null) {
                g.fillRoundRect((this.getWidth() - this.bgImage.getWidth(null)) / 2, (this.getHeight() - this.bgImage.getHeight(null)) / 2, this.bgImage.getWidth(null) - 1, this.bgImage.getHeight(null) - 1, 20, 20);
            } else {
                g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 20, 20);
            }
        }
        if (this.bgImage != null) {
            g.drawImage(this.bgImage, (this.getWidth() - this.bgImage.getWidth(null)) / 2, (this.getHeight() - this.bgImage.getHeight(null)) / 2, null);
        } else {
            g.setColor(this.getBackground());
            g.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, 20, 20);
        }
    }

    @Override
    public String getUIClassID() {
        return UIClassID;
    }

    static {
        UIManager.getDefaults().put(UIClassID, BasicButtonUI.class.getName());
    }

    private class MouseRolloverHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseRolloverHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (SIPCommTextButton.this.isEnabled()) {
                SIPCommTextButton.this.getModel().setRollover(false);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeOut(FadeKind.ROLLOVER, SIPCommTextButton.this, true, new ButtonRepaintCallback());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SIPCommTextButton.this.isEnabled()) {
                SIPCommTextButton.this.getModel().setRollover(true);
                FadeTracker fadeTracker = FadeTracker.getInstance();
                fadeTracker.trackFadeIn(FadeKind.ROLLOVER, SIPCommTextButton.this, true, new ButtonRepaintCallback());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }
    }

    private class ButtonRepaintCallback
    implements FadeTrackerCallback {
        private ButtonRepaintCallback() {
        }

        @Override
        public void fadeEnded(FadeKind arg0) {
            this.repaintLater();
        }

        @Override
        public void fadePerformed(FadeKind arg0, float arg1) {
            this.repaintLater();
        }

        private void repaintLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SIPCommTextButton.this.repaint();
                }
            });
        }

        @Override
        public void fadeReversed(FadeKind arg0, boolean arg1, float arg2) {
        }
    }
}

