/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.plugin.spellcheck.SpellCheckActivator;
import net.java.sip.communicator.util.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Parameters {
    private static final Logger logger = Logger.getLogger(Parameters.class);
    private static final String RESOURCE_LOC = "resources/config/spellcheck/parameters.xml";
    private static final String NODE_DEFAULTS = "defaults";
    private static final String NODE_LOCALES = "locales";
    private static final HashMap<Default, String> DEFAULTS = new HashMap();
    private static final ArrayList<Locale> LOCALES = new ArrayList();

    Parameters() {
    }

    private static void parseDefaults(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            NamedNodeMap mapping = list.item(i).getAttributes();
            String attribute = mapping.getNamedItem("attribute").getNodeValue();
            String value = mapping.getNamedItem("value").getNodeValue();
            try {
                Default field = Default.fromString(attribute);
                DEFAULTS.put(field, value);
                continue;
            }
            catch (IllegalArgumentException exc) {
                logger.warn((Object)("Unrecognized default attribute: " + attribute));
            }
        }
    }

    private static void parseLocales(NodeList list) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            NamedNodeMap attributes = node.getAttributes();
            String label = ((Attr)attributes.getNamedItem("label")).getValue();
            String code = ((Attr)attributes.getNamedItem("isoCode")).getValue();
            String dictLocation = ((Attr)attributes.getNamedItem("dictionaryUrl")).getValue();
            String flagIcon = ((Attr)attributes.getNamedItem("flagIcon")).getValue();
            try {
                LOCALES.add(new Locale(label, code, new URL(dictLocation), flagIcon));
                continue;
            }
            catch (MalformedURLException exc) {
                logger.warn((Object)("Unable to parse dictionary location of " + label + " (" + dictLocation + ")"), (Throwable)exc);
            }
        }
    }

    public static String getDefault(Default field) {
        return DEFAULTS.get((Object)field);
    }

    public static Locale getLocale(String isoCode) {
        for (Locale locale : LOCALES) {
            if (!locale.getIsoCode().equals(isoCode)) continue;
            return locale;
        }
        return null;
    }

    public static ArrayList<Locale> getLocales() {
        return new ArrayList<Locale>(LOCALES);
    }

    static {
        try {
            URL url = SpellCheckActivator.bundleContext.getBundle().getResource(RESOURCE_LOC);
            InputStream stream = url.openStream();
            if (stream == null) {
                throw new IOException();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Node root = doc.getChildNodes().item(1);
            NodeList categories = root.getChildNodes();
            for (int i = 0; i < categories.getLength(); ++i) {
                Node node = categories.item(i);
                if (node.getNodeName().equals(NODE_DEFAULTS)) {
                    Parameters.parseDefaults(node.getChildNodes());
                    continue;
                }
                if (node.getNodeName().equals(NODE_LOCALES)) {
                    Parameters.parseLocales(node.getChildNodes());
                    continue;
                }
                logger.warn((Object)("Unrecognized category: " + node.getNodeName()));
            }
        }
        catch (IOException exc) {
            logger.error((Object)"Unable to load spell checker parameters", (Throwable)exc);
        }
        catch (SAXException exc) {
            logger.error((Object)"Unable to parse spell checker parameters", (Throwable)exc);
        }
        catch (ParserConfigurationException exc) {
            logger.error((Object)"Unable to parse spell checker parameters", (Throwable)exc);
        }
    }

    public static enum Default {
        LOCALE("locale");

        private String tag;

        private Default(String tag) {
            this.tag = tag;
        }

        public static Default fromString(String str) {
            for (Default field : Default.values()) {
                if (!str.equals(field.toString())) continue;
                return field;
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return this.tag;
        }
    }

    public static class Locale {
        private final String label;
        private final String isoCode;
        private final URL dictLocation;
        private final String flagIcon;
        private boolean isLoading = false;

        private Locale(String label, String isoCode, URL dictLocation, String flagIcon) {
            this.label = label;
            this.isoCode = isoCode;
            this.dictLocation = dictLocation;
            this.flagIcon = flagIcon;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIsoCode() {
            return this.isoCode;
        }

        public String getIcuLocale() {
            String[] parts = this.isoCode.split(",");
            return parts[0].toLowerCase() + "_" + parts[1].toUpperCase();
        }

        public URL getDictUrl() {
            return this.dictLocation;
        }

        public String getFlagIcon() {
            return this.flagIcon;
        }

        public void setLoading(boolean loading) {
            this.isLoading = loading;
        }

        public boolean isLoading() {
            return this.isLoading;
        }

        public String toString() {
            return this.label + " (" + this.isoCode + ")";
        }
    }
}

