/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.chatrooms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.chat.ChatCommand;
import net.kano.joscar.snaccmd.chat.ChatMsg;
import net.kano.joscar.snaccmd.chat.RecvChatMsgIcbm;
import net.kano.joscar.snaccmd.chat.SendChatMsgIcbm;
import net.kano.joscar.snaccmd.chat.UsersJoinedCmd;
import net.kano.joscar.snaccmd.chat.UsersLeftCmd;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfoTracker;
import net.kano.joustsim.oscar.BuddyInfoTrackerListener;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.AbstractService;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatMessage;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomMessageFactory;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomServiceListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomUser;
import net.kano.joustsim.oscar.oscar.service.chatrooms.EncodingException;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatRoomService
extends AbstractService {
    private final Set<ChatRoomUser> users = new HashSet<ChatRoomUser>();
    private final CopyOnWriteArrayList<ChatRoomServiceListener> listeners = new CopyOnWriteArrayList();
    private final FullRoomInfo roomInfo;
    private ChatRoomMessageFactory messageFactory;
    private String roomName;
    private final BuddyInfoTrackerListener trackListener = new BuddyInfoTrackerListener(){};

    public ChatRoomService(AimConnection aimConnection, OscarConnection oscarConnection, FullRoomInfo roomInfo) {
        super(aimConnection, oscarConnection, 14);
        this.roomInfo = roomInfo;
        this.roomName = OscarTools.getRoomNameFromCookie(roomInfo.getCookie());
    }

    @Override
    public void connected() {
        this.setReady();
    }

    public FullRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    public String getRoomName() {
        return this.roomName;
    }

    @Override
    public SnacFamilyInfo getSnacFamilyInfo() {
        return ChatCommand.FAMILY_INFO;
    }

    @Override
    public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
        SnacCommand cmd = snacPacketEvent.getSnacCommand();
        if (cmd instanceof UsersJoinedCmd) {
            UsersJoinedCmd joinedCmd = (UsersJoinedCmd)cmd;
            Set<ChatRoomUser> added = this.addUsers(joinedCmd.getUsers());
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (ChatRoomServiceListener listener : this.listeners) {
                try {
                    listener.handleUsersJoined(this, added);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            JavaTools.throwExceptions(exceptions, "Error while handling room join listeners");
        } else if (cmd instanceof UsersLeftCmd) {
            UsersLeftCmd leftCmd = (UsersLeftCmd)cmd;
            List<FullUserInfo> users = leftCmd.getUsers();
            Set<ChatRoomUser> removed = this.removeUsers(users);
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (ChatRoomServiceListener listener : this.listeners) {
                try {
                    listener.handleUsersLeft(this, removed);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            JavaTools.throwExceptions(exceptions, "Error while handling room left listeners");
        } else if (cmd instanceof RecvChatMsgIcbm) {
            RecvChatMsgIcbm msgIcbm = (RecvChatMsgIcbm)cmd;
            FullUserInfo senderInfo = msgIcbm.getSenderInfo();
            ChatRoomUser user = this.findChatRoomUser(senderInfo);
            if (user == null) {
                user = new ChatRoomUser(senderInfo);
            }
            ChatMsg message = msgIcbm.getMessage();
            ChatMessage ourMsg = this.messageFactory.createMessage(this, user, message);
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (ChatRoomServiceListener listener : this.listeners) {
                try {
                    listener.handleIncomingMessage(this, user, ourMsg);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            JavaTools.throwExceptions(exceptions, "Error while handling room left listeners");
        }
    }

    public synchronized Set<ChatRoomUser> getUsers() {
        return DefensiveTools.getUnmodifiableSetCopy(this.users);
    }

    private synchronized Set<ChatRoomUser> removeUsers(List<FullUserInfo> users) {
        HashSet<ChatRoomUser> removed = new HashSet<ChatRoomUser>();
        for (FullUserInfo userInfo : users) {
            ChatRoomUser user = new ChatRoomUser(userInfo);
            if (!this.users.remove(user)) continue;
            removed.add(user);
        }
        BuddyInfoTracker tracker = this.getAimConnection().getBuddyInfoTracker();
        for (ChatRoomUser user : removed) {
            tracker.removeTracker(user.getScreenname(), this.trackListener);
        }
        return removed;
    }

    @Nullable
    private synchronized ChatRoomUser findChatRoomUser(FullUserInfo senderInfo) {
        for (ChatRoomUser user : this.users) {
            if (!user.getScreenname().matches(senderInfo.getScreenname())) continue;
            return user;
        }
        return null;
    }

    private synchronized Set<ChatRoomUser> addUsers(List<FullUserInfo> users) {
        HashSet<ChatRoomUser> added = new HashSet<ChatRoomUser>();
        for (FullUserInfo userInfo : users) {
            ChatRoomUser user = new ChatRoomUser(userInfo);
            if (!this.users.add(user)) continue;
            added.add(user);
        }
        BuddyInfoTracker tracker = this.getAimConnection().getBuddyInfoTracker();
        for (ChatRoomUser user : added) {
            tracker.addTracker(user.getScreenname(), this.trackListener);
        }
        return added;
    }

    public void addChatRoomListener(ChatRoomServiceListener listener) {
        this.listeners.add(listener);
    }

    public void removeChatRoomListener(ChatRoomServiceListener listener) {
        this.listeners.remove(listener);
    }

    void setMessageFactory(ChatRoomMessageFactory factory) {
        this.messageFactory = factory;
    }

    public void sendMessage(String message) throws EncodingException {
        this.sendSnac(new SendChatMsgIcbm(this.messageFactory.encodeMessage(message)));
    }
}

