/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.mailcheck;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.mailcheck.MailCheckCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailStatusRequest
extends MailCheckCmd {
    private final List<ByteBlock> cookies;

    protected MailStatusRequest(SnacPacket packet) {
        super(6);
        ByteBlock data = packet.getData();
        int count = BinaryTools.getUShort(data, 0);
        ArrayList<ByteBlock> mcookies = new ArrayList<ByteBlock>();
        for (int i = 0; i < count; ++i) {
            mcookies.add(data.subBlock(2 + i * 16));
        }
        this.cookies = Collections.unmodifiableList(mcookies);
    }

    public MailStatusRequest() {
        super(6);
        this.cookies = Collections.unmodifiableList(Arrays.asList(ByteBlock.createFromUnsigned(179, 128, 154, 216, 13, 186, 17, 213, 159, 138, 0, 96, 176, 238, 6, 49), ByteBlock.createFromUnsigned(93, 94, 23, 8, 85, 170, 17, 211, 177, 67, 0, 96, 176, 251, 30, 203)));
    }

    public List<ByteBlock> getCookies() {
        return this.cookies;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.cookies.size());
        for (ByteBlock block : this.cookies) {
            block.write(out);
        }
    }
}

