/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.ft;

import java.util.zip.Checksum;
import net.kano.joscar.DefensiveTools;

public final class FileTransferChecksum
implements Checksum {
    public static final long CHECKSUM_EMPTY = 0xFFFF0000L;
    private long checksum;

    public FileTransferChecksum() {
        this.reset();
    }

    public void update(int value) {
        this.update(new byte[]{(byte)value}, 0, 1);
    }

    public void update(byte[] input, int offset, int len) {
        DefensiveTools.checkNull(input, "input");
        assert (this.checksum >= 0L);
        long check = this.checksum >> 16 & 0xFFFFL;
        for (int i = 0; i < len; ++i) {
            long oldcheck = check;
            int byteVal = input[offset + i] & 0xFF;
            int val = (i & 1) != 0 ? byteVal : byteVal << 8;
            if ((check -= (long)val) <= oldcheck) continue;
            --check;
        }
        check = (check & 0xFFFFL) + (check >> 16);
        check = (check & 0xFFFFL) + (check >> 16);
        this.checksum = check << 16 & 0xFFFFFFFFL;
        assert (this.checksum >= 0L);
    }

    public long getValue() {
        assert (this.checksum >= 0L);
        return this.checksum;
    }

    public void reset() {
        this.checksum = 0xFFFF0000L;
        assert (this.checksum >= 0L);
    }

    public String toString() {
        return "FileTransferChecksum: " + this.checksum;
    }
}

