/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvcmd.AbstractRvCmd;
import net.kano.joscar.rvcmd.RequestRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public abstract class AbstractRequestRvCmd
extends AbstractRvCmd
implements RequestRvCmd {
    public static final boolean FPRESENT_DEFAULT = true;
    private static final int TYPE_REQINDEX = 10;
    private static final int TYPE_F = 15;
    private final int reqIndex;
    private final boolean fPresent;

    protected AbstractRequestRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        TlvChain chain = this.getRvTlvs();
        this.reqIndex = chain.getUShort(10);
        this.fPresent = chain.hasTlv(15);
        this.getMutableTlvs().removeTlvs(10, 15);
    }

    protected AbstractRequestRvCmd(CapabilityBlock cap) {
        this(cap, 1);
    }

    protected AbstractRequestRvCmd(CapabilityBlock cap, int requestIndex) {
        this(cap, requestIndex, true);
    }

    protected AbstractRequestRvCmd(CapabilityBlock cap, int requestIndex, boolean fPresent) {
        super(0, cap);
        DefensiveTools.checkRange(requestIndex, "requestIndex", -1);
        this.reqIndex = requestIndex;
        this.fPresent = fPresent;
    }

    public boolean isFirstRequest() {
        return this.getRequestIndex() == 1;
    }

    public final int getRequestIndex() {
        return this.reqIndex;
    }

    protected final boolean isFPresent() {
        return this.fPresent;
    }

    protected final void writeHeaderRvTlvs(OutputStream out) throws IOException {
        if (this.reqIndex != -1) {
            Tlv.getUShortInstance(10, this.reqIndex).write(out);
        }
        if (this.fPresent) {
            new Tlv(15).write(out);
        }
    }
}

