/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.util.Hashtable;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.slick.protocol.generic.TestOperationSetFileTransfer;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestOperationSetFileTransferImpl
extends TestOperationSetFileTransfer {
    private static final Logger logger = Logger.getLogger(TestOperationSetFileTransferImpl.class);
    private static IcqSlickFixture fixture = null;
    private static OperationSetPresence opSetPresence1 = null;
    private static OperationSetPresence opSetPresence2 = null;
    private static OperationSetFileTransfer opSetFT1 = null;
    private static OperationSetFileTransfer opSetFT2 = null;
    private static Contact contact1 = null;
    private static Contact contact2 = null;
    private static ProtocolProviderFactory providerFactory = null;
    private static AccountID secondProviderAccount = null;

    public TestOperationSetFileTransferImpl(String name) {
        super(name);
    }

    @Override
    public Contact getContact1() {
        if (contact1 == null) {
            contact1 = opSetPresence1.findContactByID(IcqSlickFixture.testerAgent.getIcqUIN());
        }
        return contact1;
    }

    @Override
    public Contact getContact2() {
        if (contact2 == null) {
            contact2 = opSetPresence2.findContactByID(TestOperationSetFileTransferImpl.fixture.ourUserID);
        }
        return contact2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        if (fixture != null) {
            return;
        }
        fixture = new IcqSlickFixture();
        final Object registrationLock = new Object();
        fixture.setUp();
        IcqSlickFixture.testerAgent.unregister();
        Map supportedOperationSets1 = TestOperationSetFileTransferImpl.fixture.provider.getSupportedOperationSets();
        if (supportedOperationSets1 == null || supportedOperationSets1.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        opSetPresence1 = (OperationSetPresence)supportedOperationSets1.get(OperationSetPresence.class.getName());
        if (opSetPresence1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        opSetFT1 = (OperationSetFileTransfer)supportedOperationSets1.get(OperationSetFileTransfer.class.getName());
        if (opSetFT1 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the FileTransferOperationSets");
        }
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=ICQ)";
        try {
            serRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            TestOperationSetFileTransferImpl.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        TestOperationSetFileTransferImpl.assertTrue((String)"Failed to find a provider factory service for protocol ICQ", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        BundleContext bc = IcqSlickFixture.bc;
        providerFactory = (ProtocolProviderFactory)bc.getService(serRefs[0]);
        String USER_ID = IcqSlickFixture.testerAgent.getIcqUIN();
        final String PASSWORD = System.getProperty("accounts.icq.TESTED_IMPL_PWD", null);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("USER_ID", USER_ID);
        props.put("PASSWORD", PASSWORD);
        try {
            providerFactory.installAccount(USER_ID, props);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String secondProviderID = IcqSlickFixture.testerAgent.getIcqUIN();
        ServiceReference[] icqProviderRefs = bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=ICQ)(USER_ID=" + secondProviderID + "))");
        TestOperationSetFileTransferImpl.assertNotNull((String)("No Protocol Provider was found for ICQ UIN:" + secondProviderID), (Object)icqProviderRefs);
        TestOperationSetFileTransferImpl.assertTrue((String)("No Protocol Provider was found for ICQ UIN:" + secondProviderID), (icqProviderRefs.length > 0 ? 1 : 0) != 0);
        ProtocolProviderService provider2 = (ProtocolProviderService)bc.getService(icqProviderRefs[0]);
        secondProviderAccount = provider2.getAccountID();
        Map supportedOperationSets2 = provider2.getSupportedOperationSets();
        if (supportedOperationSets2 == null || supportedOperationSets2.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this implementation. ");
        }
        opSetPresence2 = (OperationSetPresence)supportedOperationSets2.get(OperationSetPresence.class.getName());
        if (opSetPresence2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the PresenceOperationSets");
        }
        opSetFT2 = (OperationSetFileTransfer)supportedOperationSets2.get(OperationSetFileTransfer.class.getName());
        if (opSetFT2 == null) {
            throw new NullPointerException("An implementation of the service must provide an implementation of at least one of the FileTransferOperationSets");
        }
        provider2.addRegistrationStateChangeListener(new RegistrationStateChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void registrationStateChanged(RegistrationStateChangeEvent evt) {
                if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
                    try {
                        Object object = registrationLock;
                        synchronized (object) {
                            registrationLock.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error creating contactlist", (Throwable)e);
                    }
                }
            }
        });
        provider2.register(new SecurityAuthority(){

            public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues, int reasonCode) {
                return this.obtainCredentials(realm, defaultValues);
            }

            public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues) {
                defaultValues.setPassword(PASSWORD.toCharArray());
                return defaultValues;
            }

            public void setUserNameEditable(boolean isUserNameEditable) {
            }

            public boolean isUserNameEditable() {
                return false;
            }
        });
        Object object = registrationLock;
        synchronized (object) {
            logger.info((Object)"Waiting 1!");
            registrationLock.wait(60000L);
            logger.info((Object)"Stop waiting!");
        }
        TestOperationSetFileTransferImpl.fixture.provider.addRegistrationStateChangeListener(new RegistrationStateChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void registrationStateChanged(RegistrationStateChangeEvent evt) {
                if (evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
                    try {
                        TestOperationSetFileTransferImpl.this.prepareContactList();
                        Object object = registrationLock;
                        synchronized (object) {
                            registrationLock.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error creating contactlist", (Throwable)e);
                    }
                }
            }
        });
        TestOperationSetFileTransferImpl.fixture.provider.register(new SecurityAuthority(){

            public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues, int reasonCode) {
                return this.obtainCredentials(realm, defaultValues);
            }

            public UserCredentials obtainCredentials(String realm, UserCredentials defaultValues) {
                defaultValues.setPassword(System.getProperty("accounts.icq.TESTED_IMPL_PWD", null).toCharArray());
                return defaultValues;
            }

            public void setUserNameEditable(boolean isUserNameEditable) {
            }

            public boolean isUserNameEditable() {
                return false;
            }
        });
        object = registrationLock;
        synchronized (object) {
            logger.info((Object)"Waiting 2!");
            registrationLock.wait(60000L);
            logger.info((Object)"Stop waiting!");
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestOperationSetFileTransferImpl.class);
        suite.addTest((Test)new TestOperationSetFileTransferImpl("clearProviders"));
        return suite;
    }

    public void clearProviders() {
        fixture.tearDown();
        providerFactory.uninstallAccount(secondProviderAccount);
    }

    @Override
    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareContactList() throws Exception {
        Object object;
        if (this.getContact1() == null) {
            Object o;
            object = o = new Object();
            synchronized (object) {
                o.wait(2000L);
            }
            try {
                opSetPresence1.setAuthorizationHandler((AuthorizationHandler)new AuthHandler());
                opSetPresence1.subscribe(IcqSlickFixture.testerAgent.getIcqUIN());
            }
            catch (OperationFailedException operationFailedException) {
                // empty catch block
            }
        }
        if (this.getContact2() == null) {
            try {
                opSetPresence2.setAuthorizationHandler((AuthorizationHandler)new AuthHandler());
                opSetPresence2.subscribe(TestOperationSetFileTransferImpl.fixture.ourUserID);
            }
            catch (OperationFailedException o) {
                // empty catch block
            }
            logger.info((Object)"will wait till the list prepare is completed");
            object = o = new Object();
            synchronized (object) {
                o.wait(4000L);
            }
        }
    }

    @Override
    public OperationSetFileTransfer getOpSetFilTransfer1() {
        return opSetFT1;
    }

    @Override
    public OperationSetFileTransfer getOpSetFilTransfer2() {
        return opSetFT2;
    }

    @Override
    public BundleContext getContext() {
        return IcqSlickFixture.bc;
    }

    @Override
    public boolean enableTestSendAndReceive() {
        return true;
    }

    @Override
    public boolean enableTestSenderCancelBeforeAccepted() {
        return true;
    }

    @Override
    public boolean enableTestReceiverDecline() {
        return false;
    }

    @Override
    public boolean enableTestReceiverCancelsWhileTransfering() {
        return true;
    }

    @Override
    public boolean enableTestSenderCancelsWhileTransfering() {
        return true;
    }

    private class AuthHandler
    implements AuthorizationHandler {
        private AuthHandler() {
        }

        public AuthorizationResponse processAuthorisationRequest(AuthorizationRequest req, Contact sourceContact) {
            logger.trace((Object)("processAuthorisationRequest " + req + " " + sourceContact));
            return new AuthorizationResponse(AuthorizationResponse.ACCEPT, "");
        }

        public AuthorizationRequest createAuthorizationRequest(Contact contact) {
            logger.trace((Object)("createAuthorizationRequest " + contact));
            return new AuthorizationRequest();
        }

        public void processAuthorizationResponse(AuthorizationResponse response, Contact sourceContact) {
            logger.debug((Object)("auth response from: " + sourceContact.getAddress() + " " + response.getResponseCode().getCode()));
        }
    }
}

