/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Iterator;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.address.Address;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.CallSipImpl;
import net.java.sip.communicator.impl.protocol.sip.EventPackageNotifier;
import net.java.sip.communicator.impl.protocol.sip.EventPackageSubscriber;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorListener;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.impl.protocol.sip.sdp.SdpUtils;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallPeerAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.media.AbstractOperationSetTelephonyConferencing;
import net.java.sip.communicator.service.protocol.media.ConferenceInfoDocument;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.xml.XMLException;

public class OperationSetTelephonyConferencingSipImpl
extends AbstractOperationSetTelephonyConferencing<ProtocolProviderServiceSipImpl, OperationSetBasicTelephonySipImpl, CallSipImpl, CallPeerSipImpl, Address>
implements MethodProcessorListener {
    private static final Logger logger = Logger.getLogger(OperationSetTelephonyConferencingSipImpl.class);
    private static final String CONTENT_SUB_TYPE = "conference-info+xml";
    private static final String EVENT_PACKAGE = "conference";
    private static final int REFRESH_MARGIN = 60;
    private static final int SUBSCRIPTION_DURATION = 3600;
    private static final int MIN_NOTIFY_INTERVAL = 200;
    private final EventPackageNotifier notifier;
    private final EventPackageSubscriber subscriber;
    private final TimerScheduler timer = new TimerScheduler();
    private final CallPeerListener callPeerStateListener = new CallPeerAdapter(){

        public void peerStateChanged(CallPeerChangeEvent evt) {
            CallPeer peer = evt.getSourceCallPeer();
            if (peer != null && peer.getState() == CallPeerState.CONNECTED && peer.isConferenceFocus()) {
                ConferenceSubscriberSubscription subscription = new ConferenceSubscriberSubscription((CallPeerSipImpl)peer);
                try {
                    OperationSetTelephonyConferencingSipImpl.this.subscriber.subscribe(subscription);
                }
                catch (OperationFailedException ofe) {
                    logger.error((Object)("Failed to create or send a conference subscription to " + peer), (Throwable)ofe);
                }
                peer.removeCallPeerListener((CallPeerListener)this);
            }
        }
    };

    public OperationSetTelephonyConferencingSipImpl(ProtocolProviderServiceSipImpl parentProvider) {
        super((ProtocolProviderService)parentProvider);
        this.subscriber = new EventPackageSubscriber((ProtocolProviderServiceSipImpl)this.parentProvider, EVENT_PACKAGE, 3600, CONTENT_SUB_TYPE, this.timer, 60);
        this.notifier = new ConferenceEventPackageNotifier((ProtocolProviderServiceSipImpl)this.parentProvider, this.timer);
    }

    public void callPeerAdded(CallPeerEvent event) {
        super.callPeerAdded(event);
        CallPeer callPeer = event.getSourceCallPeer();
        if (callPeer instanceof CallPeerSipImpl) {
            ((CallPeerSipImpl)callPeer).addMethodProcessorListener(this);
        }
    }

    public void callPeerRemoved(CallPeerEvent event) {
        CallPeer callPeer = event.getSourceCallPeer();
        if (callPeer instanceof CallPeerSipImpl) {
            ((CallPeerSipImpl)callPeer).removeMethodProcessorListener(this);
        }
        super.callPeerRemoved(event);
    }

    protected CallSipImpl createOutgoingCall() throws OperationFailedException {
        return ((OperationSetBasicTelephonySipImpl)this.getBasicTelephony()).createOutgoingCall();
    }

    protected CallPeerSipImpl doInviteCalleeToCall(Address calleeAddress, CallSipImpl call) throws OperationFailedException {
        return call.invite(calleeAddress, null);
    }

    private void inviteCompleted(CallPeerSipImpl sourceCallPeer, Message remoteMessage, Message localMessage) {
        ContactHeader contactHeader = (ContactHeader)remoteMessage.getHeader("Contact");
        boolean conferenceFocus = false;
        if (contactHeader != null) {
            Iterator parameterNameIter = contactHeader.getParameterNames();
            while (parameterNameIter.hasNext()) {
                if (!"isfocus".equalsIgnoreCase(parameterNameIter.next().toString())) continue;
                conferenceFocus = true;
                break;
            }
        }
        sourceCallPeer.addCallPeerListener(this.callPeerStateListener);
        sourceCallPeer.setConferenceFocus(conferenceFocus);
        if (sourceCallPeer.isConferenceFocus() && sourceCallPeer.getState() == CallPeerState.CONNECTED) {
            ConferenceSubscriberSubscription subscription = new ConferenceSubscriberSubscription(sourceCallPeer);
            try {
                this.subscriber.subscribe(subscription);
            }
            catch (OperationFailedException ofe) {
                logger.error((Object)("Failed to create or send a conference subscription to " + (Object)((Object)sourceCallPeer)), (Throwable)ofe);
            }
        }
    }

    protected void notifyCallPeers(Call call) {
        this.notifyAll("active", null, call);
    }

    private void notifyAll(String subscriptionState, String reason, final Call call) {
        EventPackageNotifier.SubscriptionFilter subscriptionFilter = new EventPackageNotifier.SubscriptionFilter(){

            @Override
            public boolean accept(EventPackageNotifier.Subscription subscription) {
                return subscription instanceof ConferenceNotifierSubscription && call.equals((Object)((ConferenceNotifierSubscription)subscription).getCall());
            }
        };
        try {
            this.notifier.notifyAll(subscriptionState, reason, subscriptionFilter);
        }
        catch (OperationFailedException ofe) {
            logger.error((Object)("Failed to notify the conference subscriptions of " + call), (Throwable)ofe);
        }
    }

    protected Address parseAddressString(String calleeAddressString) throws OperationFailedException {
        try {
            return ((ProtocolProviderServiceSipImpl)this.parentProvider).parseAddressString(calleeAddressString);
        }
        catch (ParseException pe) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("Failed to parse callee address " + calleeAddressString, 11, pe, logger);
            return null;
        }
    }

    @Override
    public void requestProcessed(CallPeerSipImpl sourceCallPeer, Request request, Response response) {
        if ("INVITE".equalsIgnoreCase(request.getMethod()) && response != null && 200 == response.getStatusCode()) {
            this.inviteCompleted(sourceCallPeer, (Message)request, (Message)response);
        }
    }

    @Override
    public void responseProcessed(CallPeerSipImpl sourceCallPeer, Response response, Request request) {
        CSeqHeader cseqHeader;
        if (200 == response.getStatusCode() && (cseqHeader = (CSeqHeader)response.getHeader("CSeq")) != null && "INVITE".equalsIgnoreCase(cseqHeader.getMethod())) {
            this.inviteCompleted(sourceCallPeer, (Message)response, (Message)request);
        }
    }

    protected String getLocalEntity(CallPeer callPeer) {
        Address localPartyAddress;
        Dialog dialog;
        if (callPeer instanceof CallPeerSipImpl && (dialog = ((CallPeerSipImpl)callPeer).getDialog()) != null && (localPartyAddress = dialog.getLocalParty()) != null) {
            return OperationSetTelephonyConferencingSipImpl.stripParametersFromAddress((String)localPartyAddress.getURI().toString());
        }
        return null;
    }

    protected String getLocalDisplayName() {
        return ((ProtocolProviderServiceSipImpl)this.parentProvider).getOurDisplayName();
    }

    private class ConferenceEventPackageNotifier
    extends EventPackageNotifier {
        ConferenceEventPackageNotifier(ProtocolProviderServiceSipImpl protocolProvider, TimerScheduler timer) {
            super(protocolProvider, OperationSetTelephonyConferencingSipImpl.EVENT_PACKAGE, 3600, OperationSetTelephonyConferencingSipImpl.CONTENT_SUB_TYPE, timer);
        }

        @Override
        protected EventPackageNotifier.Subscription createSubscription(Address fromAddress, String eventId) {
            return new ConferenceNotifierSubscription(fromAddress, eventId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(final EventPackageNotifier.Subscription subscription, final String subscriptionState, final String reason) throws OperationFailedException {
            String callId;
            byte[] notifyContent;
            ConferenceInfoDocument diff;
            ConferenceNotifierSubscription conferenceSubscription = (ConferenceNotifierSubscription)subscription;
            Dialog dialog = conferenceSubscription.getDialog();
            CallPeerSipImpl callPeer = conferenceSubscription.getCallPeer();
            if (callPeer == null) {
                throw new OperationFailedException("Failed to find the CallPeer of the conference subscription " + conferenceSubscription, 4);
            }
            final long timeSinceLastNotify = System.currentTimeMillis() - callPeer.getLastConferenceInfoSentTimestamp();
            if (timeSinceLastNotify < 200L) {
                if (callPeer.isConfInfoScheduled()) {
                    return;
                }
                logger.info((Object)("Scheduling to send a conference-info NOTIFY to " + (Object)((Object)callPeer)));
                callPeer.setConfInfoScheduled(true);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(201L - timeSinceLastNotify);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        try {
                            ConferenceEventPackageNotifier.this.notify(subscription, subscriptionState, reason);
                        }
                        catch (OperationFailedException e) {
                            logger.error((Object)"Failed to send NOTIFY request");
                        }
                    }
                }).start();
                return;
            }
            ConferenceInfoDocument currentConfInfo = OperationSetTelephonyConferencingSipImpl.this.getCurrentConferenceInfo(callPeer);
            ConferenceInfoDocument lastSentConfInfo = callPeer.getLastConferenceInfoSent();
            ConferenceInfoDocument conferenceInfoDocument = diff = lastSentConfInfo == null ? currentConfInfo : OperationSetTelephonyConferencingSipImpl.this.getConferenceInfoDiff(lastSentConfInfo, currentConfInfo);
            if (diff == null) {
                callPeer.setConfInfoScheduled(false);
                return;
            }
            int newVersion = lastSentConfInfo == null ? 1 : lastSentConfInfo.getVersion() + 1;
            diff.setVersion(newVersion);
            String xml = diff.toXml();
            try {
                notifyContent = xml.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                logger.warn((Object)"Failed to gets bytes from String for the UTF-8 charset", (Throwable)uee);
                notifyContent = xml.getBytes();
            }
            Dialog dialog2 = dialog;
            synchronized (dialog2) {
                ClientTransaction transac = this.createNotify(dialog, notifyContent, subscriptionState, reason);
                callId = dialog.getCallId().getCallId();
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Sending conference-info NOTIFY (version " + newVersion + ") to " + (Object)((Object)callPeer)));
                    }
                    dialog.sendRequest(transac);
                    currentConfInfo.setVersion(newVersion);
                    callPeer.setLastConferenceInfoSent(currentConfInfo);
                    callPeer.setLastConferenceInfoSentTimestamp(System.currentTimeMillis());
                }
                catch (SipException sex) {
                    logger.error((Object)"Failed to send NOTIFY request.", (Throwable)sex);
                    throw new OperationFailedException("Failed to send NOTIFY request.", 2, (Throwable)sex);
                }
            }
            if ("terminated".equals(subscriptionState)) {
                this.removeSubscription(callId, subscription);
            }
            callPeer.setConfInfoScheduled(false);
        }
    }

    private class ConferenceSubscriberSubscription
    extends EventPackageSubscriber.Subscription {
        private final CallPeerSipImpl callPeer;

        public ConferenceSubscriberSubscription(CallPeerSipImpl callPeer) {
            super(callPeer.getPeerAddress());
            this.callPeer = callPeer;
        }

        @Override
        protected Dialog getDialog() {
            Dialog dialog = super.getDialog();
            if (dialog == null || DialogState.TERMINATED.equals((Object)dialog.getState())) {
                dialog = this.callPeer.getDialog();
            }
            return dialog;
        }

        @Override
        protected void processActiveRequest(RequestEvent requestEvent, byte[] rawContent) {
            if (rawContent != null) {
                try {
                    OperationSetTelephonyConferencingSipImpl.this.setConferenceInfoXML(this.callPeer, SdpUtils.getContentAsString((Message)requestEvent.getRequest()));
                }
                catch (XMLException e) {
                    logger.error((Object)("Could not handle conference-info NOTIFY sent to us by " + (Object)((Object)this.callPeer)));
                }
            }
        }

        @Override
        protected void processFailureResponse(ResponseEvent responseEvent, int statusCode) {
            this.callPeer.setConferenceFocus(false);
        }

        @Override
        protected void processSuccessResponse(ResponseEvent responseEvent, int statusCode) {
            switch (statusCode) {
                case 200: 
                case 202: {
                    this.callPeer.setConferenceFocus(true);
                }
            }
        }

        @Override
        protected void processTerminatedRequest(RequestEvent requestEvent, String reasonCode) {
            if ("deactivated".equals(reasonCode)) {
                try {
                    OperationSetTelephonyConferencingSipImpl.this.subscriber.poll(this);
                }
                catch (OperationFailedException ofe) {
                    logger.error((Object)("Failed to renew the conference subscription " + this), (Throwable)ofe);
                }
            }
        }
    }

    private class ConferenceNotifierSubscription
    extends EventPackageNotifier.Subscription {
        public ConferenceNotifierSubscription(Address fromAddress, String eventId) {
            super(fromAddress, eventId);
        }

        @Override
        protected byte[] createNotifyContent(String subscriptionState, String reason) {
            byte[] notifyContent;
            CallPeerSipImpl callPeer = this.getCallPeer();
            if (callPeer == null) {
                logger.error((Object)("Failed to find the CallPeer of the conference subscription " + this));
                return null;
            }
            ConferenceInfoDocument currentConfInfo = OperationSetTelephonyConferencingSipImpl.this.getCurrentConferenceInfo(callPeer);
            ConferenceInfoDocument lastSentConfInfo = callPeer.getLastConferenceInfoSent();
            ConferenceInfoDocument diff = currentConfInfo;
            if (diff == null) {
                return null;
            }
            int newVersion = lastSentConfInfo == null ? 1 : lastSentConfInfo.getVersion() + 1;
            diff.setVersion(newVersion);
            currentConfInfo.setVersion(newVersion);
            callPeer.setLastConferenceInfoSent(currentConfInfo);
            callPeer.setLastConferenceInfoSentTimestamp(System.currentTimeMillis());
            String xml = diff.toXml();
            try {
                notifyContent = xml.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                logger.warn((Object)"Failed to gets bytes from String for the UTF-8 charset", (Throwable)uee);
                notifyContent = xml.getBytes();
            }
            return notifyContent;
        }

        public CallSipImpl getCall() {
            CallPeerSipImpl callPeer = this.getCallPeer();
            return callPeer == null ? null : (CallSipImpl)callPeer.getCall();
        }

        private CallPeerSipImpl getCallPeer() {
            OperationSetBasicTelephonySipImpl basicTelephony;
            Dialog dialog = this.getDialog();
            if (dialog != null && (basicTelephony = (OperationSetBasicTelephonySipImpl)OperationSetTelephonyConferencingSipImpl.this.getBasicTelephony()) != null) {
                return basicTelephony.getActiveCallsRepository().findCallPeer(dialog);
            }
            return null;
        }
    }
}

