/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipProvider;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.MethodProcessorAdapter;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipStackSharing;
import net.java.sip.communicator.impl.protocol.sip.TimerScheduler;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.util.Logger;

public class EventPackageSupport
extends MethodProcessorAdapter {
    private static final Logger logger = Logger.getLogger(EventPackageSupport.class);
    protected final String contentSubType;
    protected final String eventPackage;
    protected final ProtocolProviderServiceSipImpl protocolProvider;
    protected final int subscriptionDuration;
    private final Map<String, Subscription> subscriptions = new HashMap<String, Subscription>();
    protected final TimerScheduler timer;

    protected EventPackageSupport(ProtocolProviderServiceSipImpl protocolProvider, String eventPackage, int subscriptionDuration, String contentSubType, TimerScheduler timer) {
        this.protocolProvider = protocolProvider;
        this.eventPackage = eventPackage;
        this.subscriptionDuration = subscriptionDuration;
        this.contentSubType = contentSubType;
        this.timer = timer != null ? timer : new TimerScheduler();
        this.protocolProvider.registerEvent(this.eventPackage);
        this.protocolProvider.registerMethodProcessor("SUBSCRIBE", this);
        this.protocolProvider.registerMethodProcessor("NOTIFY", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscription(String callId, Subscription subscription) {
        Map<String, Subscription> map = this.subscriptions;
        synchronized (map) {
            Subscription existingSubscription = this.subscriptions.get(callId);
            if (existingSubscription != null) {
                this.removeSubscription(callId, existingSubscription);
            }
            this.subscriptions.put(callId, subscription);
        }
    }

    public final String getEventPackage() {
        return this.eventPackage;
    }

    static ServerTransaction getOrCreateServerTransaction(RequestEvent requestEvent) {
        ServerTransaction serverTransaction = null;
        try {
            serverTransaction = SipStackSharing.getOrCreateServerTransaction(requestEvent);
        }
        catch (TransactionAlreadyExistsException ex) {
            logger.error((Object)"Failed to create a new servertransaction for an incoming request\n(Next message contains the request)", (Throwable)ex);
        }
        catch (TransactionUnavailableException ex) {
            logger.error((Object)"Failed to create a new servertransaction for an incoming request\n(Next message contains the request)", (Throwable)ex);
        }
        return serverTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription getSubscription(Address toAddress, String eventId) {
        Map<String, Subscription> map = this.subscriptions;
        synchronized (map) {
            for (Subscription subscription : this.subscriptions.values()) {
                if (!subscription.equals(toAddress, eventId)) continue;
                return subscription;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription getSubscription(String callId) {
        Map<String, Subscription> map = this.subscriptions;
        synchronized (map) {
            return this.subscriptions.get(callId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subscription[] getSubscriptions() {
        Map<String, Subscription> map = this.subscriptions;
        synchronized (map) {
            Collection<Subscription> subscriptions = this.subscriptions.values();
            return subscriptions.toArray(new Subscription[subscriptions.size()]);
        }
    }

    protected void processAuthenticationChallenge(ClientTransaction clientTransaction, Response response, SipProvider jainSipProvider) throws OperationFailedException {
        EventPackageSupport.processAuthenticationChallenge(this.protocolProvider, clientTransaction, response, jainSipProvider);
    }

    static void processAuthenticationChallenge(ProtocolProviderServiceSipImpl protocolProvider, ClientTransaction clientTransaction, Response response, SipProvider jainSipProvider) throws OperationFailedException {
        try {
            ClientTransaction retryTran;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authenticating a message request.");
            }
            if ((retryTran = protocolProvider.getSipSecurityManager().handleChallenge(response, clientTransaction, jainSipProvider)) == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"No password supplied or error occured!");
                }
                return;
            }
            retryTran.sendRequest();
        }
        catch (Exception exc) {
            logger.error((Object)"We failed to authenticate a message request.", (Throwable)exc);
            throw new OperationFailedException("Failed to authenticate a message request", 4, (Throwable)exc);
        }
    }

    public void removeSubscription(Address toAddress) {
        this.removeSubscription(toAddress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSubscription(Address toAddress, String eventId) {
        boolean removed = false;
        Map<String, Subscription> map = this.subscriptions;
        synchronized (map) {
            Iterator<Map.Entry<String, Subscription>> subscriptionIter = this.subscriptions.entrySet().iterator();
            while (subscriptionIter.hasNext()) {
                Map.Entry<String, Subscription> subscriptionEntry = subscriptionIter.next();
                Subscription subscription = subscriptionEntry.getValue();
                if (!subscription.equals(toAddress, eventId)) continue;
                subscriptionIter.remove();
                removed = true;
                subscription.removed();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSubscription(String callId, Subscription subscription) {
        Map<String, Subscription> map = this.subscriptions;
        synchronized (map) {
            Subscription subscriptionToRemove = this.subscriptions.get(callId);
            if (subscriptionToRemove != null && subscriptionToRemove.equals(subscription)) {
                subscription = this.subscriptions.remove(callId);
                subscription.removed();
                return true;
            }
        }
        return false;
    }

    public static boolean sendNotImplementedResponse(ProtocolProviderServiceSipImpl provider, RequestEvent requestEvent) {
        Response response;
        ServerTransaction serverTransaction = EventPackageSupport.getOrCreateServerTransaction(requestEvent);
        if (serverTransaction == null) {
            return false;
        }
        Request request = requestEvent.getRequest();
        try {
            response = provider.getMessageFactory().createResponse(501, request);
        }
        catch (ParseException e) {
            logger.error((Object)"Error while creating 501 response", (Throwable)e);
            return false;
        }
        try {
            serverTransaction.sendResponse(response);
        }
        catch (Exception e) {
            logger.error((Object)"Error while sending the response 501", (Throwable)e);
            return false;
        }
        return true;
    }

    protected static class Subscription {
        protected final Address address;
        private Dialog dialog;
        protected final String eventId;
        private TimerTask timerTask;

        public Subscription(Address address, String eventId) {
            if (address == null) {
                throw new NullPointerException("address");
            }
            this.address = address;
            this.eventId = eventId;
        }

        protected boolean addressEquals(Address address) {
            return this.getAddress().equals((Object)address);
        }

        protected boolean equals(Address address, String eventId) {
            String thisEventId;
            return this.addressEquals(address) && ((thisEventId = this.getEventId()) == null && eventId == null || thisEventId != null && thisEventId.equals(eventId));
        }

        public final Address getAddress() {
            return this.address;
        }

        protected Dialog getDialog() {
            return this.dialog;
        }

        public final String getEventId() {
            return this.eventId;
        }

        protected void removed() {
            this.setDialog(null);
            this.setTimerTask(null);
        }

        protected void setDialog(Dialog dialog) {
            this.dialog = dialog;
        }

        protected void setTimerTask(TimerTask timerTask) {
            if (this.timerTask != timerTask) {
                if (this.timerTask != null) {
                    this.timerTask.cancel();
                }
                this.timerTask = timerTask;
            }
        }
    }
}

