/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.dim;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import net.kano.joscar.DefensiveTools;
import org.jetbrains.annotations.Nullable;

public abstract class Attachment {
    private final String id;
    private final long length;

    public Attachment(String id, long length) {
        DefensiveTools.checkNull(id, "id");
        DefensiveTools.checkRange(length, "length", 0L);
        this.id = id;
        this.length = length;
    }

    public abstract ReadableByteChannel openForReading() throws IOException;

    public abstract WritableByteChannel openForWriting() throws IOException;

    @Nullable
    public abstract SelectableChannel getSelectableForWriting();

    public String getId() {
        return this.id;
    }

    public long getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attachment that = (Attachment)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

