/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendbl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.sendbl.SendBuddyListGroup;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendBuddyListRvCmd
extends AbstractRequestRvCmd {
    private final List<SendBuddyListGroup> groups;

    public SendBuddyListRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        ByteBlock serviceData = this.getServiceData();
        this.groups = serviceData == null ? null : SendBuddyListGroup.readBuddyListGroups(serviceData);
    }

    public SendBuddyListRvCmd(Collection<SendBuddyListGroup> groups) {
        super(CapabilityBlock.BLOCK_SENDBUDDYLIST);
        this.groups = DefensiveTools.getSafeNonnullListCopy(groups, "groups");
    }

    public final List<SendBuddyListGroup> getGroups() {
        return this.groups;
    }

    @Override
    protected void writeServiceData(OutputStream out) throws IOException {
        for (SendBuddyListGroup group : this.groups) {
            group.write(out);
        }
    }

    @Override
    protected void writeRvTlvs(OutputStream out) throws IOException {
    }

    public String toString() {
        return "SendBuddyListRvCmd: " + this.groups;
    }
}

