/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.state;

import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.domain.IRCServer;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.domain.WritableIRCChannel;
import com.ircclouds.irc.api.state.IIRCState;
import com.ircclouds.irc.api.utils.SynchronizedUnmodifiableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IRCStateImpl
implements IIRCState {
    private String nickname;
    private String ident;
    private String realname;
    private List<String> altNicks;
    private IRCServer ircServer;
    private IRCServerOptions serverOptions;
    private SynchronizedUnmodifiableList<? extends IRCChannel> channels = new SynchronizedUnmodifiableList(new ArrayList());
    private boolean isConnected;
    private IRCStateImpl previousState;

    IRCStateImpl(String aIdent, String aRealname, List<String> aAltNicks, IRCServer aIRCServer, IRCServerOptions aServerOptions) {
        this.ident = aIdent;
        this.realname = aRealname;
        this.ircServer = aIRCServer;
        this.serverOptions = aServerOptions;
        this.altNicks = aAltNicks;
    }

    public IRCStateImpl(String aNickname, String aIdent, String aRealname, List<String> aAltNicks, IRCServer aIRCServer, IRCServerOptions aServerOptions) {
        this.nickname = aNickname;
        this.ident = aIdent;
        this.realname = aRealname;
        this.ircServer = aIRCServer;
        this.serverOptions = aServerOptions;
        this.altNicks = aAltNicks;
        this.previousState = new IRCStateImpl(aIdent, aRealname, aAltNicks, aIRCServer, aServerOptions);
        this.previousState.updateNick(this.nickname);
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public List<String> getAltNicks() {
        return Collections.unmodifiableList(this.altNicks);
    }

    @Override
    public String getRealname() {
        return this.realname;
    }

    @Override
    public String getIdent() {
        return this.ident;
    }

    void updateNick(String aNickname) {
        this.nickname = aNickname;
    }

    SynchronizedUnmodifiableList<WritableIRCChannel> getChannelsMutable() {
        return this.channels;
    }

    WritableIRCChannel getWritableChannelByName(String aChannelName) {
        return this.getChannelByNameGeneric(aChannelName, new GetChannelCallback<WritableIRCChannel>(){

            @Override
            public WritableIRCChannel onReady(IRCChannel aChan) {
                return (WritableIRCChannel)aChan;
            }
        });
    }

    @Override
    public IRCServer getServer() {
        return this.ircServer;
    }

    @Override
    public List<IRCChannel> getChannels() {
        return this.channels;
    }

    @Override
    public IRCChannel getChannelByName(String aChannelName) {
        return this.getChannelByNameGeneric(this.prependChanType(aChannelName), new GetChannelCallback<IRCChannel>(){

            @Override
            public IRCChannel onReady(IRCChannel aChan) {
                return aChan;
            }
        });
    }

    @Override
    public IRCServerOptions getServerOptions() {
        return this.serverOptions;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean aIsConnected) {
        this.isConnected = aIsConnected;
    }

    @Override
    public IIRCState getPrevious() {
        return this.previousState;
    }

    private String prependChanType(String aChannelName) {
        for (Character _c : this.getServerOptions().getChanTypes()) {
            if (!_c.equals(Character.valueOf(aChannelName.charAt(0)))) continue;
            return aChannelName;
        }
        return this.getServerOptions().getChanTypes().iterator().next() + aChannelName;
    }

    private <T> T getChannelByNameGeneric(String aChannelName, GetChannelCallback<T> aCallback) {
        for (IRCChannel iRCChannel : this.channels) {
            if (!iRCChannel.getName().equalsIgnoreCase(aChannelName)) continue;
            return aCallback.onReady(iRCChannel);
        }
        return null;
    }

    private static interface GetChannelCallback<T> {
        public T onReady(IRCChannel var1);
    }
}

