/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig.autoaway;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.generalconfig.GeneralConfigPluginActivator;
import net.java.sip.communicator.plugin.generalconfig.Resources;
import net.java.sip.communicator.plugin.generalconfig.autoaway.Preferences;
import org.jitsi.service.resources.ResourceManagementService;

public class AutoAwayConfigurationPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private JCheckBox enable;
    private JSpinner timer;

    public AutoAwayConfigurationPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        JPanel pnlSection = GeneralConfigPluginActivator.createConfigSectionComponent(Resources.getString("service.gui.STATUS"));
        pnlSection.add(this.createMainPanel());
        this.add(pnlSection);
        this.initValues();
    }

    private Component createMainPanel() {
        ResourceManagementService resources = GeneralConfigPluginActivator.getResources();
        this.enable = new SIPCommCheckBox(resources.getI18NString("plugin.autoaway.ENABLE_CHANGE_STATUS"));
        this.enable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoAwayConfigurationPanel.this.timer.setEnabled(AutoAwayConfigurationPanel.this.enable.isSelected());
                AutoAwayConfigurationPanel.this.saveData();
            }
        });
        this.timer = new JSpinner(new SpinnerNumberModel(15, 1, 180, 1));
        this.timer.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AutoAwayConfigurationPanel.this.saveData();
            }
        });
        TransparentPanel timerPanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
        timerPanel.add(new JLabel(resources.getI18NString("plugin.autoaway.AWAY_MINUTES")));
        timerPanel.add(this.timer);
        try {
            ((DefaultFormatter)((JSpinner.DefaultEditor)this.timer.getEditor()).getTextField().getFormatter()).setCommitsOnValidEdit(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TransparentPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        mainPanel.add((Component)this.enable, "North");
        mainPanel.add((Component)timerPanel, "West");
        return mainPanel;
    }

    private void initValues() {
        boolean enabled = Preferences.isEnabled();
        this.enable.setSelected(enabled);
        this.timer.setEnabled(enabled);
        int timerValue = Preferences.getTimer();
        SpinnerNumberModel model = (SpinnerNumberModel)this.timer.getModel();
        if (timerValue < (Integer)model.getMinimum() || timerValue > (Integer)model.getMaximum()) {
            timerValue = 15;
        }
        this.timer.setValue(timerValue);
    }

    private void saveData() {
        Preferences.saveData(this.enable.isSelected(), this.timer.getValue().toString());
    }
}

