/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.CommandFactory;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.exception.BadCommandException;
import net.java.sip.communicator.impl.protocol.irc.exception.UnsupportedCommandException;
import org.easymock.EasyMock;

public class CommandFactoryTest
extends TestCase {
    public void testCommandsAvailable() {
        Assert.assertNotNull(CommandFactory.getCommands());
    }

    public void testRegisterNullCommand() {
        try {
            CommandFactory.registerCommand(null, Test.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRegisterNullType() {
        try {
            CommandFactory.registerCommand("test", null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRegisterCorrectCommand() {
        CommandFactory.registerCommand("test", Test.class);
        Assert.assertEquals((int)1, (int)CommandFactory.getCommands().size());
        Assert.assertEquals(Test.class, CommandFactory.getCommands().get("test"));
        CommandFactory.unregisterCommand(Test.class, "test");
        Assert.assertEquals((int)0, (int)CommandFactory.getCommands().size());
    }

    public void testRegisterMultipleCommandsForType() {
        CommandFactory.registerCommand("test", Test.class);
        CommandFactory.registerCommand("bla", Test.class);
        Assert.assertEquals(Test.class, CommandFactory.getCommands().get("test"));
        Assert.assertEquals(Test.class, CommandFactory.getCommands().get("bla"));
        Assert.assertEquals((int)2, (int)CommandFactory.getCommands().size());
        CommandFactory.unregisterCommand(Test.class, null);
        Assert.assertEquals((int)0, (int)CommandFactory.getCommands().size());
    }

    public void testUnregisterMultipleAmongOtherTypes() {
        Command anotherType = new Command(){

            @Override
            public void execute(String source, String line) {
            }

            @Override
            public String help() {
                return null;
            }
        };
        CommandFactory.registerCommand("test", Test.class);
        CommandFactory.registerCommand("foo", anotherType.getClass());
        CommandFactory.registerCommand("bla", Test.class);
        Assert.assertEquals(Test.class, CommandFactory.getCommands().get("test"));
        Assert.assertEquals(Test.class, CommandFactory.getCommands().get("bla"));
        Assert.assertNotNull(CommandFactory.getCommands().get("foo"));
        Assert.assertEquals((int)3, (int)CommandFactory.getCommands().size());
        CommandFactory.unregisterCommand(Test.class, null);
        Assert.assertEquals((int)1, (int)CommandFactory.getCommands().size());
        Assert.assertNotSame(Test.class, CommandFactory.getCommands().get("foo"));
        CommandFactory.unregisterCommand(anotherType.getClass(), null);
    }

    public void testUnregisterOneAmongMultipleSameType() {
        CommandFactory.registerCommand("test", Test.class);
        CommandFactory.registerCommand("bla", Test.class);
        Assert.assertEquals(Test.class, CommandFactory.getCommands().get("test"));
        Assert.assertEquals(Test.class, CommandFactory.getCommands().get("bla"));
        Assert.assertEquals((int)2, (int)CommandFactory.getCommands().size());
        CommandFactory.unregisterCommand(Test.class, "test");
        Assert.assertEquals((int)1, (int)CommandFactory.getCommands().size());
        Assert.assertEquals(Test.class, CommandFactory.getCommands().get("bla"));
        CommandFactory.unregisterCommand(Test.class, null);
    }

    public void testConstructionNullProvider() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{connection});
        try {
            new CommandFactory(null, connection);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructionNullConnection() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        EasyMock.replay((Object[])new Object[]{provider});
        try {
            new CommandFactory(provider, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstruction() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        new CommandFactory(provider, connection);
    }

    public void testNonExistingCommand() throws BadCommandException {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        try {
            CommandFactory factory = new CommandFactory(provider, connection);
            factory.createCommand("test");
            Assert.fail();
        }
        catch (UnsupportedCommandException unsupportedCommandException) {
            // empty catch block
        }
    }

    public void testCreateNullCommandName() throws UnsupportedCommandException, BadCommandException {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        CommandFactory.registerCommand("test", Test.class);
        try {
            CommandFactory factory = new CommandFactory(provider, connection);
            factory.createCommand(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CommandFactory.unregisterCommand(Test.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateEmptyCommandName() throws UnsupportedCommandException, BadCommandException {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        CommandFactory.registerCommand("test", Unreachable.class);
        try {
            CommandFactory factory = new CommandFactory(provider, connection);
            factory.createCommand("");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            CommandFactory.unregisterCommand(Test.class, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExistingCommand() throws UnsupportedCommandException, BadCommandException {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        CommandFactory.registerCommand("test", Test.class);
        try {
            CommandFactory factory = new CommandFactory(provider, connection);
            Command cmd = factory.createCommand("test");
            Assert.assertNotNull((Object)cmd);
            Assert.assertTrue((boolean)(cmd instanceof Test));
        }
        finally {
            CommandFactory.unregisterCommand(Test.class, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnreachableCommand() throws UnsupportedCommandException {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        CommandFactory.registerCommand("test", Unreachable.class);
        try {
            CommandFactory factory = new CommandFactory(provider, connection);
            factory.createCommand("test");
            Assert.fail();
        }
        catch (BadCommandException badCommandException) {
        }
        finally {
            CommandFactory.unregisterCommand(Unreachable.class, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadCommand() throws UnsupportedCommandException {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        CommandFactory.registerCommand("test", BadImplementation.class);
        try {
            CommandFactory factory = new CommandFactory(provider, connection);
            factory.createCommand("test");
            Assert.fail();
        }
        catch (BadCommandException badCommandException) {
        }
        finally {
            CommandFactory.unregisterCommand(BadImplementation.class, null);
        }
    }

    public static abstract class BadImplementation
    implements Command {
        public BadImplementation(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        }
    }

    private static final class Unreachable
    implements Command {
        private Unreachable(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        }

        @Override
        public void execute(String source, String line) {
        }

        @Override
        public String help() {
            return null;
        }
    }

    public static class Test
    implements Command {
        public Test(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        }

        @Override
        public void execute(String source, String line) {
        }

        @Override
        public String help() {
            return null;
        }
    }
}

