/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol;

import java.io.IOException;
import java.util.Vector;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import net.sf.fmj.media.protocol.CloneableSourceStreamAdapter;
import net.sf.fmj.media.protocol.SourceStreamSlave;

class SuperCloneableDataSource
extends DataSource {
    protected DataSource input;
    public CloneableSourceStreamAdapter[] streamsAdapters;
    public SourceStream[] streams = null;
    private Vector clones = new Vector();

    SuperCloneableDataSource(DataSource input) {
        this.input = input;
        SourceStream[] originalStreams = null;
        if (input instanceof PullDataSource) {
            originalStreams = ((PullDataSource)input).getStreams();
        }
        if (input instanceof PushDataSource) {
            originalStreams = ((PushDataSource)input).getStreams();
        }
        if (input instanceof PullBufferDataSource) {
            originalStreams = ((PullBufferDataSource)input).getStreams();
        }
        if (input instanceof PushBufferDataSource) {
            originalStreams = ((PushBufferDataSource)input).getStreams();
        }
        this.streamsAdapters = new CloneableSourceStreamAdapter[originalStreams.length];
        for (int i = 0; i < originalStreams.length; ++i) {
            this.streamsAdapters[i] = new CloneableSourceStreamAdapter(originalStreams[i]);
        }
    }

    @Override
    public void connect() throws IOException {
        this.input.connect();
    }

    DataSource createClone() {
        DataSource newSlave = this.input instanceof PullDataSource || this.input instanceof PushDataSource ? new PushDataSourceSlave() : new PushBufferDataSourceSlave();
        this.clones.addElement(newSlave);
        try {
            newSlave.connect();
        }
        catch (IOException e) {
            return null;
        }
        return newSlave;
    }

    @Override
    public void disconnect() {
        this.input.disconnect();
    }

    @Override
    public String getContentType() {
        return this.input.getContentType();
    }

    @Override
    public Object getControl(String controlType) {
        return this.input.getControl(controlType);
    }

    @Override
    public Object[] getControls() {
        return this.input.getControls();
    }

    @Override
    public Time getDuration() {
        return this.input.getDuration();
    }

    @Override
    public void start() throws IOException {
        this.input.start();
    }

    @Override
    public void stop() throws IOException {
        this.input.stop();
    }

    class PushDataSourceSlave
    extends PushDataSource {
        PushSourceStream[] streams = null;

        public PushDataSourceSlave() {
            this.streams = new PushSourceStream[SuperCloneableDataSource.this.streamsAdapters.length];
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i] = (PushSourceStream)SuperCloneableDataSource.this.streamsAdapters[i].createSlave();
            }
        }

        @Override
        public void connect() throws IOException {
            for (int i = 0; i < this.streams.length; ++i) {
                ((SourceStreamSlave)((Object)this.streams[i])).connect();
            }
        }

        @Override
        public void disconnect() {
            for (int i = 0; i < this.streams.length; ++i) {
                ((SourceStreamSlave)((Object)this.streams[i])).disconnect();
            }
        }

        @Override
        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        @Override
        public Object getControl(String controlType) {
            return SuperCloneableDataSource.this.input.getControl(controlType);
        }

        @Override
        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        @Override
        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }

        @Override
        public PushSourceStream[] getStreams() {
            return this.streams;
        }

        @Override
        public void start() throws IOException {
        }

        @Override
        public void stop() throws IOException {
        }
    }

    class PushBufferDataSourceSlave
    extends PushBufferDataSource {
        PushBufferStream[] streams = null;

        public PushBufferDataSourceSlave() {
            this.streams = new PushBufferStream[SuperCloneableDataSource.this.streamsAdapters.length];
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i] = (PushBufferStream)SuperCloneableDataSource.this.streamsAdapters[i].createSlave();
            }
        }

        @Override
        public void connect() throws IOException {
            for (int i = 0; i < this.streams.length; ++i) {
                ((SourceStreamSlave)((Object)this.streams[i])).connect();
            }
        }

        @Override
        public void disconnect() {
            for (int i = 0; i < this.streams.length; ++i) {
                ((SourceStreamSlave)((Object)this.streams[i])).disconnect();
            }
        }

        @Override
        public String getContentType() {
            return SuperCloneableDataSource.this.input.getContentType();
        }

        @Override
        public Object getControl(String controlType) {
            return SuperCloneableDataSource.this.input.getControl(controlType);
        }

        @Override
        public Object[] getControls() {
            return SuperCloneableDataSource.this.input.getControls();
        }

        @Override
        public Time getDuration() {
            return SuperCloneableDataSource.this.input.getDuration();
        }

        @Override
        public PushBufferStream[] getStreams() {
            return this.streams;
        }

        @Override
        public void start() throws IOException {
        }

        @Override
        public void stop() throws IOException {
        }
    }
}

