/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.Duration;
import javax.media.Time;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullBufferStream;

public class MergingPullBufferDataSource
extends PullBufferDataSource {
    protected final List<PullBufferDataSource> sources;

    public MergingPullBufferDataSource(List<PullBufferDataSource> sources) {
        this.sources = sources;
    }

    @Override
    public void connect() throws IOException {
        for (PullBufferDataSource source : this.sources) {
            source.connect();
        }
    }

    @Override
    public void disconnect() {
        for (PullBufferDataSource source : this.sources) {
            source.disconnect();
        }
    }

    @Override
    public String getContentType() {
        for (int i = 0; i < this.sources.size(); ++i) {
            if (this.sources.get(i).getContentType().equals(this.sources.get(0).getContentType())) continue;
            return "application.mixed-data";
        }
        return this.sources.get(0).getContentType();
    }

    @Override
    public Object getControl(String controlType) {
        for (PullBufferDataSource source : this.sources) {
            Object control = source.getControl(controlType);
            if (control == null) continue;
            return control;
        }
        return null;
    }

    @Override
    public Object[] getControls() {
        ArrayList<Object> controls = new ArrayList<Object>();
        for (PullBufferDataSource source : this.sources) {
            for (Object control : source.getControls()) {
                controls.add(control);
            }
        }
        return controls.toArray(new Object[0]);
    }

    @Override
    public Time getDuration() {
        ArrayList<Time> durations = new ArrayList<Time>();
        for (PullBufferDataSource source : this.sources) {
            durations.add(source.getDuration());
        }
        for (Time duration : durations) {
            if (duration.getNanoseconds() != Duration.DURATION_UNKNOWN.getNanoseconds()) continue;
            return Duration.DURATION_UNKNOWN;
        }
        for (Time duration : durations) {
            if (duration.getNanoseconds() != Duration.DURATION_UNBOUNDED.getNanoseconds()) continue;
            return Duration.DURATION_UNBOUNDED;
        }
        long max = -1L;
        for (Time duration : durations) {
            if (duration.getNanoseconds() <= max) continue;
            max = duration.getNanoseconds();
        }
        if (max < 0L) {
            return Duration.DURATION_UNKNOWN;
        }
        return new Time(max);
    }

    @Override
    public PullBufferStream[] getStreams() {
        ArrayList<PullBufferStream> streams = new ArrayList<PullBufferStream>();
        for (PullBufferDataSource source : this.sources) {
            for (PullBufferStream stream : source.getStreams()) {
                streams.add(stream);
            }
        }
        return streams.toArray(new PullBufferStream[0]);
    }

    @Override
    public void start() throws IOException {
        for (PullBufferDataSource source : this.sources) {
            source.start();
        }
    }

    @Override
    public void stop() throws IOException {
        for (PullBufferDataSource source : this.sources) {
            source.stop();
        }
    }
}

