/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.jibri;

import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.provider.ProviderManager;

public class JibriStatusPacketExt
extends AbstractPacketExtension {
    public static final String NAMESPACE = "http://jitsi.org/protocol/jibri";
    public static final String ELEMENT_NAME = "jibri-status";
    private static final String STATUS_ATTRIBUTE = "status";

    public JibriStatusPacketExt() {
        super(NAMESPACE, ELEMENT_NAME);
    }

    public static void registerExtensionProvider() {
        ProviderManager.getInstance().addExtensionProvider(ELEMENT_NAME, NAMESPACE, new DefaultPacketExtensionProvider<JibriStatusPacketExt>(JibriStatusPacketExt.class));
    }

    public Status getStatus() {
        return Status.parse(this.getAttributeAsString(STATUS_ATTRIBUTE));
    }

    public void setStatus(Status status) {
        this.setAttribute(STATUS_ATTRIBUTE, String.valueOf((Object)status));
    }

    public static enum Status {
        IDLE("idle"),
        BUSY("busy"),
        UNDEFINED("undefined");

        private String name;

        private Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Status parse(String status) {
            if (StringUtils.isNullOrEmpty((String)status)) {
                return UNDEFINED;
            }
            try {
                return Status.valueOf(status.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNDEFINED;
            }
        }
    }
}

