/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import net.java.sip.communicator.impl.protocol.jabber.JabberLoginStrategy;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;
import org.jitsi.util.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPException;

class LoginByClientCertificateStrategy
implements JabberLoginStrategy {
    private static final Logger logger = Logger.getLogger(LoginByClientCertificateStrategy.class);
    private AccountID accountID;

    public LoginByClientCertificateStrategy(AccountID accountID) {
        this.accountID = accountID;
    }

    @Override
    public UserCredentials prepareLogin(SecurityAuthority authority, int reasonCode) {
        return null;
    }

    @Override
    public boolean loginPreparationSuccessful() {
        return true;
    }

    @Override
    public boolean isTlsRequired() {
        return true;
    }

    @Override
    public SSLContext createSslContext(CertificateService cs, X509TrustManager trustManager) throws GeneralSecurityException {
        String certConfigName = this.accountID.getAccountPropertyString((Object)"CLIENT_TLS_CERTIFICATE");
        return cs.getSSLContext(certConfigName, trustManager);
    }

    @Override
    public boolean login(Connection connection, String userName, String resource) throws XMPPException {
        SASLAuthentication.supportSASLMechanism((String)"EXTERNAL", (int)0);
        try {
            connection.login("", "", resource);
            return true;
        }
        catch (XMPPException ex) {
            if (ex.getMessage().contains("EXTERNAL failed: not-authorized")) {
                logger.error((Object)"Certificate login failed", (Throwable)ex);
                return false;
            }
            throw ex;
        }
    }
}

