/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.DeleteItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.SsiDataModResponse;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.BuddyItem;
import net.kano.joscar.ssiitem.GroupItem;
import net.kano.joscar.ssiitem.RootItem;
import net.kano.joustsim.oscar.oscar.service.ssi.AddMutableGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.Group;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableBuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddy;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddyGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiBuddy;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiBuddyGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiServiceImpl;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiSyntheticGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiTools;
import net.kano.joustsim.oscar.oscar.service.ssi.SyntheticGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SsiBuddyList
extends SimpleBuddyList
implements MutableBuddyList {
    private final SsiServiceImpl service;
    private final SsiSyntheticGroup syntheticGroup;

    protected SsiBuddyList(SsiServiceImpl service) {
        this.service = service;
        this.syntheticGroup = new SsiSyntheticGroup(service, this);
        service.addItemChangeListener(this);
    }

    @Override
    protected SyntheticGroup getSyntheticGroup() {
        return this.syntheticGroup;
    }

    @Override
    protected SimpleBuddy createBuddy(BuddyItem buddyItem) {
        return new SsiBuddy(this, buddyItem);
    }

    @Override
    protected SimpleBuddyGroup createBuddyGroup(GroupItem groupItem) {
        return new SsiBuddyGroup(this, groupItem);
    }

    @Override
    public void addGroup(String name) {
        final int id = this.service.getUniqueGroupId();
        CreateItemsCmd cmd = new CreateItemsCmd(new GroupItem(name, id).toSsiItem());
        this.service.sendSsiModification(cmd, new SnacRequestAdapter(){

            public void handleResponse(SnacResponseEvent e) {
                RootItem rootItem;
                SsiDataModResponse dataModResponse;
                int result;
                if (e.getSnacCommand() instanceof SsiDataModResponse && (result = (dataModResponse = (SsiDataModResponse)e.getSnacCommand()).getResults()[0]) == 0 && (rootItem = SsiBuddyList.this.getRootItem()) != null) {
                    this.addGroupToRootItem(rootItem, id);
                }
            }

            private boolean addGroupToRootItem(RootItem rootItem, int id2) {
                int[] newIds;
                int[] oldIds = rootItem.getGroupids();
                if (oldIds == null) {
                    newIds = new int[1];
                } else {
                    for (int oldId : oldIds) {
                        if (oldId != id2) continue;
                        return false;
                    }
                    newIds = new int[oldIds.length + 1];
                    System.arraycopy(oldIds, 0, newIds, 0, oldIds.length);
                }
                newIds[newIds.length - 1] = id2;
                RootItem newRootItem = new RootItem(rootItem);
                newRootItem.setGroupids(newIds);
                ModifyItemsCmd cmd2 = new ModifyItemsCmd(newRootItem.toSsiItem());
                SsiBuddyList.this.service.sendSsiModification(cmd2);
                return true;
            }
        });
    }

    @Override
    public void moveBuddies(Collection<? extends Buddy> buddies, AddMutableGroup group) {
        List<Buddy> ingroup;
        HashMap<Group, ArrayList<Buddy>> group2buddy = new HashMap<Group, ArrayList<Buddy>>();
        for (Buddy buddy : buddies) {
            for (Group group2 : this.getGroups()) {
                if (group2 == group || !group2.getBuddiesCopy().contains(buddy)) continue;
                ingroup = (List)group2buddy.get(group2);
                if (ingroup == null) {
                    ingroup = new ArrayList<Buddy>();
                    group2buddy.put(group2, (ArrayList<Buddy>)ingroup);
                }
                ingroup.add(buddy);
            }
        }
        LinkedHashSet<Buddy> toAdd = new LinkedHashSet<Buddy>();
        for (Map.Entry entry : group2buddy.entrySet()) {
            Group group3 = (Group)entry.getKey();
            ingroup = (ArrayList<Buddy>)entry.getValue();
            if (group3 instanceof MutableGroup) {
                MutableGroup mutableGroup = (MutableGroup)group3;
                mutableGroup.deleteBuddies(ingroup);
            }
            toAdd.addAll(ingroup);
        }
        group.copyBuddies(toAdd);
    }

    @Override
    public void deleteGroupAndBuddies(Group group) {
        Integer groupid;
        ArrayList<SsiItem> items = new ArrayList<SsiItem>();
        for (Buddy buddy : group.getBuddiesCopy()) {
            if (!(buddy instanceof SimpleBuddy)) continue;
            SimpleBuddy simpleBuddy = (SimpleBuddy)buddy;
            items.add(simpleBuddy.getItem().toSsiItem());
        }
        assert (SsiTools.isOnlyBuddies(items));
        if (group instanceof SimpleBuddyGroup) {
            SimpleBuddyGroup simpleBuddyGroup = (SimpleBuddyGroup)group;
            SsiItem groupItem = simpleBuddyGroup.getItem().toSsiItem();
            assert (groupItem.getId() == 0 && groupItem.getItemType() == 1);
            items.add(groupItem);
            groupid = groupItem.getParentId();
        } else {
            groupid = null;
        }
        DeleteItemsCmd deleteItemsCmd = new DeleteItemsCmd(items);
        this.service.sendSsiModification(deleteItemsCmd, new SnacRequestAdapter(){

            public void handleResponse(SnacResponseEvent e) {
                RootItem rootItem;
                SsiDataModResponse dataModResponse;
                int result;
                if (e.getSnacCommand() instanceof SsiDataModResponse && (result = (dataModResponse = (SsiDataModResponse)e.getSnacCommand()).getResults()[0]) == 0 && (rootItem = SsiBuddyList.this.getRootItem()) != null && groupid != null) {
                    this.removeGroupFromRoot(rootItem, groupid);
                }
            }

            private boolean removeGroupFromRoot(RootItem rootItem, int groupid2) {
                int[] newIds;
                int[] oldIds = rootItem.getGroupids();
                if (oldIds != null) {
                    int total = 0;
                    for (int oldId : oldIds) {
                        if (oldId != groupid2) continue;
                        ++total;
                    }
                    if (total == 0) {
                        return false;
                    }
                    newIds = new int[oldIds.length - total];
                    int i = 0;
                    for (int id : oldIds) {
                        if (id == groupid2) continue;
                        newIds[i] = id;
                        ++i;
                    }
                    assert (i == newIds.length);
                } else {
                    newIds = new int[]{};
                }
                RootItem newRootItem = new RootItem(rootItem);
                newRootItem.setGroupids(newIds);
                SsiBuddyList.this.service.sendSsiModification(new ModifyItemsCmd(newRootItem.toSsiItem()));
                return true;
            }
        });
    }

    public SsiServiceImpl getSsiService() {
        return this.service;
    }
}

