/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.lang.ref.WeakReference;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.ScOtrEngine;
import net.java.sip.communicator.plugin.otr.ScOtrEngineListener;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManager;
import net.java.sip.communicator.plugin.otr.ScOtrKeyManagerListener;
import net.java.sip.communicator.service.protocol.Contact;

public class OtrWeakListener<T extends ScOtrEngineListener & ScOtrKeyManagerListener>
implements ScOtrEngineListener,
ScOtrKeyManagerListener {
    private final ScOtrEngine engine;
    private final ScOtrKeyManager keyManager;
    private final WeakReference<T> listener;

    public OtrWeakListener(T listener, ScOtrEngine engine, ScOtrKeyManager keyManager) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listener = new WeakReference<T>(listener);
        this.engine = engine;
        this.keyManager = keyManager;
        this.engine.addListener(this);
        this.keyManager.addListener(this);
    }

    @Override
    public void contactPolicyChanged(Contact contact) {
        T l = this.getListener();
        if (l != null) {
            l.contactPolicyChanged(contact);
        }
    }

    @Override
    public void contactVerificationStatusChanged(OtrContactManager.OtrContact contact) {
        ScOtrKeyManagerListener l = (ScOtrKeyManagerListener)this.getListener();
        if (l != null) {
            l.contactVerificationStatusChanged(contact);
        }
    }

    private T getListener() {
        ScOtrEngineListener l = (ScOtrEngineListener)this.listener.get();
        if (l == null) {
            this.engine.removeListener(this);
            this.keyManager.removeListener(this);
        }
        return (T)l;
    }

    @Override
    public void globalPolicyChanged() {
        T l = this.getListener();
        if (l != null) {
            l.globalPolicyChanged();
        }
    }

    @Override
    public void sessionStatusChanged(OtrContactManager.OtrContact contact) {
        T l = this.getListener();
        if (l != null) {
            l.sessionStatusChanged(contact);
        }
    }

    @Override
    public void multipleInstancesDetected(OtrContactManager.OtrContact contact) {
        T l = this.getListener();
        if (l != null) {
            l.multipleInstancesDetected(contact);
        }
    }

    @Override
    public void outgoingSessionChanged(OtrContactManager.OtrContact contact) {
        T l = this.getListener();
        if (l != null) {
            l.outgoingSessionChanged(contact);
        }
    }
}

