/*
 * Decompiled with CFR 0.152.
 */
package javax.sip;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sip.PeerUnavailableException;
import javax.sip.SipStack;
import javax.sip.address.AddressFactory;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;

public class SipFactory {
    public static final String IP_ADDRESS = "javax.sip.IP_ADDRESS";
    public static final String STACK_NAME = "javax.sip.STACK_NAME";
    private static final String DEFAULT_PATH_NAME = "gov.nist";
    private String mPathName = "gov.nist";
    private Map<String, SipStack> mSipStackByName;
    private MessageFactory mMessageFactory = null;
    private HeaderFactory mHeaderFactory = null;
    private AddressFactory mAddressFactory = null;
    private static SipFactory _instance = null;
    private final List<SipStack> mSipStackList = new LinkedList<SipStack>();

    public static synchronized SipFactory getInstance() {
        if (_instance == null) {
            _instance = new SipFactory();
        }
        return _instance;
    }

    private SipFactory() {
        this.mSipStackByName = new HashMap<String, SipStack>();
    }

    public synchronized SipStack createSipStack(Properties properties) throws PeerUnavailableException {
        String address = properties.getProperty(IP_ADDRESS);
        String name = properties.getProperty(STACK_NAME);
        if (name == null) {
            throw new PeerUnavailableException("Missing javax.sip.STACK_NAME property");
        }
        if (address == null) {
            SipStack mySipStack = this.mSipStackByName.get(name);
            if (mySipStack == null) {
                mySipStack = this.createStack(properties);
            }
            return mySipStack;
        }
        for (SipStack s : this.mSipStackList) {
            if (!s.getIPAddress().equals(address)) continue;
            return s;
        }
        return this.createStack(properties);
    }

    public MessageFactory createMessageFactory() throws PeerUnavailableException {
        if (this.mMessageFactory == null) {
            this.mMessageFactory = (MessageFactory)this.createSipFactory("javax.sip.message.MessageFactoryImpl");
        }
        return this.mMessageFactory;
    }

    public HeaderFactory createHeaderFactory() throws PeerUnavailableException {
        if (this.mHeaderFactory == null) {
            this.mHeaderFactory = (HeaderFactory)this.createSipFactory("javax.sip.header.HeaderFactoryImpl");
        }
        return this.mHeaderFactory;
    }

    public AddressFactory createAddressFactory() throws PeerUnavailableException {
        if (this.mAddressFactory == null) {
            this.mAddressFactory = (AddressFactory)this.createSipFactory("javax.sip.address.AddressFactoryImpl");
        }
        return this.mAddressFactory;
    }

    public void setPathName(String pathName) {
        this.mPathName = pathName;
    }

    public String getPathName() {
        return this.mPathName;
    }

    public void resetFactory() {
        this.mSipStackList.clear();
        this.mMessageFactory = null;
        this.mHeaderFactory = null;
        this.mAddressFactory = null;
        this.mSipStackByName = new HashMap<String, SipStack>();
        this.mPathName = DEFAULT_PATH_NAME;
    }

    private String makeClassName(String c) {
        return this.getPathName() + "." + c;
    }

    private Object createSipFactory(String objectClassName) throws PeerUnavailableException {
        if (objectClassName == null) {
            throw new NullPointerException();
        }
        String fullName = this.makeClassName(objectClassName);
        try {
            Class<?> peerObjectClass = Class.forName(fullName);
            Object newPeerObject = peerObjectClass.newInstance();
            return newPeerObject;
        }
        catch (Exception e) {
            String errmsg = "The peer factory: " + fullName + " could not be instantiated. Ensure the path name has been set correctly.";
            throw new PeerUnavailableException(errmsg, e);
        }
    }

    private SipStack createStack(Properties properties) throws PeerUnavailableException {
        String implName = this.makeClassName("javax.sip.SipStackImpl");
        try {
            Class[] pTypes = new Class[]{Properties.class};
            Constructor<?> sipStackConstructor = Class.forName(implName).getConstructor(pTypes);
            Object[] cArgs = new Object[]{properties};
            SipStack sipStack = (SipStack)sipStackConstructor.newInstance(cArgs);
            this.mSipStackList.add(sipStack);
            String name = properties.getProperty(STACK_NAME);
            this.mSipStackByName.put(name, sipStack);
            return sipStack;
        }
        catch (Exception e) {
            String errmsg = "The peer SIP Stack: " + implName + " could not be instantiated. Ensure the path name has been set correctly.";
            throw new PeerUnavailableException(errmsg, e);
        }
    }
}

