/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.ProtocolContactSourceServiceImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.StringContactSourceServiceImpl;
import net.java.sip.communicator.impl.gui.utils.OneChoiceInviteDialog;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.DemuxContactSourceService;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIContactSource;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class TransferCallDialog
extends OneChoiceInviteDialog {
    private final CallPeer transferPeer;

    public TransferCallDialog(CallPeer peer) {
        super(GuiActivator.getResources().getI18NString("service.gui.TRANSFER_CALL_TITLE"));
        this.transferPeer = peer;
        this.initContactListData(peer.getProtocolProvider());
        this.setInfoText(GuiActivator.getResources().getI18NString("service.gui.TRANSFER_CALL_MSG"));
        this.setOkButtonText(GuiActivator.getResources().getI18NString("service.gui.TRANSFER"));
        this.setMinimumSize(new Dimension(300, 300));
        this.addOkButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIContact uiContact = TransferCallDialog.this.getSelectedContact();
                if (uiContact != null) {
                    TransferCallDialog.this.transferToContact(uiContact);
                }
                TransferCallDialog.this.setVisible(false);
                TransferCallDialog.this.dispose();
            }
        });
        this.addCancelButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransferCallDialog.this.setVisible(false);
                TransferCallDialog.this.dispose();
            }
        });
    }

    private void initContactSources() {
        DemuxContactSourceService demuxCSService = GuiActivator.getDemuxContactSourceService();
        if (demuxCSService == null) {
            return;
        }
        Iterator sourcesIter = new ArrayList(this.contactList.getContactSources()).iterator();
        this.contactList.removeAllContactSources();
        while (sourcesIter.hasNext()) {
            ContactSourceService contactSource = ((UIContactSource)sourcesIter.next()).getContactSourceService();
            this.contactList.addContactSource(demuxCSService.createDemuxContactSource(contactSource));
        }
    }

    private void initContactListData(ProtocolProviderService protocolProvider) {
        this.initContactSources();
        this.contactList.addContactSource((ContactSourceService)new ProtocolContactSourceServiceImpl(protocolProvider, OperationSetBasicTelephony.class));
        this.contactList.addContactSource((ContactSourceService)new StringContactSourceServiceImpl(protocolProvider, OperationSetBasicTelephony.class));
        this.contactList.applyDefaultFilter();
    }

    private void transferToContact(UIContact uiContact) {
        UIContactDetail contactDetail = uiContact.getDefaultContactDetail(OperationSetBasicTelephony.class);
        CallManager.transferCall(this.transferPeer, contactDetail.getAddress());
    }
}

