/*
 * Decompiled with CFR 0.152.
 */
package mork.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

class ProfileLocator {
    ProfileLocator() {
    }

    private File getThunderbirdDir() {
        File thunderbird;
        File appDataFolder;
        String appData = System.getenv().get("APPDATA");
        if (appData != null && new File(appData).exists() && (appDataFolder = new File(appData)).isDirectory() && (thunderbird = new File(appDataFolder, "Thunderbird")).exists() && thunderbird.isDirectory()) {
            return thunderbird;
        }
        File userhome = new File(System.getProperty("user.home"));
        thunderbird = new File(userhome, ".mozilla-thunderbird");
        if (thunderbird.exists() && thunderbird.isDirectory()) {
            return thunderbird;
        }
        return null;
    }

    public String locateFirstThunderbirdAddressbookPath() {
        File thunderbird = this.getThunderbirdDir();
        if (thunderbird == null) {
            return null;
        }
        File profiles = new File(thunderbird, "profiles.ini");
        if (!profiles.exists()) {
            return null;
        }
        if (!profiles.isFile()) {
            return null;
        }
        if (!profiles.canRead()) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(profiles));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!props.containsKey("Path")) {
            return null;
        }
        String path = props.getProperty("Path");
        File firstProfileFolder = new File(thunderbird, path);
        if (!firstProfileFolder.exists()) {
            return null;
        }
        if (!firstProfileFolder.isDirectory()) {
            return null;
        }
        return firstProfileFolder.getAbsolutePath();
    }
}

