/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.AccountManagerUtils;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestAccountUninstallation
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestAccountUninstallation.class);
    private SipSlickFixture fixture = new SipSlickFixture();

    public TestAccountUninstallation(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestAccountUninstallation("testProviderUnregister"));
        suite.addTest((Test)new TestAccountUninstallation("testInstallationPersistency"));
        suite.addTest((Test)new TestAccountUninstallation("testUninstallAccount"));
        return suite;
    }

    public void testProviderUnregister() throws OperationFailedException {
        TestAccountUninstallation.assertEquals((Object)this.fixture.provider1.getRegistrationState(), (Object)RegistrationState.REGISTERED);
        TestAccountUninstallation.assertEquals((Object)this.fixture.provider2.getRegistrationState(), (Object)RegistrationState.REGISTERED);
        UnregistrationEventCollector collector1 = new UnregistrationEventCollector();
        UnregistrationEventCollector collector2 = new UnregistrationEventCollector();
        this.fixture.provider1.addRegistrationStateChangeListener((RegistrationStateChangeListener)collector1);
        this.fixture.provider2.addRegistrationStateChangeListener((RegistrationStateChangeListener)collector2);
        this.fixture.provider1.unregister();
        this.fixture.provider2.unregister();
        collector1.waitForEvent(10000L);
        collector2.waitForEvent(10000L);
        TestAccountUninstallation.assertTrue((String)"Provider did not distribute unregister events", (2 <= collector1.collectedNewStates.size() ? 1 : 0) != 0);
        TestAccountUninstallation.assertTrue((String)"Provider did not distribute unregister events", (2 <= collector2.collectedNewStates.size() ? 1 : 0) != 0);
        TestAccountUninstallation.assertEquals((String)"Provider state after calling unregister().", (Object)RegistrationState.UNREGISTERED, (Object)this.fixture.provider1.getRegistrationState());
        TestAccountUninstallation.assertEquals((String)"Provider state after calling unregister().", (Object)RegistrationState.UNREGISTERED, (Object)this.fixture.provider2.getRegistrationState());
    }

    public void testInstallationPersistency() throws Exception {
        Bundle providerBundle;
        SipSlickFixture.providerBundle = providerBundle = SipSlickFixture.findProtocolProviderBundle(this.fixture.provider1);
        TestAccountUninstallation.assertNotNull((String)"Couldn't find a bundle for the tested provider", (Object)providerBundle);
        providerBundle.stop();
        TestAccountUninstallation.assertTrue((String)("Couldn't stop the protocol provider bundle. State was " + providerBundle.getState()), (32 != providerBundle.getState() && 16 != providerBundle.getState() ? 1 : 0) != 0);
        providerBundle.uninstall();
        TestAccountUninstallation.assertEquals((String)"Couldn't stop the protocol provider bundle.", (int)1, (int)providerBundle.getState());
        ServiceReference[] sipProviderRefs = null;
        try {
            sipProviderRefs = SipSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=SIP)(USER_ID=" + this.fixture.userID1 + "))");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong: " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was still regged as an osgi service for SIP URI:" + this.fixture.userID1 + "After it was explicitly uninstalled"), (sipProviderRefs == null || sipProviderRefs.length == 0 ? 1 : 0) != 0);
        TestAccountUninstallation.assertTrue((String)("The SIP provider factory kept a reference to the provider we just uninstalled (uri=" + this.fixture.userID1 + ")"), (this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(this.fixture.provider1.getAccountID()) == null ? 1 : 0) != 0);
        SipSlickFixture.providerBundle = providerBundle = SipSlickFixture.bc.installBundle(providerBundle.getLocation());
        TestAccountUninstallation.assertEquals((String)"Couldn't re-install protocol provider bundle.", (int)2, (int)providerBundle.getState());
        AccountManagerUtils.startBundleAndWaitStoredAccountsLoaded((BundleContext)SipSlickFixture.bc, (Bundle)providerBundle, (String)"SIP");
        TestAccountUninstallation.assertEquals((String)"Couldn't re-start protocol provider bundle.", (int)32, (int)providerBundle.getState());
        try {
            sipProviderRefs = SipSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=SIP)(USER_ID=" + this.fixture.userID1 + "))");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was not restored after beingreinstalled. SIP URI:" + this.fixture.userID1), (sipProviderRefs != null && sipProviderRefs.length > 0 ? 1 : 0) != 0);
        ServiceReference[] sipFactoryRefs = null;
        try {
            sipFactoryRefs = SipSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), "(PROTOCOL_NAME=SIP)");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong " + ex.getMessage()));
        }
        this.fixture.providerFactory = (ProtocolProviderFactory)SipSlickFixture.bc.getService(sipFactoryRefs[0]);
        this.fixture.provider1 = (ProtocolProviderService)SipSlickFixture.bc.getService(sipProviderRefs[0]);
        TestAccountUninstallation.assertTrue((String)("The SIP provider did not restore its own reference to the provider that we just reinstalled (URI=" + this.fixture.userID1 + ")"), (!this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(this.fixture.provider1.getAccountID()) != null ? 1 : 0) != 0);
    }

    public void testUninstallAccount() {
        TestAccountUninstallation.assertFalse((String)"No installed accounts found", (boolean)this.fixture.providerFactory.getRegisteredAccounts().isEmpty());
        TestAccountUninstallation.assertNotNull((String)("Found no provider corresponding to URI " + this.fixture.userID1), (Object)this.fixture.providerFactory.getProviderForAccount(this.fixture.provider1.getAccountID()));
        TestAccountUninstallation.assertTrue((String)("Failed to remove a provider corresponding to URI " + this.fixture.userID1), (boolean)this.fixture.providerFactory.uninstallAccount(this.fixture.provider1.getAccountID()));
        TestAccountUninstallation.assertTrue((String)("Failed to remove a provider corresponding to URI " + this.fixture.userID1), (boolean)this.fixture.providerFactory.uninstallAccount(this.fixture.provider2.getAccountID()));
        ServiceReference[] sipProviderRefs = null;
        try {
            sipProviderRefs = SipSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(PROTOCOL_NAME=SIP)");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was still regged as an osgi service for SIP URI:" + this.fixture.userID1 + "After it was explicitly uninstalled"), (sipProviderRefs == null || sipProviderRefs.length == 0 ? 1 : 0) != 0);
        TestAccountUninstallation.assertTrue((String)("The SIP provider factory kept a reference to the provider we just uninstalled (uri=" + this.fixture.userID1 + ")"), (this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(this.fixture.provider1.getAccountID()) == null ? 1 : 0) != 0);
    }

    public class UnregistrationEventCollector
    implements RegistrationStateChangeListener {
        public List<RegistrationState> collectedNewStates = new LinkedList<RegistrationState>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            logger.debug((Object)("Received a RegistrationStateChangeEvent: " + evt));
            this.collectedNewStates.add(evt.getNewState());
            if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                logger.debug((Object)"We're registered and will notify those who wait");
                UnregistrationEventCollector unregistrationEventCollector = this;
                synchronized (unregistrationEventCollector) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent(long waitFor) {
            logger.trace((Object)"Waiting for a RegistrationStateChangeEvent");
            UnregistrationEventCollector unregistrationEventCollector = this;
            synchronized (unregistrationEventCollector) {
                if (this.collectedNewStates.contains(RegistrationState.UNREGISTERED)) {
                    logger.trace((Object)("Event already received. " + this.collectedNewStates));
                    return;
                }
                try {
                    this.wait(waitFor);
                    if (this.collectedNewStates.size() > 0) {
                        logger.trace((Object)"Received a RegistrationStateChangeEvent.");
                    } else {
                        logger.trace((Object)("No RegistrationStateChangeEvent received for " + waitFor + "ms."));
                    }
                }
                catch (InterruptedException ex) {
                    logger.debug((Object)"Interrupted while waiting for a RegistrationStateChangeEvent", (Throwable)ex);
                }
            }
        }
    }
}

