/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver;

import java.util.Arrays;

class MetadataVersion
implements Comparable<MetadataVersion> {
    static final MetadataVersion NULL = new NullMetadataVersion();
    private final String[] idents;

    MetadataVersion(String[] stringArray) {
        this.idents = stringArray;
    }

    MetadataVersion increment() {
        String[] stringArray = this.idents;
        String string = stringArray[stringArray.length - 1];
        if (this.isInt(string)) {
            int n = Integer.parseInt(string);
            stringArray[stringArray.length - 1] = String.valueOf(++n);
        } else {
            stringArray = Arrays.copyOf(stringArray, stringArray.length + 1);
            stringArray[stringArray.length - 1] = String.valueOf(1);
        }
        return new MetadataVersion(stringArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MetadataVersion)) {
            return false;
        }
        return this.compareTo((MetadataVersion)object) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.idents);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.idents) {
            stringBuilder.append(string).append(".");
        }
        return stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(".")).toString();
    }

    @Override
    public int compareTo(MetadataVersion metadataVersion) {
        if (metadataVersion == NULL) {
            return -1;
        }
        int n = this.compareIdentifierArrays(metadataVersion.idents);
        if (n == 0) {
            n = this.idents.length - metadataVersion.idents.length;
        }
        return n;
    }

    private int compareIdentifierArrays(String[] stringArray) {
        int n = 0;
        int n2 = this.getLeastCommonArrayLength(this.idents, stringArray);
        for (int i = 0; i < n2 && (n = this.compareIdentifiers(this.idents[i], stringArray[i])) == 0; ++i) {
        }
        return n;
    }

    private int getLeastCommonArrayLength(String[] stringArray, String[] stringArray2) {
        return stringArray.length <= stringArray2.length ? stringArray.length : stringArray2.length;
    }

    private int compareIdentifiers(String string, String string2) {
        if (this.isInt(string) && this.isInt(string2)) {
            return Integer.parseInt(string) - Integer.parseInt(string2);
        }
        return string.compareTo(string2);
    }

    private boolean isInt(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static class NullMetadataVersion
    extends MetadataVersion {
        public NullMetadataVersion() {
            super(null);
        }

        @Override
        MetadataVersion increment() {
            throw new NullPointerException("Metadata version is NULL");
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof NullMetadataVersion;
        }

        @Override
        public int compareTo(MetadataVersion metadataVersion) {
            if (!this.equals(metadataVersion)) {
                return 1;
            }
            return 0;
        }
    }
}

