/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import org.fife.ui.rtextarea.RTextArea;

public class RtfGenerator {
    private List<Font> fontList = new ArrayList<Font>(1);
    private List<Color> colorList = new ArrayList<Color>(1);
    private StringBuilder document = new StringBuilder();
    private boolean lastWasControlWord;
    private int lastFontIndex;
    private int lastFGIndex;
    private boolean lastBold;
    private boolean lastItalic;
    private int lastFontSize;
    private int screenRes;
    private static final int DEFAULT_FONT_SIZE = 12;

    public RtfGenerator() {
        this.reset();
    }

    public void appendNewline() {
        this.document.append("\\par");
        this.document.append('\n');
        this.lastWasControlWord = false;
    }

    public void appendToDoc(String string, Font font, Color color, Color color2) {
        this.appendToDoc(string, font, color, color2, false);
    }

    public void appendToDocNoFG(String string, Font font, Color color, boolean bl) {
        this.appendToDoc(string, font, null, color, bl, false);
    }

    public void appendToDoc(String string, Font font, Color color, Color color2, boolean bl) {
        this.appendToDoc(string, font, color, color2, bl, true);
    }

    public void appendToDoc(String string, Font font, Color color, Color color2, boolean bl, boolean bl2) {
        if (string != null) {
            int n;
            int n2;
            int n3 = n2 = font == null ? 0 : RtfGenerator.getFontIndex(this.fontList, font) + 1;
            if (n2 != this.lastFontIndex) {
                this.document.append("\\f").append(n2);
                this.lastFontIndex = n2;
                this.lastWasControlWord = true;
            }
            if (font != null) {
                n = this.fixFontSize(font.getSize2D() * 2.0f);
                if (n != this.lastFontSize) {
                    this.document.append("\\fs").append(n);
                    this.lastFontSize = n;
                    this.lastWasControlWord = true;
                }
                if (font.isBold() != this.lastBold) {
                    this.document.append(this.lastBold ? "\\b0" : "\\b");
                    this.lastBold = !this.lastBold;
                    this.lastWasControlWord = true;
                }
                if (font.isItalic() != this.lastItalic) {
                    this.document.append(this.lastItalic ? "\\i0" : "\\i");
                    this.lastItalic = !this.lastItalic;
                    this.lastWasControlWord = true;
                }
            } else {
                if (this.lastFontSize != 12) {
                    this.document.append("\\fs").append(12);
                    this.lastFontSize = 12;
                    this.lastWasControlWord = true;
                }
                if (this.lastBold) {
                    this.document.append("\\b0");
                    this.lastBold = false;
                    this.lastWasControlWord = true;
                }
                if (this.lastItalic) {
                    this.document.append("\\i0");
                    this.lastItalic = false;
                    this.lastWasControlWord = true;
                }
            }
            if (bl) {
                this.document.append("\\ul");
                this.lastWasControlWord = true;
            }
            if (bl2) {
                n = 0;
                if (color != null) {
                    n = RtfGenerator.getColorIndex(this.colorList, color) + 1;
                }
                if (n != this.lastFGIndex) {
                    this.document.append("\\cf").append(n);
                    this.lastFGIndex = n;
                    this.lastWasControlWord = true;
                }
            }
            if (color2 != null) {
                n = RtfGenerator.getColorIndex(this.colorList, color2);
                this.document.append("\\highlight").append(n + 1);
                this.lastWasControlWord = true;
            }
            if (this.lastWasControlWord) {
                this.document.append(' ');
                this.lastWasControlWord = false;
            }
            this.escapeAndAdd(this.document, string);
            if (color2 != null) {
                this.document.append("\\highlight0");
                this.lastWasControlWord = true;
            }
            if (bl) {
                this.document.append("\\ul0");
                this.lastWasControlWord = true;
            }
        }
    }

    private final void escapeAndAdd(StringBuilder stringBuilder, String string) {
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    stringBuilder.append("\\tab");
                    while (++i < n && string.charAt(i) == '\t') {
                        stringBuilder.append("\\tab");
                    }
                    stringBuilder.append(' ');
                    --i;
                    continue block4;
                }
                case '\\': 
                case '{': 
                case '}': {
                    stringBuilder.append('\\').append(c);
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
    }

    private int fixFontSize(float f) {
        if (this.screenRes != 72) {
            f = Math.round(f * 72.0f / (float)this.screenRes);
        }
        return (int)f;
    }

    private static int getColorIndex(List<Color> list, Color color) {
        int n = list.indexOf(color);
        if (n == -1) {
            list.add(color);
            n = list.size() - 1;
        }
        return n;
    }

    private String getColorTableRtf() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\\colortbl ;");
        for (Color color : this.colorList) {
            stringBuilder.append("\\red").append(color.getRed());
            stringBuilder.append("\\green").append(color.getGreen());
            stringBuilder.append("\\blue").append(color.getBlue());
            stringBuilder.append(';');
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static int getFontIndex(List<Font> list, Font font) {
        String string = font.getFamily();
        for (int i = 0; i < list.size(); ++i) {
            Font font2 = list.get(i);
            if (!font2.getFamily().equals(string)) continue;
            return i;
        }
        list.add(font);
        return list.size() - 1;
    }

    private String getFontTableRtf() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = RtfGenerator.getMonospacedFontFamily();
        stringBuilder.append("{\\fonttbl{\\f0\\fnil\\fcharset0 " + string + ";}");
        for (int i = 0; i < this.fontList.size(); ++i) {
            Font font = this.fontList.get(i);
            String string2 = font.getFamily();
            if (string2.equals("Monospaced")) {
                string2 = string;
            }
            stringBuilder.append("{\\f").append(i + 1).append("\\fnil\\fcharset0 ");
            stringBuilder.append(string2).append(";}");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static final String getMonospacedFontFamily() {
        String string = RTextArea.getDefaultFont().getFamily();
        if ("Monospaced".equals(string)) {
            string = "Courier";
        }
        return string;
    }

    public String getRtf() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("\\rtf1\\ansi\\ansicpg1252");
        stringBuilder.append("\\deff0");
        stringBuilder.append("\\deflang1033");
        stringBuilder.append("\\viewkind4");
        stringBuilder.append("\\uc\\pard\\f0");
        stringBuilder.append("\\fs20");
        stringBuilder.append(this.getFontTableRtf()).append('\n');
        stringBuilder.append(this.getColorTableRtf()).append('\n');
        stringBuilder.append((CharSequence)this.document);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void reset() {
        this.fontList.clear();
        this.colorList.clear();
        this.document.setLength(0);
        this.lastWasControlWord = false;
        this.lastFontIndex = 0;
        this.lastFGIndex = 0;
        this.lastBold = false;
        this.lastItalic = false;
        this.lastFontSize = 12;
        this.screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
    }
}

