/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.IconRowHeader;

public class FoldingAwareIconRowHeader
extends IconRowHeader {
    public FoldingAwareIconRowHeader(RSyntaxTextArea rSyntaxTextArea) {
        super(rSyntaxTextArea);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.textArea == null) {
            return;
        }
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.textArea;
        FoldManager foldManager = rSyntaxTextArea.getFoldManager();
        if (!foldManager.isCodeFoldingSupportedAndEnabled()) {
            super.paintComponent(graphics);
            return;
        }
        this.visibleRect = graphics.getClipBounds(this.visibleRect);
        if (this.visibleRect == null) {
            this.visibleRect = this.getVisibleRect();
        }
        if (this.visibleRect == null) {
            return;
        }
        this.paintBackgroundImpl(graphics, this.visibleRect);
        if (this.textArea.getLineWrap()) {
            this.paintComponentWrapped(graphics);
            return;
        }
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        this.textAreaInsets = this.textArea.getInsets(this.textAreaInsets);
        if (this.visibleRect.y < this.textAreaInsets.top) {
            this.visibleRect.height -= this.textAreaInsets.top - this.visibleRect.y;
            this.visibleRect.y = this.textAreaInsets.top;
        }
        int n5 = this.textArea.getLineHeight();
        int n6 = (this.visibleRect.y - this.textAreaInsets.top) / n5;
        int n7 = n6 * n5 + this.textAreaInsets.top;
        n6 += foldManager.getHiddenLineCountAbove(n6, true);
        if (this.activeLineRangeStart > -1 && this.activeLineRangeEnd > -1) {
            Color color = this.getActiveLineRangeColor();
            graphics.setColor(color);
            try {
                n4 = rSyntaxTextArea.yForLine(this.activeLineRangeStart);
                if (n4 > -1) {
                    int n8;
                    int n9 = n4;
                    n3 = rSyntaxTextArea.yForLine(this.activeLineRangeEnd);
                    if (n3 == -1) {
                        n3 = n9;
                    }
                    if ((n3 += n5 - 1) < this.visibleRect.y || n9 > this.visibleRect.y + this.visibleRect.height) {
                        return;
                    }
                    n9 = Math.max(n7, n4);
                    n3 = Math.min(n3, this.visibleRect.y + this.visibleRect.height);
                    for (n2 = n9; n2 <= n3; n2 += 2) {
                        n8 = Math.min(n3, n2 + this.getWidth());
                        n = n8 - n2;
                        graphics.drawLine(0, n2, n, n8);
                    }
                    for (n8 = 2; n8 < this.getWidth(); n8 += 2) {
                        n = n9 + this.getWidth() - n8;
                        graphics.drawLine(n8, n9, this.getWidth(), n);
                    }
                    if (n4 >= n7 && n4 < this.visibleRect.y + this.visibleRect.height) {
                        graphics.drawLine(0, n4, this.getWidth(), n4);
                    }
                    if (n3 >= n7 && n3 < this.visibleRect.y + this.visibleRect.height) {
                        graphics.drawLine(0, n3, this.getWidth(), n3);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (this.trackingIcons != null) {
            int n10 = this.textArea.getLineCount() - 1;
            for (n4 = this.trackingIcons.size() - 1; n4 >= 0; --n4) {
                IconRowHeader.GutterIconImpl gutterIconImpl = this.getTrackingIcon(n4);
                n3 = gutterIconImpl.getMarkedOffset();
                if (n3 < 0 || n3 > document.getLength()) continue;
                n2 = element.getElementIndex(n3);
                if (n2 <= n10 && n2 >= n6) {
                    try {
                        Icon icon = gutterIconImpl.getIcon();
                        if (icon == null || (n = rSyntaxTextArea.yForLine(n2)) < n7 || n > this.visibleRect.y + this.visibleRect.height) continue;
                        int n11 = n + (n5 - icon.getIconHeight()) / 2;
                        icon.paintIcon(this, graphics, 0, n11);
                        n10 = n2 - 1;
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    continue;
                }
                if (n2 < n6) break;
            }
        }
    }

    private void paintComponentWrapped(Graphics graphics) {
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.textArea;
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        int n = this.textArea.viewToModel(new Point(this.visibleRect.x, this.visibleRect.y));
        int n2 = element.getElementIndex(n);
        int n3 = this.visibleRect.y;
        int n4 = this.visibleRect.y + this.visibleRect.height;
        int n5 = this.textArea.getLineHeight();
        if (this.trackingIcons != null) {
            int n6 = this.textArea.getLineCount() - 1;
            for (int i = this.trackingIcons.size() - 1; i >= 0; --i) {
                IconRowHeader.GutterIconImpl gutterIconImpl = this.getTrackingIcon(i);
                Icon icon = gutterIconImpl.getIcon();
                if (icon == null) continue;
                int n7 = icon.getIconHeight();
                int n8 = gutterIconImpl.getMarkedOffset();
                if (n8 < 0 || n8 > document.getLength()) continue;
                int n9 = element.getElementIndex(n8);
                if (n9 <= n6 && n9 >= n2) {
                    try {
                        int n10 = rSyntaxTextArea.yForLine(n9);
                        if (n10 > n4 || n10 + n7 < n3) continue;
                        int n11 = n10 + (n5 - n7) / 2;
                        gutterIconImpl.getIcon().paintIcon(this, graphics, 0, n11);
                        n6 = n9 - 1;
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                    continue;
                }
                if (n9 < n2) break;
            }
        }
    }
}

