/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.junit;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestCase;

public abstract class APITestCase
extends TestCase {
    private static Comparator ENTITY_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            AbstractBaseJavaEntity abstractBaseJavaEntity = (AbstractBaseJavaEntity)object;
            AbstractBaseJavaEntity abstractBaseJavaEntity2 = (AbstractBaseJavaEntity)object2;
            return abstractBaseJavaEntity.getName().compareTo(abstractBaseJavaEntity2.getName());
        }
    };

    public static void assertApiEquals(URL uRL, URL uRL2) throws IOException {
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder();
        javaDocBuilder.addSource(new InputStreamReader(uRL.openStream()), uRL.toExternalForm());
        javaDocBuilder.addSource(new InputStreamReader(uRL2.openStream()), uRL2.toExternalForm());
        JavaSource javaSource = javaDocBuilder.getSources()[0];
        JavaSource javaSource2 = javaDocBuilder.getSources()[1];
        APITestCase.assertApiEquals(javaSource, javaSource2);
    }

    private static void assertApiEquals(JavaSource javaSource, JavaSource javaSource2) {
        List<JavaClass> list = Arrays.asList(javaSource.getClasses());
        Collections.sort(list, ENTITY_COMPARATOR);
        List<JavaClass> list2 = Arrays.asList(javaSource2.getClasses());
        Collections.sort(list2, ENTITY_COMPARATOR);
        APITestCase.assertEquals((String)"Number of classes should be equal", (int)list.size(), (int)list2.size());
        for (int i = 0; i < list.size(); ++i) {
            APITestCase.assertClassesEqual(list.get(i), list2.get(i));
        }
    }

    private static void assertClassesEqual(JavaClass javaClass, JavaClass javaClass2) {
        APITestCase.assertEquals((String)"Package names should be equal", (Object)javaClass.getPackage(), (Object)javaClass2.getPackage());
        APITestCase.assertModifiersEquals("Class modifiers should be equal", javaClass, javaClass2);
        APITestCase.assertEquals((String)"Class names should be equal", (String)javaClass.getName(), (String)javaClass2.getName());
        if (javaClass.getSuperJavaClass() != null && javaClass2.getSuperJavaClass() != null) {
            APITestCase.assertEquals((String)"Super class should be equal", (String)javaClass.getSuperJavaClass().getName(), (String)javaClass2.getSuperJavaClass().getName());
        }
        if (javaClass.getSuperJavaClass() == null ^ javaClass2.getSuperJavaClass() == null) {
            APITestCase.fail((String)"Super class should be equal");
        }
        APITestCase.assertInterfacesEqual(javaClass, javaClass2);
        APITestCase.assertInnerClassesEquals(javaClass, javaClass2);
        APITestCase.assertFieldsEqual(javaClass, javaClass2);
        APITestCase.assertMethodsEqual(javaClass, javaClass2);
    }

    private static void assertFieldEquals(JavaField javaField, JavaField javaField2) {
        StringBuffer stringBuffer = new StringBuffer("-> assertFieldEquals");
        stringBuffer.append("\n\tExcepted : ");
        stringBuffer.append(javaField);
        stringBuffer.append("\n\tActual : ");
        stringBuffer.append(javaField2);
        stringBuffer.append("\n");
        APITestCase.assertEquals((String)(stringBuffer.toString() + "Field types should be equal"), (Object)javaField.getType(), (Object)javaField2.getType());
        APITestCase.assertEquals((String)(stringBuffer.toString() + "Field names should be equal"), (String)javaField.getName(), (String)javaField2.getName());
        APITestCase.assertModifiersEquals(stringBuffer.toString() + "Field modifiers should be equal", javaField, javaField2);
    }

    private static void assertFieldsEqual(JavaClass javaClass, JavaClass javaClass2) {
        List<JavaField> list = Arrays.asList(javaClass.getFields());
        Collections.sort(list, ENTITY_COMPARATOR);
        List<JavaField> list2 = Arrays.asList(javaClass2.getFields());
        Collections.sort(list2, ENTITY_COMPARATOR);
        StringBuffer stringBuffer = new StringBuffer("-> assertFieldsEqual");
        stringBuffer.append("\n\tExcepted : ");
        stringBuffer.append(list);
        stringBuffer.append("\n\tActual : ");
        stringBuffer.append(list2);
        stringBuffer.append("\n");
        APITestCase.assertEquals((String)(stringBuffer.toString() + "Number of fields should be equal"), (int)list.size(), (int)list2.size());
        for (int i = 0; i < list.size(); ++i) {
            APITestCase.assertFieldEquals(list.get(i), list2.get(i));
        }
    }

    private static void assertInnerClassesEquals(JavaClass javaClass, JavaClass javaClass2) {
        List<JavaClass> list = Arrays.asList(javaClass.getNestedClasses());
        Collections.sort(list, ENTITY_COMPARATOR);
        List<JavaClass> list2 = Arrays.asList(javaClass2.getNestedClasses());
        Collections.sort(list2, ENTITY_COMPARATOR);
        StringBuffer stringBuffer = new StringBuffer("-> assertInnerClassesEquals");
        stringBuffer.append("\n\tExcepted : ");
        stringBuffer.append(list);
        stringBuffer.append("\n\tActual : ");
        stringBuffer.append(list2);
        stringBuffer.append("\n");
        APITestCase.assertEquals((String)(stringBuffer.toString() + "Number of inner classes should be equal"), (int)list.size(), (int)list2.size());
        for (int i = 0; i < list.size(); ++i) {
            APITestCase.assertClassesEqual(list.get(i), list2.get(i));
        }
    }

    private static void assertInterfacesEqual(JavaClass javaClass, JavaClass javaClass2) {
        List<Type> list = Arrays.asList(javaClass.getImplements());
        Collections.sort(list);
        List<Type> list2 = Arrays.asList(javaClass2.getImplements());
        Collections.sort(list2);
        StringBuffer stringBuffer = new StringBuffer("-> assertInnerClassesEquals");
        stringBuffer.append("\n\tExcepted : ");
        stringBuffer.append(list);
        stringBuffer.append("\n\tActual : ");
        stringBuffer.append(list2);
        stringBuffer.append("\n");
        APITestCase.assertEquals((String)(stringBuffer.toString() + "Number of implemented interface should be equal"), (int)list.size(), (int)list2.size());
        for (int i = 0; i < list.size(); ++i) {
            APITestCase.assertEquals((String)"Implemented interface should be equal", (Object)list.get(i), (Object)list2.get(i));
        }
    }

    private static void assertMethodsEqual(JavaClass javaClass, JavaClass javaClass2) {
        List<JavaMethod> list = Arrays.asList(javaClass.getMethods());
        Collections.sort(list, ENTITY_COMPARATOR);
        List<JavaMethod> list2 = Arrays.asList(javaClass2.getMethods());
        Collections.sort(list2, ENTITY_COMPARATOR);
        StringBuffer stringBuffer = new StringBuffer("-> assertMethodsEqual");
        stringBuffer.append("\n\tExcepted : ");
        stringBuffer.append(list);
        stringBuffer.append("\n\tActual : ");
        stringBuffer.append(list2);
        stringBuffer.append("\n");
        APITestCase.assertEquals((String)(stringBuffer.toString() + "Number of methods should be equal"), (int)list.size(), (int)list2.size());
        for (int i = 0; i < list.size(); ++i) {
            APITestCase.assertEquals((String)"Method should be equal", (Object)list.get(i), (Object)list2.get(i));
        }
    }

    private static void assertModifiersEquals(String string, AbstractJavaEntity abstractJavaEntity, AbstractJavaEntity abstractJavaEntity2) {
        List<String> list = Arrays.asList(abstractJavaEntity.getModifiers());
        Collections.sort(list);
        List<String> list2 = Arrays.asList(abstractJavaEntity2.getModifiers());
        Collections.sort(list2);
        StringBuffer stringBuffer = new StringBuffer("-> assertModifiersEquals");
        stringBuffer.append("\n\tExcepted : ");
        stringBuffer.append(list);
        stringBuffer.append("\n\tActual : ");
        stringBuffer.append(list2);
        stringBuffer.append("\n");
        APITestCase.assertEquals((String)(stringBuffer.toString() + string + "\nNumber of modifiers should be equal"), (int)list.size(), (int)list2.size());
        for (int i = 0; i < list.size(); ++i) {
            APITestCase.assertEquals((String)(string + "\n" + stringBuffer.toString() + "\nModifier should be equal"), (Object)list.get(i), (Object)list2.get(i));
        }
    }

    private static void assertNotDir(File file, File file2) {
        if (file.isDirectory()) {
            APITestCase.fail((String)(file.getAbsolutePath() + " - should not have been a directory"));
        }
        if (file2.isDirectory()) {
            APITestCase.fail((String)(file2.getAbsolutePath() + " - should not have been a directory"));
        }
    }

    protected File getDir() {
        return new File(((Object)((Object)this)).getClass().getResource("/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".class").getFile()).getParentFile();
    }

    protected File getRootDir() {
        File file = this.getDir();
        StringTokenizer stringTokenizer = new StringTokenizer(((Object)((Object)this)).getClass().getName(), ".");
        for (int i = 0; i < stringTokenizer.countTokens() - 1; ++i) {
            file = file.getParentFile();
        }
        return file;
    }
}

