/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class CompactStringObjectMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final CompactStringObjectMap EMPTY = new CompactStringObjectMap(1, 0, new Object[4]);
    private final int _hashMask;
    private final int _spillCount;
    private final Object[] _hashArea;

    private CompactStringObjectMap(int n, int n2, Object[] objectArray) {
        this._hashMask = n;
        this._spillCount = n2;
        this._hashArea = objectArray;
    }

    public static <T> CompactStringObjectMap construct(Map<String, T> map) {
        if (map.isEmpty()) {
            return EMPTY;
        }
        int n = CompactStringObjectMap.findSize(map.size());
        int n2 = n - 1;
        int n3 = (n + (n >> 1)) * 2;
        Object[] objectArray = new Object[n3];
        int n4 = 0;
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String string = entry.getKey();
            int n5 = string.hashCode() & n2;
            int n6 = n5 + n5;
            if (objectArray[n6] != null && objectArray[n6 = n + (n5 >> 1) << 1] != null) {
                n6 = (n + (n >> 1) << 1) + n4;
                n4 += 2;
                if (n6 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n6] = string;
            objectArray[n6 + 1] = entry.getValue();
        }
        return new CompactStringObjectMap(n2, n4, objectArray);
    }

    private static final int findSize(int n) {
        int n2;
        if (n <= 5) {
            return 8;
        }
        if (n <= 12) {
            return 16;
        }
        int n3 = n + (n >> 2);
        for (n2 = 32; n2 < n3; n2 += n2) {
        }
        return n2;
    }

    public Object find(String string) {
        int n = string.hashCode() & this._hashMask;
        int n2 = n << 1;
        Object object = this._hashArea[n2];
        if (object == string || string.equals(object)) {
            return this._hashArea[n2 + 1];
        }
        return this._find2(string, n, object);
    }

    private final Object _find2(String string, int n, Object object) {
        if (object == null) {
            return null;
        }
        int n2 = this._hashMask + 1;
        int n3 = n2 + (n >> 1) << 1;
        object = this._hashArea[n3];
        if (string.equals(object)) {
            return this._hashArea[n3 + 1];
        }
        if (object != null) {
            int n4;
            int n5 = n4 + this._spillCount;
            for (n4 = n2 + (n2 >> 1) << 1; n4 < n5; n4 += 2) {
                object = this._hashArea[n4];
                if (object != string && !string.equals(object)) continue;
                return this._hashArea[n4 + 1];
            }
        }
        return null;
    }

    public List<String> keys() {
        int n = this._hashArea.length;
        ArrayList<String> arrayList = new ArrayList<String>(n >> 2);
        for (int i = 0; i < n; i += 2) {
            Object object = this._hashArea[i];
            if (object == null) continue;
            arrayList.add((String)object);
        }
        return arrayList;
    }
}

