/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> clazz) {
        this._valueClass = clazz;
    }

    protected StdDeserializer(JavaType javaType) {
        this._valueClass = javaType == null ? null : javaType.getRawClass();
    }

    protected StdDeserializer(StdDeserializer<?> stdDeserializer) {
        this._valueClass = stdDeserializer._valueClass;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> jsonDeserializer) {
        return ClassUtil.isJacksonStdImpl(jsonDeserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeserializer) {
        return ClassUtil.isJacksonStdImpl(keyDeserializer);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return false;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return this._parseBooleanFromInt(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if ("true".equals(string) || "True".equals(string)) {
                return true;
            }
            if ("false".equals(string) || "False".equals(string) || string.length() == 0) {
                return false;
            }
            if (this._hasTextualNull(string)) {
                return false;
            }
            Boolean bl = (Boolean)deserializationContext.handleWeirdStringValue(this._valueClass, string, "only \"true\" or \"false\" recognized", new Object[0]);
            return bl == null ? false : bl;
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            boolean bl = this._parseBooleanPrimitive(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return bl;
        }
        return (Boolean)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected final Boolean _parseBoolean(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return this._parseBooleanFromInt(jsonParser, deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue(deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if ("true".equals(string) || "True".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equals(string) || "False".equals(string)) {
                return Boolean.FALSE;
            }
            if (string.length() == 0) {
                return (Boolean)this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string)) {
                return (Boolean)this.getNullValue(deserializationContext);
            }
            return (Boolean)deserializationContext.handleWeirdStringValue(this._valueClass, string, "only \"true\" or \"false\" recognized", new Object[0]);
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            Boolean bl = this._parseBoolean(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return bl;
        }
        return (Boolean)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected boolean _parseBooleanFromInt(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return !"0".equals(jsonParser.getText());
    }

    @Deprecated
    protected boolean _parseBooleanFromOther(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._parseBooleanFromInt(jsonParser, deserializationContext);
    }

    protected Byte _parseByte(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return jsonParser.getByteValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            int n;
            String string = jsonParser.getText().trim();
            if (this._hasTextualNull(string)) {
                return (Byte)this.getNullValue(deserializationContext);
            }
            try {
                int n2 = string.length();
                if (n2 == 0) {
                    return (Byte)this.getEmptyValue(deserializationContext);
                }
                n = NumberInput.parseInt((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Byte value", new Object[0]);
            }
            if (n < -128 || n > 255) {
                return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "overflow, value can not be represented as 8-bit value", new Object[0]);
            }
            return (byte)n;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(jsonParser, deserializationContext, "Byte");
            }
            return jsonParser.getByteValue();
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue(deserializationContext);
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            Byte by = this._parseByte(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return by;
        }
        return (Byte)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected Short _parseShort(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return jsonParser.getShortValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            int n;
            String string = jsonParser.getText().trim();
            try {
                int n2 = string.length();
                if (n2 == 0) {
                    return (Short)this.getEmptyValue(deserializationContext);
                }
                if (this._hasTextualNull(string)) {
                    return (Short)this.getNullValue(deserializationContext);
                }
                n = NumberInput.parseInt((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Short value", new Object[0]);
            }
            if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
                return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, string, "overflow, value can not be represented as 16-bit value", new Object[0]);
            }
            return (short)n;
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(jsonParser, deserializationContext, "Short");
            }
            return jsonParser.getShortValue();
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue(deserializationContext);
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            Short s = this._parseShort(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return s;
        }
        return (Short)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected final short _parseShortPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int n = this._parseIntPrimitive(jsonParser, deserializationContext);
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, String.valueOf(n), "overflow, value can not be represented as 16-bit value", new Object[0]);
            return number == null ? (short)0 : number.shortValue();
        }
        return (short)n;
    }

    protected final int _parseIntPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return jsonParser.getIntValue();
        }
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (this._hasTextualNull(string)) {
                return 0;
            }
            try {
                int n = string.length();
                if (n > 9) {
                    long l = Long.parseLong(string);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "Overflow: numeric value (%s) out of range of int (%d -%d)", string, Integer.MIN_VALUE, Integer.MAX_VALUE);
                        return number == null ? 0 : number.intValue();
                    }
                    return (int)l;
                }
                if (n == 0) {
                    return 0;
                }
                return NumberInput.parseInt((String)string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid int value", new Object[0]);
                return number == null ? 0 : number.intValue();
            }
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(jsonParser, deserializationContext, "int");
            }
            return jsonParser.getValueAsInt();
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0;
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            int n = this._parseIntPrimitive(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return n;
        }
        return ((Number)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser)).intValue();
    }

    protected final Integer _parseInteger(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 7: {
                return jsonParser.getIntValue();
            }
            case 8: {
                if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(jsonParser, deserializationContext, "Integer");
                }
                return jsonParser.getValueAsInt();
            }
            case 6: {
                String string = jsonParser.getText().trim();
                try {
                    int n = string.length();
                    if (this._hasTextualNull(string)) {
                        return (Integer)this.getNullValue(deserializationContext);
                    }
                    if (n > 9) {
                        long l = Long.parseLong(string);
                        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                            return (Integer)deserializationContext.handleWeirdStringValue(this._valueClass, string, "Overflow: numeric value (" + string + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")", new Object[0]);
                        }
                        return (int)l;
                    }
                    if (n == 0) {
                        return (Integer)this.getEmptyValue(deserializationContext);
                    }
                    return NumberInput.parseInt((String)string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return (Integer)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Integer value", new Object[0]);
                }
            }
            case 11: {
                return (Integer)this.getNullValue(deserializationContext);
            }
            case 3: {
                if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                jsonParser.nextToken();
                Integer n = this._parseInteger(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return n;
            }
        }
        return (Integer)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected final Long _parseLong(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 7: {
                return jsonParser.getLongValue();
            }
            case 8: {
                if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(jsonParser, deserializationContext, "Long");
                }
                return jsonParser.getValueAsLong();
            }
            case 6: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (Long)this.getEmptyValue(deserializationContext);
                }
                if (this._hasTextualNull(string)) {
                    return (Long)this.getNullValue(deserializationContext);
                }
                try {
                    return NumberInput.parseLong((String)string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return (Long)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Long value", new Object[0]);
                }
            }
            case 11: {
                return (Long)this.getNullValue(deserializationContext);
            }
            case 3: {
                if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                jsonParser.nextToken();
                Long l = this._parseLong(jsonParser, deserializationContext);
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return l;
            }
        }
        return (Long)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected final long _parseLongPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 7: {
                return jsonParser.getLongValue();
            }
            case 8: {
                if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(jsonParser, deserializationContext, "long");
                }
                return jsonParser.getValueAsLong();
            }
            case 6: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0 || this._hasTextualNull(string)) {
                    return 0L;
                }
                try {
                    return NumberInput.parseLong((String)string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid long value", new Object[0]);
                    return number == null ? 0L : number.longValue();
                }
            }
            case 11: {
                return 0L;
            }
            case 3: {
                if (!deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                jsonParser.nextToken();
                long l = this._parseLongPrimitive(jsonParser, deserializationContext);
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return l;
            }
        }
        return ((Number)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser)).longValue();
    }

    protected final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(jsonParser.getFloatValue());
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Float)this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string)) {
                return (Float)this.getNullValue(deserializationContext);
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(string)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!this._isNaN(string)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!this._isNegInf(string)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Float)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Float value", new Object[0]);
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue(deserializationContext);
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            Float f = this._parseFloat(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return f;
        }
        return (Float)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getFloatValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0 || this._hasTextualNull(string)) {
                return 0.0f;
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(string)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(string)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!this._isNegInf(string)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid float value", new Object[0]);
                return number == null ? 0.0f : number.floatValue();
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            float f = this._parseFloatPrimitive(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return f;
        }
        return ((Number)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser)).floatValue();
    }

    protected final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Double)this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string)) {
                return (Double)this.getNullValue(deserializationContext);
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Double)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Double value", new Object[0]);
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue(deserializationContext);
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            Double d = this._parseDouble(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return d;
        }
        return (Double)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0 || this._hasTextualNull(string)) {
                return 0.0;
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Number number = (Number)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid double value", new Object[0]);
                return number == null ? 0.0 : number.doubleValue();
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            double d = this._parseDoublePrimitive(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return d;
        }
        return ((Number)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser)).doubleValue();
    }

    protected Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return new Date(jsonParser.getLongValue());
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue(deserializationContext);
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            return this._parseDate(jsonParser.getText().trim(), deserializationContext);
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            Date date = this._parseDate(jsonParser, deserializationContext);
            jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return date;
        }
        return (Date)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    protected Date _parseDate(String string, DeserializationContext deserializationContext) throws IOException {
        try {
            if (string.length() == 0) {
                return (Date)this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string)) {
                return (Date)this.getNullValue(deserializationContext);
            }
            return deserializationContext.parseDate(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Date)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation (error: %s)", illegalArgumentException.getMessage());
        }
    }

    protected static final double parseDouble(String string) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(string)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(string);
    }

    protected final String _parseString(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            return jsonParser.getText();
        }
        if (jsonToken == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jsonParser.nextToken();
            String string = this._parseString(jsonParser, deserializationContext);
            if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
            }
            return string;
        }
        String string = jsonParser.getValueAsString();
        if (string != null) {
            return string;
        }
        return (String)deserializationContext.handleUnexpectedToken(String.class, jsonParser);
    }

    protected T _deserializeFromEmpty(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_ARRAY) {
            if (deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                jsonToken = jsonParser.nextToken();
                if (jsonToken == JsonToken.END_ARRAY) {
                    return null;
                }
                return (T)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
            }
        } else if (jsonToken == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (string = jsonParser.getText().trim()).isEmpty()) {
            return null;
        }
        return (T)deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected final boolean _isNegInf(String string) {
        return "-Infinity".equals(string) || "-INF".equals(string);
    }

    protected final boolean _isPosInf(String string) {
        return "Infinity".equals(string) || "INF".equals(string);
    }

    protected final boolean _isNaN(String string) {
        return "NaN".equals(string);
    }

    protected Object _coerceIntegral(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        int n = deserializationContext.getDeserializationFeatures();
        if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(n)) {
            return jsonParser.getBigIntegerValue();
        }
        if (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(n)) {
            return jsonParser.getLongValue();
        }
        return jsonParser.getBigIntegerValue();
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext deserializationContext, JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        return deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
    }

    protected final boolean _isIntNumber(String string) {
        int n = string.length();
        if (n > 0) {
            int n2;
            char c = string.charAt(0);
            int n3 = n2 = c == '-' || c == '+' ? 1 : 0;
            while (n2 < n) {
                char c2 = string.charAt(n2);
                if (c2 > '9' || c2 < '0') {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext deserializationContext, BeanProperty beanProperty, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (annotationIntrospector != null && beanProperty != null && (annotatedMember = beanProperty.getMember()) != null && (object = annotationIntrospector.findDeserializationContentConverter(annotatedMember)) != null) {
            Converter<Object, Object> converter = deserializationContext.converterInstance(beanProperty.getMember(), object);
            JavaType javaType = converter.getInputType(deserializationContext.getTypeFactory());
            if (jsonDeserializer == null) {
                jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
            }
            return new StdDelegatingDeserializer<Object>(converter, javaType, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonFormat.Value findFormatOverrides(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz) {
        if (beanProperty != null) {
            return beanProperty.findPropertyFormat(deserializationContext.getConfig(), clazz);
        }
        return deserializationContext.getDefaultPropertyFormat(clazz);
    }

    protected Boolean findFormatFeature(DeserializationContext deserializationContext, BeanProperty beanProperty, Class<?> clazz, JsonFormat.Feature feature) {
        JsonFormat.Value value = this.findFormatOverrides(deserializationContext, beanProperty, clazz);
        if (value != null) {
            return value.getFeature(feature);
        }
        return null;
    }

    protected void handleUnknownProperty(JsonParser jsonParser, DeserializationContext deserializationContext, Object clazz, String string) throws IOException {
        if (clazz == null) {
            clazz = this.handledType();
        }
        if (deserializationContext.handleUnknownProperty(jsonParser, this, clazz, string)) {
            return;
        }
        jsonParser.skipChildren();
    }

    protected void handleMissingEndArrayForSingle(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        deserializationContext.reportWrongTokenException(jsonParser, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single '%s' value but there was more than a single value in the array", this.handledType().getName());
    }

    protected void _failDoubleToIntCoercion(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        deserializationContext.reportMappingException("Can not coerce a floating-point value ('%s') into %s; enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow", jsonParser.getValueAsString(), string);
    }
}

