/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public final class PropertyBasedCreator {
    protected final int _propertyCount;
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _propertyLookup;
    protected final SettableBeanProperty[] _allProperties;

    protected PropertyBasedCreator(ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, boolean bl) {
        int n;
        this._valueInstantiator = valueInstantiator;
        this._propertyLookup = bl ? new CaseInsensitiveMap() : new HashMap();
        this._propertyCount = n = settableBeanPropertyArray.length;
        this._allProperties = new SettableBeanProperty[n];
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty;
            this._allProperties[i] = settableBeanProperty = settableBeanPropertyArray[i];
            this._propertyLookup.put(settableBeanProperty.getName(), settableBeanProperty);
        }
    }

    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) throws JsonMappingException {
        int n = settableBeanPropertyArray.length;
        SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n];
        for (int i = 0; i < n; ++i) {
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i];
            if (!settableBeanProperty.hasValueDeserializer()) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.findContextualValueDeserializer(settableBeanProperty.getType(), settableBeanProperty));
            }
            settableBeanPropertyArray2[i] = settableBeanProperty;
        }
        return new PropertyBasedCreator(valueInstantiator, settableBeanPropertyArray2, deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
    }

    public Collection<SettableBeanProperty> properties() {
        return this._propertyLookup.values();
    }

    public SettableBeanProperty findCreatorProperty(String string) {
        return this._propertyLookup.get(string);
    }

    public SettableBeanProperty findCreatorProperty(int n) {
        for (SettableBeanProperty settableBeanProperty : this._propertyLookup.values()) {
            if (settableBeanProperty.getPropertyIndex() != n) continue;
            return settableBeanProperty;
        }
        return null;
    }

    public PropertyValueBuffer startBuilding(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectIdReader objectIdReader) {
        return new PropertyValueBuffer(jsonParser, deserializationContext, this._propertyCount, objectIdReader);
    }

    public Object build(DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer) throws IOException {
        Object object = this._valueInstantiator.createFromObjectWith(deserializationContext, this._allProperties, propertyValueBuffer);
        if (object != null) {
            object = propertyValueBuffer.handleIdValue(deserializationContext, object);
            PropertyValue propertyValue = propertyValueBuffer.buffered();
            while (propertyValue != null) {
                propertyValue.assign(object);
                propertyValue = propertyValue.next;
            }
        }
        return object;
    }

    static class CaseInsensitiveMap
    extends HashMap<String, SettableBeanProperty> {
        private static final long serialVersionUID = 1L;

        CaseInsensitiveMap() {
        }

        @Override
        public SettableBeanProperty get(Object object) {
            String string = (String)object;
            return (SettableBeanProperty)super.get(string.toLowerCase());
        }

        @Override
        public SettableBeanProperty put(String string, SettableBeanProperty settableBeanProperty) {
            string = string.toLowerCase();
            return super.put(string, settableBeanProperty);
        }
    }
}

