/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BuilderBasedDeserializer;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BeanDeserializerBuilder {
    protected final DeserializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final Map<String, SettableBeanProperty> _properties = new LinkedHashMap<String, SettableBeanProperty>();
    protected List<ValueInjector> _injectables;
    protected HashMap<String, SettableBeanProperty> _backRefProperties;
    protected HashSet<String> _ignorableProps;
    protected ValueInstantiator _valueInstantiator;
    protected ObjectIdReader _objectIdReader;
    protected SettableAnyProperty _anySetter;
    protected boolean _ignoreAllUnknown;
    protected AnnotatedMethod _buildMethod;
    protected JsonPOJOBuilder.Value _builderConfig;

    public BeanDeserializerBuilder(BeanDescription beanDescription, DeserializationConfig deserializationConfig) {
        this._beanDesc = beanDescription;
        this._config = deserializationConfig;
    }

    protected BeanDeserializerBuilder(BeanDeserializerBuilder beanDeserializerBuilder) {
        this._beanDesc = beanDeserializerBuilder._beanDesc;
        this._config = beanDeserializerBuilder._config;
        this._properties.putAll(beanDeserializerBuilder._properties);
        this._injectables = BeanDeserializerBuilder._copy(beanDeserializerBuilder._injectables);
        this._backRefProperties = BeanDeserializerBuilder._copy(beanDeserializerBuilder._backRefProperties);
        this._ignorableProps = beanDeserializerBuilder._ignorableProps;
        this._valueInstantiator = beanDeserializerBuilder._valueInstantiator;
        this._objectIdReader = beanDeserializerBuilder._objectIdReader;
        this._anySetter = beanDeserializerBuilder._anySetter;
        this._ignoreAllUnknown = beanDeserializerBuilder._ignoreAllUnknown;
        this._buildMethod = beanDeserializerBuilder._buildMethod;
        this._builderConfig = beanDeserializerBuilder._builderConfig;
    }

    private static HashMap<String, SettableBeanProperty> _copy(HashMap<String, SettableBeanProperty> hashMap) {
        return hashMap == null ? null : new HashMap<String, SettableBeanProperty>(hashMap);
    }

    private static <T> List<T> _copy(List<T> list) {
        return list == null ? null : new ArrayList<T>(list);
    }

    public void addOrReplaceProperty(SettableBeanProperty settableBeanProperty, boolean bl) {
        this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
    }

    public void addProperty(SettableBeanProperty settableBeanProperty) {
        SettableBeanProperty settableBeanProperty2 = this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
        if (settableBeanProperty2 != null && settableBeanProperty2 != settableBeanProperty) {
            throw new IllegalArgumentException("Duplicate property '" + settableBeanProperty.getName() + "' for " + this._beanDesc.getType());
        }
    }

    public void addBackReferenceProperty(String string, SettableBeanProperty settableBeanProperty) {
        if (this._backRefProperties == null) {
            this._backRefProperties = new HashMap(4);
        }
        settableBeanProperty.fixAccess(this._config);
        this._backRefProperties.put(string, settableBeanProperty);
        if (this._properties != null) {
            this._properties.remove(settableBeanProperty.getName());
        }
    }

    public void addInjectable(PropertyName propertyName, JavaType javaType, Annotations annotations, AnnotatedMember annotatedMember, Object object) {
        boolean bl;
        boolean bl2;
        if (this._injectables == null) {
            this._injectables = new ArrayList<ValueInjector>();
        }
        boolean bl3 = bl2 = (bl = this._config.canOverrideAccessModifiers()) && this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS);
        if (bl) {
            annotatedMember.fixAccess(bl2);
        }
        this._injectables.add(new ValueInjector(propertyName, javaType, annotations, annotatedMember, object));
    }

    public void addIgnorable(String string) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(string);
    }

    public void addCreatorProperty(SettableBeanProperty settableBeanProperty) {
        this.addProperty(settableBeanProperty);
    }

    public void setAnySetter(SettableAnyProperty settableAnyProperty) {
        if (this._anySetter != null && settableAnyProperty != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = settableAnyProperty;
    }

    public void setIgnoreUnknownProperties(boolean bl) {
        this._ignoreAllUnknown = bl;
    }

    public void setValueInstantiator(ValueInstantiator valueInstantiator) {
        this._valueInstantiator = valueInstantiator;
    }

    public void setObjectIdReader(ObjectIdReader objectIdReader) {
        this._objectIdReader = objectIdReader;
    }

    public void setPOJOBuilder(AnnotatedMethod annotatedMethod, JsonPOJOBuilder.Value value) {
        this._buildMethod = annotatedMethod;
        this._builderConfig = value;
    }

    public Iterator<SettableBeanProperty> getProperties() {
        return this._properties.values().iterator();
    }

    public SettableBeanProperty findProperty(PropertyName propertyName) {
        return this._properties.get(propertyName.getSimpleName());
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public SettableBeanProperty removeProperty(PropertyName propertyName) {
        return this._properties.remove(propertyName.getSimpleName());
    }

    public SettableAnyProperty getAnySetter() {
        return this._anySetter;
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public List<ValueInjector> getInjectables() {
        return this._injectables;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public AnnotatedMethod getBuildMethod() {
        return this._buildMethod;
    }

    public JsonPOJOBuilder.Value getBuilderConfig() {
        return this._builderConfig;
    }

    public JsonDeserializer<?> build() {
        boolean bl;
        Collection<SettableBeanProperty> collection = this._properties.values();
        this._fixAccess(collection);
        BeanPropertyMap beanPropertyMap = BeanPropertyMap.construct(collection, this._config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
        beanPropertyMap.assignIndexes();
        boolean bl2 = bl = !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        if (!bl) {
            for (SettableBeanProperty settableBeanProperty : collection) {
                if (!settableBeanProperty.hasViews()) continue;
                bl = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            ObjectIdValueProperty objectIdValueProperty = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            beanPropertyMap = beanPropertyMap.withProperty(objectIdValueProperty);
        }
        return new BeanDeserializer(this, this._beanDesc, beanPropertyMap, (Map<String, SettableBeanProperty>)this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, bl);
    }

    public AbstractDeserializer buildAbstract() {
        return new AbstractDeserializer(this, this._beanDesc, this._backRefProperties);
    }

    public JsonDeserializer<?> buildBuilderBased(JavaType javaType, String string) {
        Object object;
        boolean bl;
        Serializable serializable;
        Class<?> clazz;
        if (this._buildMethod == null) {
            if (!string.isEmpty()) {
                throw new IllegalArgumentException(String.format("Builder class %s does not have build method (name: '%s')", this._beanDesc.getBeanClass().getName(), string));
            }
        } else {
            clazz = this._buildMethod.getRawReturnType();
            if (clazz != (serializable = javaType.getRawClass()) && !clazz.isAssignableFrom((Class<?>)serializable) && !((Class)serializable).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Build method '" + this._buildMethod.getFullName() + " has bad return type (" + clazz.getName() + "), not compatible with POJO type (" + javaType.getRawClass().getName() + ")");
            }
        }
        clazz = this._properties.values();
        this._fixAccess((Collection<SettableBeanProperty>)((Object)clazz));
        serializable = BeanPropertyMap.construct((Collection<SettableBeanProperty>)((Object)clazz), this._config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
        ((BeanPropertyMap)serializable).assignIndexes();
        boolean bl2 = bl = !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        if (!bl) {
            object = clazz.iterator();
            while (object.hasNext()) {
                SettableBeanProperty settableBeanProperty = (SettableBeanProperty)object.next();
                if (!settableBeanProperty.hasViews()) continue;
                bl = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            object = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            serializable = ((BeanPropertyMap)serializable).withProperty((SettableBeanProperty)object);
        }
        return new BuilderBasedDeserializer(this, this._beanDesc, (BeanPropertyMap)serializable, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, bl);
    }

    private void _fixAccess(Collection<SettableBeanProperty> collection) {
        for (SettableBeanProperty settableBeanProperty : collection) {
            settableBeanProperty.fixAccess(this._config);
        }
        if (this._anySetter != null) {
            this._anySetter.fixAccess(this._config);
        }
        if (this._buildMethod != null) {
            this._buildMethod.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
    }
}

