/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ntp;

import org.apache.commons.net.ntp.NtpV3Packet;

public final class NtpUtils {
    public static String getHostAddress(int n) {
        return (n >>> 24 & 0xFF) + "." + (n >>> 16 & 0xFF) + "." + (n >>> 8 & 0xFF) + "." + (n >>> 0 & 0xFF);
    }

    public static String getRefAddress(NtpV3Packet ntpV3Packet) {
        int n = ntpV3Packet == null ? 0 : ntpV3Packet.getReferenceId();
        return NtpUtils.getHostAddress(n);
    }

    public static String getReferenceClock(NtpV3Packet ntpV3Packet) {
        char c;
        if (ntpV3Packet == null) {
            return "";
        }
        int n = ntpV3Packet.getReferenceId();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(4);
        for (int i = 24; i >= 0 && (c = (char)(n >>> i & 0xFF)) != '\u0000'; i -= 8) {
            if (!Character.isLetterOrDigit(c)) {
                return "";
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getModeName(int n) {
        switch (n) {
            case 0: {
                return "Reserved";
            }
            case 1: {
                return "Symmetric Active";
            }
            case 2: {
                return "Symmetric Passive";
            }
            case 3: {
                return "Client";
            }
            case 4: {
                return "Server";
            }
            case 5: {
                return "Broadcast";
            }
            case 6: {
                return "Control";
            }
            case 7: {
                return "Private";
            }
        }
        return "Unknown";
    }
}

