/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.parser.FTPTimestampParser;

public class FTPTimestampParserImpl
implements FTPTimestampParser,
Configurable {
    private SimpleDateFormat defaultDateFormat;
    private int defaultDateSmallestUnitIndex;
    private SimpleDateFormat recentDateFormat;
    private int recentDateSmallestUnitIndex;
    private boolean lenientFutureDates = false;
    private static final int[] CALENDAR_UNITS = new int[]{14, 13, 12, 11, 5, 2, 1};

    private static int getEntry(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat == null) {
            return 0;
        }
        String string = simpleDateFormat.toPattern();
        for (char c : "SsmHdM".toCharArray()) {
            if (string.indexOf(c) == -1) continue;
            switch (c) {
                case 'S': {
                    return FTPTimestampParserImpl.indexOf(14);
                }
                case 's': {
                    return FTPTimestampParserImpl.indexOf(13);
                }
                case 'm': {
                    return FTPTimestampParserImpl.indexOf(12);
                }
                case 'H': {
                    return FTPTimestampParserImpl.indexOf(11);
                }
                case 'd': {
                    return FTPTimestampParserImpl.indexOf(5);
                }
                case 'M': {
                    return FTPTimestampParserImpl.indexOf(2);
                }
            }
        }
        return 0;
    }

    private static int indexOf(int n) {
        for (int i = 0; i < CALENDAR_UNITS.length; ++i) {
            if (n != CALENDAR_UNITS[i]) continue;
            return i;
        }
        return 0;
    }

    private static void setPrecision(int n, Calendar calendar) {
        if (n <= 0) {
            return;
        }
        int n2 = CALENDAR_UNITS[n - 1];
        int n3 = calendar.get(n2);
        if (n3 == 0) {
            calendar.clear(n2);
        }
    }

    public FTPTimestampParserImpl() {
        this.setDefaultDateFormat("MMM d yyyy", null);
        this.setRecentDateFormat("MMM d HH:mm", null);
    }

    @Override
    public Calendar parseTimestamp(String string) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        return this.parseTimestamp(string, calendar);
    }

    public Calendar parseTimestamp(String string, Calendar calendar) throws ParseException {
        Object object;
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeZone(this.getServerTimeZone());
        Date date = null;
        if (this.recentDateFormat != null) {
            object = (Calendar)calendar.clone();
            ((Calendar)object).setTimeZone(this.getServerTimeZone());
            if (this.lenientFutureDates) {
                ((Calendar)object).add(5, 1);
            }
            String string2 = Integer.toString(((Calendar)object).get(1));
            String string3 = string + " " + string2;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.recentDateFormat.toPattern() + " yyyy", this.recentDateFormat.getDateFormatSymbols());
            simpleDateFormat.setLenient(false);
            simpleDateFormat.setTimeZone(this.recentDateFormat.getTimeZone());
            ParsePosition parsePosition = new ParsePosition(0);
            date = simpleDateFormat.parse(string3, parsePosition);
            if (date != null && parsePosition.getIndex() == string3.length()) {
                calendar2.setTime(date);
                if (calendar2.after(object)) {
                    calendar2.add(1, -1);
                }
                FTPTimestampParserImpl.setPrecision(this.recentDateSmallestUnitIndex, calendar2);
                return calendar2;
            }
        }
        if ((date = this.defaultDateFormat.parse(string, (ParsePosition)(object = new ParsePosition(0)))) == null || ((ParsePosition)object).getIndex() != string.length()) {
            throw new ParseException("Timestamp '" + string + "' could not be parsed using a server time of " + calendar.getTime().toString(), ((ParsePosition)object).getErrorIndex());
        }
        calendar2.setTime(date);
        FTPTimestampParserImpl.setPrecision(this.defaultDateSmallestUnitIndex, calendar2);
        return calendar2;
    }

    public SimpleDateFormat getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    public String getDefaultDateFormatString() {
        return this.defaultDateFormat.toPattern();
    }

    private void setDefaultDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        if (string != null) {
            this.defaultDateFormat = dateFormatSymbols != null ? new SimpleDateFormat(string, dateFormatSymbols) : new SimpleDateFormat(string);
            this.defaultDateFormat.setLenient(false);
        } else {
            this.defaultDateFormat = null;
        }
        this.defaultDateSmallestUnitIndex = FTPTimestampParserImpl.getEntry(this.defaultDateFormat);
    }

    public SimpleDateFormat getRecentDateFormat() {
        return this.recentDateFormat;
    }

    public String getRecentDateFormatString() {
        return this.recentDateFormat.toPattern();
    }

    private void setRecentDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        if (string != null) {
            this.recentDateFormat = dateFormatSymbols != null ? new SimpleDateFormat(string, dateFormatSymbols) : new SimpleDateFormat(string);
            this.recentDateFormat.setLenient(false);
        } else {
            this.recentDateFormat = null;
        }
        this.recentDateSmallestUnitIndex = FTPTimestampParserImpl.getEntry(this.recentDateFormat);
    }

    public String[] getShortMonths() {
        return this.defaultDateFormat.getDateFormatSymbols().getShortMonths();
    }

    public TimeZone getServerTimeZone() {
        return this.defaultDateFormat.getTimeZone();
    }

    private void setServerTimeZone(String string) {
        TimeZone timeZone = TimeZone.getDefault();
        if (string != null) {
            timeZone = TimeZone.getTimeZone(string);
        }
        this.defaultDateFormat.setTimeZone(timeZone);
        if (this.recentDateFormat != null) {
            this.recentDateFormat.setTimeZone(timeZone);
        }
    }

    @Override
    public void configure(FTPClientConfig fTPClientConfig) {
        DateFormatSymbols dateFormatSymbols = null;
        String string = fTPClientConfig.getServerLanguageCode();
        String string2 = fTPClientConfig.getShortMonthNames();
        dateFormatSymbols = string2 != null ? FTPClientConfig.getDateFormatSymbols(string2) : (string != null ? FTPClientConfig.lookupDateFormatSymbols(string) : FTPClientConfig.lookupDateFormatSymbols("en"));
        String string3 = fTPClientConfig.getRecentDateFormatStr();
        this.setRecentDateFormat(string3, dateFormatSymbols);
        String string4 = fTPClientConfig.getDefaultDateFormatStr();
        if (string4 == null) {
            throw new IllegalArgumentException("defaultFormatString cannot be null");
        }
        this.setDefaultDateFormat(string4, dateFormatSymbols);
        this.setServerTimeZone(fTPClientConfig.getServerTimeZoneId());
        this.lenientFutureDates = fTPClientConfig.isLenientFutureDates();
    }

    boolean isLenientFutureDates() {
        return this.lenientFutureDates;
    }

    void setLenientFutureDates(boolean bl) {
        this.lenientFutureDates = bl;
    }
}

