/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final SSLProtocolSocketFactory factory = new SSLProtocolSocketFactory();

    static SSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return SSLSocketFactory.getDefault().createSocket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        if (n3 == 0) {
            return this.createSocket(string, n, inetAddress, n2);
        }
        Socket socket = ReflectionSocketFactory.createSocket("javax.net.ssl.SSLSocketFactory", string, n, inetAddress, n2, n3);
        if (socket == null) {
            socket = ControllerThreadSocketFactory.createSocket(this, string, n, inetAddress, n2, n3);
        }
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return SSLSocketFactory.getDefault().createSocket(string, n);
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(socket, string, n, bl);
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

