/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.exec.TimeoutObserver;

public class Watchdog
implements Runnable {
    private final Vector<TimeoutObserver> observers = new Vector(1);
    private final long timeout;
    private boolean stopped = false;

    public Watchdog(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("timeout must not be less than 1.");
        }
        this.timeout = l;
    }

    public void addTimeoutObserver(TimeoutObserver timeoutObserver) {
        this.observers.addElement(timeoutObserver);
    }

    public void removeTimeoutObserver(TimeoutObserver timeoutObserver) {
        this.observers.removeElement(timeoutObserver);
    }

    protected final void fireTimeoutOccured() {
        Enumeration<TimeoutObserver> enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().timeoutOccured(this);
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread thread = new Thread((Runnable)this, "WATCHDOG");
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        long l = System.currentTimeMillis();
        Watchdog watchdog = this;
        synchronized (watchdog) {
            long l2 = this.timeout - (System.currentTimeMillis() - l);
            boolean bl2 = bl = l2 > 0L;
            while (!this.stopped && bl) {
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                l2 = this.timeout - (System.currentTimeMillis() - l);
                bl = l2 > 0L;
            }
        }
        if (!bl) {
            this.fireTimeoutOccured();
        }
    }
}

