/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.exec.util.StringUtils;

public class CommandLine {
    private final Vector<Argument> arguments = new Vector();
    private final String executable;
    private Map<String, ?> substitutionMap;
    private final boolean isFile;

    public static CommandLine parse(String string) {
        return CommandLine.parse(string, null);
    }

    public static CommandLine parse(String string, Map<String, ?> map) {
        if (string == null) {
            throw new IllegalArgumentException("Command line can not be null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Command line can not be empty");
        }
        String[] stringArray = CommandLine.translateCommandline(string);
        CommandLine commandLine = new CommandLine(stringArray[0]);
        commandLine.setSubstitutionMap(map);
        for (int i = 1; i < stringArray.length; ++i) {
            commandLine.addArgument(stringArray[i]);
        }
        return commandLine;
    }

    public CommandLine(String string) {
        this.isFile = false;
        this.executable = this.toCleanExecutable(string);
    }

    public CommandLine(File file) {
        this.isFile = true;
        this.executable = this.toCleanExecutable(file.getAbsolutePath());
    }

    public CommandLine(CommandLine commandLine) {
        this.executable = commandLine.getExecutable();
        this.isFile = commandLine.isFile();
        this.arguments.addAll(commandLine.arguments);
        if (commandLine.getSubstitutionMap() != null) {
            HashMap hashMap = new HashMap();
            this.substitutionMap = hashMap;
            for (String string : commandLine.substitutionMap.keySet()) {
                hashMap.put(string, commandLine.getSubstitutionMap().get(string));
            }
        }
    }

    public String getExecutable() {
        return StringUtils.fixFileSeparatorChar(this.expandArgument(this.executable));
    }

    public boolean isFile() {
        return this.isFile;
    }

    public CommandLine addArguments(String[] stringArray) {
        return this.addArguments(stringArray, true);
    }

    public CommandLine addArguments(String[] stringArray, boolean bl) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addArgument(string, bl);
            }
        }
        return this;
    }

    public CommandLine addArguments(String string) {
        return this.addArguments(string, true);
    }

    public CommandLine addArguments(String string, boolean bl) {
        if (string != null) {
            String[] stringArray = CommandLine.translateCommandline(string);
            this.addArguments(stringArray, bl);
        }
        return this;
    }

    public CommandLine addArgument(String string) {
        return this.addArgument(string, true);
    }

    public CommandLine addArgument(String string, boolean bl) {
        if (string == null) {
            return this;
        }
        if (bl) {
            StringUtils.quoteArgument(string);
        }
        this.arguments.add(new Argument(string, bl));
        return this;
    }

    public String[] getArguments() {
        String[] stringArray = new String[this.arguments.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            Argument argument = this.arguments.get(i);
            String string = this.expandArgument(argument.getValue());
            stringArray[i] = argument.isHandleQuoting() ? StringUtils.quoteArgument(string) : string;
        }
        return stringArray;
    }

    public Map<String, ?> getSubstitutionMap() {
        return this.substitutionMap;
    }

    public void setSubstitutionMap(Map<String, ?> map) {
        this.substitutionMap = map;
    }

    public String[] toStrings() {
        String[] stringArray = new String[this.arguments.size() + 1];
        stringArray[0] = this.getExecutable();
        System.arraycopy(this.getArguments(), 0, stringArray, 1, stringArray.length - 1);
        return stringArray;
    }

    public String toString() {
        return "[" + StringUtils.toString(this.toStrings(), ", ") + "]";
    }

    private String expandArgument(String string) {
        StringBuffer stringBuffer = StringUtils.stringSubstitution(string, this.getSubstitutionMap(), true);
        return stringBuffer.toString();
    }

    private static String[] translateCommandline(String string) {
        String[] stringArray;
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        block4: while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            switch (n) {
                case 1: {
                    if ("'".equals(stringArray)) {
                        bl = true;
                        n = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)stringArray);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(stringArray)) {
                        bl = true;
                        n = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)stringArray);
                    continue block4;
                }
            }
            if ("'".equals(stringArray)) {
                n = 1;
            } else if ("\"".equals(stringArray)) {
                n = 2;
            } else if (" ".equals(stringArray)) {
                if (bl || stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                }
            } else {
                stringBuilder.append((String)stringArray);
            }
            bl = false;
        }
        if (bl || stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        if (n == 1 || n == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + string);
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    private String toCleanExecutable(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Executable can not be null");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException("Executable can not be empty");
        }
        return StringUtils.fixFileSeparatorChar(string);
    }

    class Argument {
        private final String value;
        private final boolean handleQuoting;

        private Argument(String string, boolean bl) {
            this.value = string.trim();
            this.handleQuoting = bl;
        }

        private String getValue() {
            return this.value;
        }

        private boolean isHandleQuoting() {
            return this.handleQuoting;
        }
    }
}

