/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.parallel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.parallel.ScatterGatherBackingStore;

public class FileBasedScatterGatherBackingStore
implements ScatterGatherBackingStore {
    private final File target;
    private final FileOutputStream os;
    private boolean closed;

    public FileBasedScatterGatherBackingStore(File file) throws FileNotFoundException {
        this.target = file;
        this.os = new FileOutputStream(file);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.target);
    }

    @Override
    public void closeForWriting() throws IOException {
        if (!this.closed) {
            this.os.close();
            this.closed = true;
        }
    }

    @Override
    public void writeOut(byte[] byArray, int n, int n2) throws IOException {
        this.os.write(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        this.closeForWriting();
        this.target.delete();
    }
}

