/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.FastRunnable;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.Ticker;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public class TrivialTicker
implements Ticker {
    private final Timer timer = new Timer(true);
    private final Executor executor;
    private final Hashtable<Runnable, TimerTask> jobs = new Hashtable();
    private boolean running = true;
    private Thread shutdownThread = null;

    public TrivialTicker(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueTimedJob(final Runnable job, long offset) {
        TimerTask t = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TrivialTicker trivialTicker = TrivialTicker.this;
                synchronized (trivialTicker) {
                    TrivialTicker.this.jobs.remove(job);
                }
                if (job instanceof FastRunnable) {
                    job.run();
                } else {
                    TrivialTicker.this.executor.execute(job, "Delayed task: " + job);
                }
            }
        };
        TrivialTicker trivialTicker = this;
        synchronized (trivialTicker) {
            if (!this.running) {
                return;
            }
            this.timer.schedule(t, offset);
            this.jobs.put(job, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueTimedJob(final Runnable job, final String name, long offset, boolean runOnTickerAnyway, boolean noDupes) {
        TimerTask t = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TrivialTicker trivialTicker = TrivialTicker.this;
                synchronized (trivialTicker) {
                    TrivialTicker.this.jobs.remove(job);
                }
                if (job instanceof FastRunnable) {
                    job.run();
                } else {
                    TrivialTicker.this.executor.execute(job, name);
                }
            }
        };
        TrivialTicker trivialTicker = this;
        synchronized (trivialTicker) {
            if (!this.running) {
                return;
            }
            if (noDupes && this.jobs.containsKey(job)) {
                return;
            }
            this.timer.schedule(t, offset);
            this.jobs.put(job, t);
        }
    }

    public void cancelTimedJob(Runnable job) {
        this.removeQueuedJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueuedJob(Runnable job) {
        TrivialTicker trivialTicker = this;
        synchronized (trivialTicker) {
            if (!this.running) {
                return;
            }
            TimerTask t = this.jobs.remove(job);
            if (t != null) {
                t.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescheduleTimedJob(Runnable job, String name, long newOffset) {
        TrivialTicker trivialTicker = this;
        synchronized (trivialTicker) {
            this.removeQueuedJob(job);
            this.queueTimedJob(job, name, newOffset, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        TrivialTicker trivialTicker = this;
        synchronized (trivialTicker) {
            this.running = false;
            this.timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TrivialTicker.this.timer.cancel();
                    TrivialTicker trivialTicker = TrivialTicker.this;
                    synchronized (trivialTicker) {
                        TrivialTicker.this.shutdownThread = Thread.currentThread();
                        TrivialTicker.this.notifyAll();
                    }
                }
            }, 0L);
            while (this.shutdownThread == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            while (this.shutdownThread.isAlive()) {
                try {
                    this.shutdownThread.join();
                }
                catch (InterruptedException e) {
                    Logger.error(this, "Got an unexpected InterruptedException", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void queueTimedJobAbsolute(Runnable runner, String name, long time, boolean runOnTickerAnyway, boolean noDupes) {
        this.queueTimedJobAbsolute(runner, name, time - System.currentTimeMillis(), runOnTickerAnyway, noDupes);
    }
}

