/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class TimeSortedHashtable<T extends Comparable<T>> {
    private final TreeSet<Element<T>> elements = new TreeSet();
    private final HashMap<T, Element<T>> valueToElement = new HashMap();

    public final synchronized void push(T value, long now) {
        assert (this.elements.size() == this.valueToElement.size());
        if (value == null) {
            throw new NullPointerException();
        }
        Element<T> e = this.valueToElement.get(value);
        if (e == null) {
            e = new Element<T>(now, value);
            this.elements.add(e);
            this.valueToElement.put(value, e);
        } else {
            this.elements.remove(e);
            e.time = now;
            this.elements.add(e);
        }
        assert (this.elements.size() == this.valueToElement.size());
    }

    public final int size() {
        return this.elements.size();
    }

    public final synchronized boolean removeValue(T value) {
        assert (this.elements.size() == this.valueToElement.size());
        Element<T> e = this.valueToElement.remove(value);
        if (e == null) {
            return false;
        }
        this.elements.remove(e);
        assert (this.elements.size() == this.valueToElement.size());
        return true;
    }

    public final synchronized boolean containsValue(T key) {
        return this.valueToElement.containsKey(key);
    }

    public final synchronized long getTime(T value) {
        Element<T> e = this.valueToElement.remove(value);
        if (e == null) {
            return -1L;
        }
        return e.time;
    }

    public synchronized int countValuesAfter(long t) {
        SortedSet<Element<Object>> s = this.elements.tailSet(new Element<Object>(t, null));
        return s.size();
    }

    public final synchronized void removeBefore(long t) {
        assert (this.elements.size() == this.valueToElement.size());
        SortedSet<Element<Object>> s = this.elements.headSet(new Element<Object>(t, null));
        Iterator i = s.iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            this.valueToElement.remove(e.value);
            i.remove();
        }
        assert (this.elements.size() == this.valueToElement.size());
    }

    public final synchronized Object[] pairsAfter(long timestamp, T[] valuesArray) {
        SortedSet<Element<Object>> s = this.elements.tailSet(new Element<Object>(timestamp, null));
        Long[] timeArray = new Long[s.size()];
        int i = 0;
        for (Element element : s) {
            timeArray[i] = element.time;
            valuesArray[i] = element.value;
            ++i;
        }
        return new Object[]{valuesArray, timeArray};
    }

    private static class Element<T extends Comparable<T>>
    implements Comparable<Element<T>> {
        long time;
        final T value;

        Element(long t, T v) {
            this.time = t;
            this.value = v;
        }

        @Override
        public int compareTo(Element<T> o) {
            if (this.time > o.time) {
                return 1;
            }
            if (this.time < o.time) {
                return -1;
            }
            if (this.value == null && o.value == null) {
                return 0;
            }
            if (this.value == null && o.value != null) {
                return 1;
            }
            if (this.value != null && o.value == null) {
                return -1;
            }
            return this.value.compareTo(o.value);
        }
    }
}

