/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.CryptFormatException;
import freenet.crypt.DSAPublicKey;
import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.RetrievalException;
import freenet.io.comm.SlowAsyncMessageFilterCallback;
import freenet.io.xfer.BlockReceiver;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.Key;
import freenet.keys.KeyVerifyException;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.node.BaseSender;
import freenet.node.FSParseException;
import freenet.node.FailureTable;
import freenet.node.Node;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.RecentlyFailedReturn;
import freenet.node.RequestSenderListener;
import freenet.node.RequestTag;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.UIDTag;
import freenet.store.KeyCollisionException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.io.NativeThread;
import freenet.support.math.MedianMeanRunningAverage;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public final class RequestSender
extends BaseSender
implements PrioRunnable {
    static final long ACCEPTED_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    static final long GET_OFFER_LONG_TIMEOUT = TimeUnit.SECONDS.toMillis(60L);
    final long getOfferedTimeout;
    static final long OPENNET_TIMEOUT = TimeUnit.MINUTES.toMillis(2L);
    static final int RANDOM_REINSERT_INTERVAL = 200;
    final RequestTag origTag;
    private PartiallyReceivedBlock prb;
    private byte[] finalHeaders;
    private byte[] finalSskData;
    private DSAPublicKey pubKey;
    private SSKBlock block;
    private PeerNode transferringFrom;
    private boolean reassignedToSelfDueToMultipleTimeouts;
    private final boolean canWriteClientCache;
    private final boolean canWriteDatastore;
    private boolean tryOffersOnly;
    private final ArrayList<RequestSenderListener> listeners = new ArrayList();
    private int status = -1;
    static final int NOT_FINISHED = -1;
    static final int SUCCESS = 0;
    static final int ROUTE_NOT_FOUND = 1;
    static final int DATA_NOT_FOUND = 3;
    static final int TRANSFER_FAILED = 4;
    static final int VERIFY_FAILURE = 5;
    static final int TIMED_OUT = 6;
    static final int GENERATED_REJECTED_OVERLOAD = 7;
    static final int INTERNAL_ERROR = 8;
    static final int RECENTLY_FAILED = 9;
    static final int GET_OFFER_VERIFY_FAILURE = 10;
    static final int GET_OFFER_TRANSFER_FAILED = 11;
    private PeerNode successFrom;
    private static volatile boolean logMINOR;
    static final int MAX_HIGH_HTL_FAILURES = 5;
    private boolean starting;
    private int highHTLFailureCount = 0;
    private boolean killedByRecentlyFailed = false;
    private volatile boolean hasForwardedRejectedOverload;
    static final short WAIT_REJECTED_OVERLOAD = 1;
    static final short WAIT_TRANSFERRING_DATA = 2;
    static final short WAIT_FINISHED = 4;
    static final short WAIT_ALL = 7;
    private static MedianMeanRunningAverage avgTimeTaken;
    private static MedianMeanRunningAverage avgTimeTakenTransfer;
    private long transferTime;
    static final double PINGS = 3.0;
    static final double PINGS_STDDEV = 0.5;
    static final double MAX_PING_TIME;
    private boolean opennetFinished;
    private boolean opennetTimedOut;
    private byte[] opennetNoderef;
    private final Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;
    private int recentlyFailedTimeLeft;
    private boolean sentReceivedRejectOverload;
    private boolean sentCHKTransferBegins;
    private boolean sentRequestSenderFinished;
    private boolean completedFromOfferedKey;
    private boolean sentAbortDownstreamTransfers;
    private int abortDownstreamTransfersReason;
    private String abortDownstreamTransfersDesc;
    private boolean receivingAsync;
    BlockReceiver.BlockReceiverTimeoutHandler myTimeoutHandler = new BlockReceiver.BlockReceiverTimeoutHandler(){

        @Override
        public void onFirstTimeout() {
            RequestSender.this.origTag.timedOutToHandlerButContinued();
        }

        @Override
        public void onFatalTimeout(PeerContext receivingFrom) {
            Logger.error(this, "Fatal timeout receiving requested block on " + this + " from " + receivingFrom);
            ((PeerNode)receivingFrom).fatalTimeout();
        }
    };
    private boolean transferCoalesced;
    private int searchTimeout;

    static String getStatusString(int status) {
        switch (status) {
            case -1: {
                return "NOT FINISHED";
            }
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "ROUTE NOT FOUND";
            }
            case 3: {
                return "DATA NOT FOUND";
            }
            case 4: {
                return "TRANSFER FAILED";
            }
            case 11: {
                return "GET OFFER TRANSFER FAILED";
            }
            case 5: {
                return "VERIFY FAILURE";
            }
            case 10: {
                return "GET OFFER VERIFY FAILURE";
            }
            case 6: {
                return "TIMED OUT";
            }
            case 7: {
                return "GENERATED REJECTED OVERLOAD";
            }
            case 8: {
                return "INTERNAL ERROR";
            }
            case 9: {
                return "RECENTLY FAILED";
            }
        }
        return "UNKNOWN STATUS CODE: " + status;
    }

    String getStatusString() {
        return RequestSender.getStatusString(this.getStatus());
    }

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    public RequestSender(Key key, DSAPublicKey pubKey, short htl, long uid, RequestTag tag, Node n, PeerNode source, boolean offersOnly, boolean canWriteClientCache, boolean canWriteDatastore, boolean realTimeFlag) {
        super(key, realTimeFlag, source, n, htl, uid);
        this.getOfferedTimeout = realTimeFlag ? BlockReceiver.RECEIPT_TIMEOUT_REALTIME : BlockReceiver.RECEIPT_TIMEOUT_BULK;
        this.pubKey = pubKey;
        this.origTag = tag;
        this.tryOffersOnly = offersOnly;
        this.canWriteClientCache = canWriteClientCache;
        this.canWriteDatastore = canWriteDatastore;
    }

    public void start() {
        this.node.executor.execute(this, "RequestSender for UID " + this.uid + " on " + this.node.getDarknetPortNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.node.getTicker().queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean fromOfferedKey;
                RequestSender requestSender = RequestSender.this;
                synchronized (requestSender) {
                    if (RequestSender.this.status != -1) {
                        return;
                    }
                    if (RequestSender.this.transferringFrom != null) {
                        return;
                    }
                    RequestSender.this.reassignedToSelfDueToMultipleTimeouts = true;
                    fromOfferedKey = RequestSender.this.routeAttempts == 0;
                }
                Logger.normal(this, "Reassigning to self on timeout: " + RequestSender.this);
                RequestSender.this.reassignToSelfOnTimeout(fromOfferedKey);
            }
        }, this.incomingSearchTimeout);
        try {
            this.realRun();
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
            this.finish(8, null, false);
        }
        finally {
            if (this.status == -1 && !this.receivingAsync) {
                Logger.error(this, "Not finished: " + this);
                this.finish(8, null, false);
            }
            if (logMINOR) {
                Logger.minor(this, "Leaving RequestSender.run() for " + this.uid);
            }
        }
    }

    private void realRun() {
        FailureTable.OfferList offers;
        Logger.OSThread.logPID(this);
        if (this.isSSK && this.pubKey == null) {
            this.pubKey = ((NodeSSK)this.key).getPubKey();
        }
        if ((offers = this.node.failureTable.getOffers(this.key)) != null) {
            this.tryOffers(offers, null, null);
        } else {
            this.startRequests();
        }
    }

    private void startRequests() {
        if (this.tryOffersOnly) {
            if (logMINOR) {
                Logger.minor(this, "Tried all offers, not doing a regular request for key");
            }
            this.finish(3, null, true);
            return;
        }
        this.routeAttempts = 0;
        this.starting = true;
        this.highHTLFailureCount = 0;
        this.routeRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void routeRequests() {
        boolean failed;
        if (logMINOR) {
            Logger.minor(this, "Routing requests on " + this, (Throwable)new Exception("debug"));
        }
        PeerNode next = null;
        boolean canWriteStorePrev = this.node.canWriteDatastoreInsert(this.htl);
        if (this.dontDecrementHTLThisTime) {
            this.dontDecrementHTLThisTime = false;
        } else if (!this.starting && !canWriteStorePrev) {
            if (this.highHTLFailureCount++ >= 5) {
                if (logMINOR) {
                    Logger.minor(this, "Too many failures at non-cacheable HTL");
                }
                this.finish(1, null, false);
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Allowing failure " + this.highHTLFailureCount + " htl is still " + this.htl);
            }
        } else {
            this.htl = this.node.decrementHTL(this.hasForwarded ? next : this.source, this.htl);
            if (logMINOR) {
                Logger.minor(this, "Decremented HTL to " + this.htl);
            }
        }
        this.starting = false;
        if (logMINOR) {
            Logger.minor(this, "htl=" + this.htl);
        }
        if (this.htl <= 0) {
            this.node.failureTable.onFinalFailure(this.key, null, this.htl, this.origHTL, FailureTable.RECENTLY_FAILED_TIME, FailureTable.REJECT_TIME, this.source);
            this.finish(3, null, false);
            return;
        }
        RequestSender requestSender = this;
        synchronized (requestSender) {
            failed = this.reassignedToSelfDueToMultipleTimeouts;
            if (!failed) {
                ++this.routeAttempts;
            }
        }
        if (failed) {
            this.finish(6, null, false);
            return;
        }
        if (this.origTag.shouldStop()) {
            this.finish(1, null, false);
            return;
        }
        RecentlyFailedReturn r = new RecentlyFailedReturn();
        long now = System.currentTimeMillis();
        next = this.node.peers.closerPeer(this.source, this.nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, 2.0, this.key, this.htl, 0L, this.source == null, this.realTimeFlag, r, false, now, this.newLoadManagement);
        long recentlyFailed = r.recentlyFailed();
        if (recentlyFailed > now) {
            RequestSender requestSender2 = this;
            synchronized (requestSender2) {
                this.recentlyFailedTimeLeft = (int)Math.min(Integer.MAX_VALUE, recentlyFailed - now);
            }
            this.finish(9, null, false);
            this.node.failureTable.onFinalFailure(this.key, null, this.htl, this.origHTL, -1L, -1L, this.source);
            return;
        }
        boolean rfAnyway = false;
        RequestSender requestSender3 = this;
        synchronized (requestSender3) {
            rfAnyway = this.killedByRecentlyFailed;
        }
        if (rfAnyway) {
            requestSender3 = this;
            synchronized (requestSender3) {
                this.recentlyFailedTimeLeft = 0;
            }
            this.finish(9, null, false);
            this.node.failureTable.onFinalFailure(this.key, null, this.htl, this.origHTL, -1L, -1L, this.source);
            return;
        }
        if (next == null) {
            if (logMINOR && this.rejectOverloads > 0) {
                Logger.minor(this, "no more peers, but overloads (" + this.rejectOverloads + "/" + this.routeAttempts + " overloaded)");
            }
            this.finish(1, null, false);
            this.node.failureTable.onFinalFailure(this.key, null, this.htl, this.origHTL, -1L, -1L, this.source);
            return;
        }
        this.innerRouteRequests(next, this.origTag);
    }

    private synchronized long timeSinceSentForTimeout() {
        int time = this.timeSinceSent();
        if ((long)time > FailureTable.REJECT_TIME) {
            if ((long)time < (long)this.searchTimeout + TimeUnit.SECONDS.toMillis(10L)) {
                return FailureTable.REJECT_TIME;
            }
            Logger.error(this, "Very long time since sent: " + time + " (" + TimeUtil.formatTime(time, 2, true) + ")");
            return FailureTable.REJECT_TIME;
        }
        return time;
    }

    private void tryOffers(FailureTable.OfferList offers, PeerNode pn, OFFER_STATUS status) {
        while (true) {
            if (pn == null) {
                FailureTable.BlockOffer offer = offers.getFirstOffer();
                if (offer == null) {
                    if (logMINOR) {
                        Logger.minor(this, "No more offers");
                    }
                    this.startRequests();
                    return;
                }
                pn = offer.getPeerNode();
                status = this.tryOffer(offer, pn, offers);
            }
            switch (status) {
                case FATAL: {
                    offers.deleteLastOffer();
                    pn.noLongerRoutingTo(this.origTag, true);
                    return;
                }
                case TWO_STAGE_TIMEOUT: {
                    offers.deleteLastOffer();
                    break;
                }
                case FETCHING: {
                    return;
                }
                case KEEP: {
                    offers.keepLastOffer();
                    pn.noLongerRoutingTo(this.origTag, true);
                    break;
                }
                case TRY_ANOTHER: {
                    offers.deleteLastOffer();
                    pn.noLongerRoutingTo(this.origTag, true);
                }
            }
            pn = null;
            status = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OFFER_STATUS tryOffer(final FailureTable.BlockOffer offer, final PeerNode pn, final FailureTable.OfferList offers) {
        if (pn == null) {
            return OFFER_STATUS.TRY_ANOTHER;
        }
        if (pn.getBootID() != offer.bootID) {
            return OFFER_STATUS.TRY_ANOTHER;
        }
        this.origTag.addRoutedTo(pn, true);
        Message msg = DMT.createFNPGetOfferedKey(this.key, offer.authenticator, this.pubKey == null, this.uid);
        msg.addSubMessage(DMT.createFNPRealTimeFlag(this.realTimeFlag));
        try {
            pn.sendSync(msg, this, this.realTimeFlag);
        }
        catch (NotConnectedException e2) {
            if (logMINOR) {
                Logger.minor(this, "Disconnected: " + pn + " getting offer for " + this.key);
            }
            return OFFER_STATUS.TRY_ANOTHER;
        }
        catch (SyncSendWaitedTooLongException e) {
            if (logMINOR) {
                Logger.minor(this, "Took too long sending offer get to " + pn + " for " + this.key);
            }
            return OFFER_STATUS.TRY_ANOTHER;
        }
        RequestSender e = this;
        synchronized (e) {
            this.receivingAsync = true;
        }
        try {
            this.node.usm.addAsyncFilter(this.getOfferedKeyReplyFilter(pn, this.getOfferedTimeout), new SlowAsyncMessageFilterCallback(){

                @Override
                public void onMatched(Message m) {
                    OFFER_STATUS status = RequestSender.this.isSSK ? RequestSender.this.handleSSKOfferReply(m, pn, offer) : RequestSender.this.handleCHKOfferReply(m, pn, offer, offers);
                    RequestSender.this.tryOffers(offers, pn, status);
                }

                @Override
                public boolean shouldTimeout() {
                    return false;
                }

                @Override
                public void onTimeout() {
                    Logger.warning(this, "Timeout awaiting reply to offer request on " + this + " to " + pn);
                    OFFER_STATUS status = RequestSender.this.handleOfferTimeout(offer, pn, offers);
                    RequestSender.this.tryOffers(offers, pn, status);
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                    if (logMINOR) {
                        Logger.minor(this, "Disconnected: " + pn + " getting offer for " + RequestSender.this.key);
                    }
                    RequestSender.this.tryOffers(offers, pn, OFFER_STATUS.TRY_ANOTHER);
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                    if (logMINOR) {
                        Logger.minor(this, "Disconnected: " + pn + " getting offer for " + RequestSender.this.key);
                    }
                    RequestSender.this.tryOffers(offers, pn, OFFER_STATUS.TRY_ANOTHER);
                }

                @Override
                public int getPriority() {
                    return NativeThread.HIGH_PRIORITY;
                }
            }, this);
            return OFFER_STATUS.FETCHING;
        }
        catch (DisconnectedException e3) {
            if (logMINOR) {
                Logger.minor(this, "Disconnected: " + pn + " getting offer for " + this.key);
            }
            return OFFER_STATUS.TRY_ANOTHER;
        }
    }

    private MessageFilter getOfferedKeyReplyFilter(PeerNode pn, long timeout) {
        MessageFilter mfRO = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPRejectedOverload);
        MessageFilter mfGetInvalid = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPGetOfferedKeyInvalid);
        if (this.isSSK) {
            MessageFilter mfAltDF = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPSSKDataFoundHeaders);
            return mfAltDF.or(mfRO.or(mfGetInvalid));
        }
        MessageFilter mfDF = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPCHKDataFound);
        return mfDF.or(mfRO.or(mfGetInvalid));
    }

    private OFFER_STATUS handleOfferTimeout(final FailureTable.BlockOffer offer, final PeerNode pn, FailureTable.OfferList offers) {
        try {
            this.node.usm.addAsyncFilter(this.getOfferedKeyReplyFilter(pn, GET_OFFER_LONG_TIMEOUT), new SlowAsyncMessageFilterCallback(){

                @Override
                public void onMatched(Message m) {
                    OFFER_STATUS status;
                    OFFER_STATUS oFFER_STATUS = status = RequestSender.this.isSSK ? RequestSender.this.handleSSKOfferReply(m, pn, offer) : RequestSender.this.handleCHKOfferReply(m, pn, offer, null);
                    if (status != OFFER_STATUS.FETCHING) {
                        pn.noLongerRoutingTo(RequestSender.this.origTag, true);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Forked get offered key due to two stage timeout completed with status " + (Object)((Object)status) + " from message " + m + " for " + RequestSender.this + " to " + pn);
                    }
                }

                @Override
                public boolean shouldTimeout() {
                    return false;
                }

                @Override
                public void onTimeout() {
                    Logger.error(this, "Fatal timeout getting offered key from " + pn + " for " + RequestSender.this);
                    pn.fatalTimeout(RequestSender.this.origTag, true);
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                    pn.noLongerRoutingTo(RequestSender.this.origTag, true);
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                    pn.noLongerRoutingTo(RequestSender.this.origTag, true);
                }

                @Override
                public int getPriority() {
                    return NativeThread.HIGH_PRIORITY;
                }
            }, this);
            return OFFER_STATUS.TWO_STAGE_TIMEOUT;
        }
        catch (DisconnectedException e) {
            if (logMINOR) {
                Logger.minor(this, "Disconnected (2): " + pn + " getting offer for " + this.key);
            }
            return OFFER_STATUS.TRY_ANOTHER;
        }
    }

    private OFFER_STATUS handleSSKOfferReply(Message reply, PeerNode pn, FailureTable.BlockOffer offer) {
        if (reply.getSpec() == DMT.FNPRejectedOverload) {
            if (logMINOR) {
                Logger.minor(this, "Node " + pn + " rejected FNPGetOfferedKey for " + this.key + " (expired=" + offer.isExpired());
            }
            return OFFER_STATUS.KEEP;
        }
        if (reply.getSpec() == DMT.FNPGetOfferedKeyInvalid) {
            if (logMINOR) {
                Logger.minor(this, "Node " + pn + " rejected FNPGetOfferedKey as invalid with reason " + reply.getShort("reason"));
            }
            return OFFER_STATUS.TRY_ANOTHER;
        }
        if (reply.getSpec() == DMT.FNPSSKDataFoundHeaders) {
            Message dataMessage;
            byte[] headers = ((ShortBuffer)reply.getObject("blockHeaders")).getData();
            MessageFilter mfData = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(this.getOfferedTimeout).setType(DMT.FNPSSKDataFoundData);
            try {
                dataMessage = this.node.usm.waitFor(mfData, this);
            }
            catch (DisconnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Disconnected: " + pn + " getting data for offer for " + this.key);
                }
                return OFFER_STATUS.TRY_ANOTHER;
            }
            if (dataMessage == null) {
                Logger.error(this, "Got headers but not data from " + pn + " for offer for " + this.key + " on " + this);
                return OFFER_STATUS.TRY_ANOTHER;
            }
            byte[] sskData = ((ShortBuffer)dataMessage.getObject("data")).getData();
            if (this.pubKey == null) {
                Message pk;
                MessageFilter mfPK = MessageFilter.create().setSource(pn).setField("uid", this.uid).setTimeout(this.getOfferedTimeout).setType(DMT.FNPSSKPubKey);
                try {
                    pk = this.node.usm.waitFor(mfPK, this);
                }
                catch (DisconnectedException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Disconnected: " + pn + " getting pubkey for offer for " + this.key);
                    }
                    return OFFER_STATUS.TRY_ANOTHER;
                }
                if (pk == null) {
                    Logger.error(this, "Got data but not pubkey from " + pn + " for offer for " + this.key + " on " + this);
                    return OFFER_STATUS.TRY_ANOTHER;
                }
                try {
                    this.pubKey = DSAPublicKey.create(((ShortBuffer)pk.getObject("pubkeyAsBytes")).getData());
                }
                catch (CryptFormatException e) {
                    Logger.error(this, "Bogus pubkey from " + pn + " for offer for " + this.key + " : " + e, (Throwable)e);
                    return OFFER_STATUS.TRY_ANOTHER;
                }
                try {
                    ((NodeSSK)this.key).setPubKey(this.pubKey);
                }
                catch (SSKVerifyException e) {
                    Logger.error(this, "Bogus SSK data from " + pn + " for offer for " + this.key + " : " + e, (Throwable)e);
                    return OFFER_STATUS.TRY_ANOTHER;
                }
            }
            if (this.finishSSKFromGetOffer(pn, headers, sskData)) {
                if (logMINOR) {
                    Logger.minor(this, "Successfully fetched SSK from offer from " + pn + " for " + this.key);
                }
                return OFFER_STATUS.FETCHING;
            }
            return OFFER_STATUS.TRY_ANOTHER;
        }
        Logger.error(this, "Unexpected reply to get offered key: " + reply);
        return OFFER_STATUS.TRY_ANOTHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OFFER_STATUS handleCHKOfferReply(Message reply, final PeerNode pn, FailureTable.BlockOffer offer, final FailureTable.OfferList offers) {
        if (reply.getSpec() == DMT.FNPRejectedOverload) {
            if (logMINOR) {
                Logger.minor(this, "Node " + pn + " rejected FNPGetOfferedKey for " + this.key + " (expired=" + offer.isExpired());
            }
            return OFFER_STATUS.KEEP;
        }
        if (reply.getSpec() == DMT.FNPGetOfferedKeyInvalid) {
            if (logMINOR) {
                Logger.minor(this, "Node " + pn + " rejected FNPGetOfferedKey as invalid with reason " + reply.getShort("reason"));
            }
            return OFFER_STATUS.TRY_ANOTHER;
        }
        if (reply.getSpec() == DMT.FNPCHKDataFound) {
            this.finalHeaders = ((ShortBuffer)reply.getObject("blockHeaders")).getData();
            this.origTag.senderTransferBegins((NodeCHK)this.key, this);
            try {
                this.prb = new PartiallyReceivedBlock(32, 1024);
                RequestSender requestSender = this;
                synchronized (requestSender) {
                    this.transferringFrom = pn;
                    this.notifyAll();
                }
                this.fireCHKTransferBegins();
                BlockReceiver br = new BlockReceiver(this.node.usm, pn, this.uid, this.prb, this, this.node.getTicker(), true, this.realTimeFlag, this.myTimeoutHandler, true);
                if (logMINOR) {
                    Logger.minor(this, "Receiving data (for offer reply)");
                }
                this.receivingAsync = true;
                br.receive(new BlockReceiver.BlockReceiverCompletion(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void blockReceived(byte[] data) {
                        RequestSender requestSender = RequestSender.this;
                        synchronized (requestSender) {
                            RequestSender.this.transferringFrom = null;
                        }
                        RequestSender.this.origTag.senderTransferEnds((NodeCHK)RequestSender.this.key, RequestSender.this);
                        try {
                            pn.transferSuccess(RequestSender.this.realTimeFlag);
                            if (logMINOR) {
                                Logger.minor(this, "Received data from offer reply");
                            }
                            RequestSender.this.verifyAndCommit(RequestSender.this.finalHeaders, data);
                            RequestSender.this.finish(0, pn, true);
                            RequestSender.this.node.nodeStats.successfulBlockReceive(RequestSender.this.realTimeFlag, RequestSender.this.source == null);
                        }
                        catch (KeyVerifyException e1) {
                            Logger.normal(this, "Got data but verify failed: " + e1, (Throwable)e1);
                            if (offers != null) {
                                RequestSender.this.finish(10, pn, true);
                                offers.deleteLastOffer();
                            }
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Failed on " + this, t);
                            if (offers != null) {
                                RequestSender.this.finish(8, pn, true);
                            }
                        }
                        finally {
                            pn.noLongerRoutingTo(RequestSender.this.origTag, true);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void blockReceiveFailed(RetrievalException e) {
                        RequestSender requestSender = RequestSender.this;
                        synchronized (requestSender) {
                            RequestSender.this.transferringFrom = null;
                        }
                        RequestSender.this.origTag.senderTransferEnds((NodeCHK)RequestSender.this.key, RequestSender.this);
                        try {
                            if (e.getReason() == 7) {
                                Logger.normal(this, "Transfer failed (disconnect): " + e, (Throwable)e);
                            } else {
                                Logger.normal(this, "Transfer for offer failed (" + e.getReason() + "/" + RetrievalException.getErrString(e.getReason()) + "): " + e + " from " + pn, (Throwable)e);
                            }
                            if (offers != null) {
                                RequestSender.this.finish(11, pn, true);
                            }
                            pn.transferFailed("RequestSenderGetOfferedTransferFailed", RequestSender.this.realTimeFlag);
                            if (offers != null) {
                                offers.deleteLastOffer();
                            }
                            if (!RequestSender.this.prb.abortedLocally()) {
                                RequestSender.this.node.nodeStats.failedBlockReceive(false, false, RequestSender.this.realTimeFlag, RequestSender.this.source == null);
                            }
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Failed on " + this, t);
                            if (offers != null) {
                                RequestSender.this.finish(8, pn, true);
                            }
                        }
                        finally {
                            pn.noLongerRoutingTo(RequestSender.this.origTag, true);
                        }
                    }
                });
                OFFER_STATUS oFFER_STATUS = OFFER_STATUS.FETCHING;
                return oFFER_STATUS;
            }
            finally {
                this.origTag.senderTransferEnds((NodeCHK)this.key, this);
            }
        }
        Logger.error(this, "Unexpected reply to get offered key: " + reply);
        return OFFER_STATUS.TRY_ANOTHER;
    }

    @Override
    protected MessageFilter makeAcceptedRejectedFilter(PeerNode next, long acceptedTimeout, UIDTag tag) {
        assert (tag == this.origTag);
        MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(acceptedTimeout).setType(DMT.FNPAccepted);
        MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(acceptedTimeout).setType(DMT.FNPRejectedLoop);
        MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(acceptedTimeout).setType(DMT.FNPRejectedOverload);
        return mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload));
    }

    private MessageFilter createMessageFilter(int timeout, PeerNode next) {
        MessageFilter mfDNF = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPDataNotFound);
        MessageFilter mfRF = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPRecentlyFailed);
        MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPRouteNotFound);
        MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPRejectedOverload);
        MessageFilter mf = mfDNF.or(mfRF.or(mfRouteNotFound.or(mfRejectedOverload)));
        if (!this.isSSK) {
            MessageFilter mfRealDFCHK = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPCHKDataFound);
            mf = mfRealDFCHK.or(mf);
        } else {
            MessageFilter mfPubKey = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPSSKPubKey);
            MessageFilter mfDFSSKHeaders = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPSSKDataFoundHeaders);
            MessageFilter mfDFSSKData = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(timeout).setType(DMT.FNPSSKDataFoundData);
            mf = mfPubKey.or(mfDFSSKHeaders.or(mfDFSSKData.or(mf)));
        }
        return mf;
    }

    private BaseSender.DO handleMessage(Message msg, boolean wasFork, PeerNode source, MainLoopCallback waiter) {
        ++this.gotMessages;
        this.lastMessage = msg.getSpec().getName();
        if (logMINOR) {
            Logger.minor(this, "Handling message " + msg + " on " + this);
        }
        if (msg.getSpec() == DMT.FNPDataNotFound) {
            this.handleDataNotFound(msg, wasFork, source);
            return BaseSender.DO.FINISHED;
        }
        if (msg.getSpec() == DMT.FNPRecentlyFailed) {
            this.handleRecentlyFailed(msg, wasFork, source);
            return BaseSender.DO.NEXT_PEER;
        }
        if (msg.getSpec() == DMT.FNPRouteNotFound) {
            this.handleRouteNotFound(msg, source);
            return BaseSender.DO.NEXT_PEER;
        }
        if (msg.getSpec() == DMT.FNPRejectedOverload) {
            if (this.handleRejectedOverload(msg, wasFork, source)) {
                return BaseSender.DO.WAIT;
            }
            return BaseSender.DO.FINISHED;
        }
        if (!this.isSSK && msg.getSpec() == DMT.FNPCHKDataFound) {
            this.handleCHKDataFound(msg, wasFork, source, waiter);
            return BaseSender.DO.FINISHED;
        }
        if (this.isSSK && msg.getSpec() == DMT.FNPSSKPubKey) {
            if (!this.handleSSKPubKey(msg, source)) {
                return BaseSender.DO.NEXT_PEER;
            }
            if (waiter.sskData != null && waiter.headers != null) {
                this.finishSSK(source, wasFork, waiter.headers, waiter.sskData);
                return BaseSender.DO.FINISHED;
            }
            return BaseSender.DO.WAIT;
        }
        if (this.isSSK && msg.getSpec() == DMT.FNPSSKDataFoundData) {
            if (logMINOR) {
                Logger.minor(this, "Got data on " + this.uid);
            }
            waiter.sskData = ((ShortBuffer)msg.getObject("data")).getData();
            if (this.pubKey != null && waiter.headers != null) {
                this.finishSSK(source, wasFork, waiter.headers, waiter.sskData);
                return BaseSender.DO.FINISHED;
            }
            return BaseSender.DO.WAIT;
        }
        if (this.isSSK && msg.getSpec() == DMT.FNPSSKDataFoundHeaders) {
            if (logMINOR) {
                Logger.minor(this, "Got headers on " + this.uid);
            }
            waiter.headers = ((ShortBuffer)msg.getObject("blockHeaders")).getData();
            if (this.pubKey != null && waiter.sskData != null) {
                this.finishSSK(source, wasFork, waiter.headers, waiter.sskData);
                return BaseSender.DO.FINISHED;
            }
            return BaseSender.DO.WAIT;
        }
        Logger.error(this, "Unexpected message: " + msg);
        int t = this.timeSinceSent();
        this.node.failureTable.onFailed(this.key, source, this.htl, t, t);
        source.noLongerRoutingTo(this.origTag, false);
        return BaseSender.DO.NEXT_PEER;
    }

    private boolean handleSSKPubKey(Message msg, PeerNode next) {
        if (logMINOR) {
            Logger.minor(this, "Got pubkey on " + this.uid);
        }
        byte[] pubkeyAsBytes = ((ShortBuffer)msg.getObject("pubkeyAsBytes")).getData();
        try {
            if (this.pubKey == null) {
                this.pubKey = DSAPublicKey.create(pubkeyAsBytes);
            }
            ((NodeSSK)this.key).setPubKey(this.pubKey);
            return true;
        }
        catch (SSKVerifyException e) {
            this.pubKey = null;
            Logger.error(this, "Invalid pubkey from " + this.source + " on " + this.uid + " (" + e.getMessage() + ')', (Throwable)e);
            int t = this.timeSinceSent();
            this.node.failureTable.onFailed(this.key, next, this.htl, t, t);
            next.noLongerRoutingTo(this.origTag, false);
            return false;
        }
        catch (CryptFormatException e) {
            Logger.error(this, "Invalid pubkey from " + this.source + " on " + this.uid + " (" + e + ')');
            int t = this.timeSinceSent();
            this.node.failureTable.onFailed(this.key, next, this.htl, t, t);
            next.noLongerRoutingTo(this.origTag, false);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCHKDataFound(Message msg, final boolean wasFork, final PeerNode next, final MainLoopCallback waiter) {
        waiter.headers = ((ShortBuffer)msg.getObject("blockHeaders")).getData();
        if (!wasFork) {
            this.origTag.senderTransferBegins((NodeCHK)this.key, this);
        }
        final PartiallyReceivedBlock prb = new PartiallyReceivedBlock(32, 1024);
        boolean failNow = false;
        RequestSender requestSender = this;
        synchronized (requestSender) {
            this.finalHeaders = waiter.headers;
            if (this.status == 0 || this.prb != null && this.transferringFrom != null) {
                failNow = true;
            }
            if (!(wasFork || this.prb != null && this.prb.allReceivedAndNotAborted())) {
                this.prb = prb;
            }
            this.notifyAll();
        }
        if (!wasFork) {
            this.fireCHKTransferBegins();
        }
        final long tStart = System.currentTimeMillis();
        final BlockReceiver br = new BlockReceiver(this.node.usm, next, this.uid, prb, this, this.node.getTicker(), true, this.realTimeFlag, this.myTimeoutHandler, true);
        if (failNow) {
            if (logMINOR) {
                Logger.minor(this, "Terminating forked transfer on " + this + " from " + next);
            }
            prb.abort(9, "Cancelling fork", true);
            br.receive(new BlockReceiver.BlockReceiverCompletion(){

                @Override
                public void blockReceived(byte[] buf) {
                    if (!wasFork) {
                        RequestSender.this.origTag.senderTransferEnds((NodeCHK)RequestSender.this.key, RequestSender.this);
                    }
                    next.noLongerRoutingTo(RequestSender.this.origTag, false);
                }

                @Override
                public void blockReceiveFailed(RetrievalException e) {
                    if (!wasFork) {
                        RequestSender.this.origTag.senderTransferEnds((NodeCHK)RequestSender.this.key, RequestSender.this);
                    }
                    next.noLongerRoutingTo(RequestSender.this.origTag, false);
                }
            });
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Receiving data");
        }
        if (!wasFork) {
            RequestSender requestSender2 = this;
            synchronized (requestSender2) {
                this.transferringFrom = next;
            }
        } else if (logMINOR) {
            Logger.minor(this, "Receiving data from fork");
        }
        this.receivingAsync = true;
        br.receive(new BlockReceiver.BlockReceiverCompletion(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void blockReceived(byte[] data) {
                try {
                    long tEnd = System.currentTimeMillis();
                    RequestSender.this.transferTime = tEnd - tStart;
                    boolean haveSetPRB = false;
                    RequestSender requestSender = RequestSender.this;
                    synchronized (requestSender) {
                        RequestSender.this.transferringFrom = null;
                        if (RequestSender.this.prb == null || !RequestSender.this.prb.allReceivedAndNotAborted()) {
                            RequestSender.this.prb = prb;
                            haveSetPRB = true;
                        }
                    }
                    if (!wasFork) {
                        RequestSender.this.origTag.senderTransferEnds((NodeCHK)RequestSender.this.key, RequestSender.this);
                    }
                    next.transferSuccess(RequestSender.this.realTimeFlag);
                    next.successNotOverload(RequestSender.this.realTimeFlag);
                    RequestSender.this.node.nodeStats.successfulBlockReceive(RequestSender.this.realTimeFlag, RequestSender.this.source == null);
                    if (logMINOR) {
                        Logger.minor(this, "Received data");
                    }
                    try {
                        RequestSender.this.verifyAndCommit(waiter.headers, data);
                        if (logMINOR) {
                            Logger.minor(this, "Written to store");
                        }
                    }
                    catch (KeyVerifyException e1) {
                        Logger.normal(this, "Got data but verify failed: " + e1, (Throwable)e1);
                        RequestSender.this.node.failureTable.onFinalFailure(RequestSender.this.key, next, RequestSender.this.htl, RequestSender.this.origHTL, FailureTable.RECENTLY_FAILED_TIME, FailureTable.REJECT_TIME, RequestSender.this.source);
                        if (!wasFork) {
                            RequestSender.this.finish(5, next, false);
                        } else {
                            next.noLongerRoutingTo(RequestSender.this.origTag, false);
                        }
                        if (wasFork) {
                            next.noLongerRoutingTo(RequestSender.this.origTag, false);
                        }
                        return;
                    }
                    if (haveSetPRB) {
                        RequestSender.this.fireCHKTransferBegins();
                    }
                    RequestSender.this.finish(0, next, false);
                }
                catch (Throwable t) {
                    Logger.error(this, "Failed on " + this, t);
                    if (!wasFork) {
                        RequestSender.this.finish(8, next, true);
                    }
                }
                finally {
                    if (wasFork) {
                        next.noLongerRoutingTo(RequestSender.this.origTag, false);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void blockReceiveFailed(RetrievalException e) {
                try {
                    boolean timeout;
                    RequestSender requestSender = RequestSender.this;
                    synchronized (requestSender) {
                        RequestSender.this.transferringFrom = null;
                    }
                    RequestSender.this.origTag.senderTransferEnds((NodeCHK)RequestSender.this.key, RequestSender.this);
                    if (e.getReason() == 7) {
                        Logger.normal(this, "Transfer failed (disconnect): " + e, (Throwable)e);
                    } else {
                        Logger.normal(this, "Transfer failed (" + e.getReason() + "/" + RetrievalException.getErrString(e.getReason()) + "): " + e + " from " + next, (Throwable)e);
                    }
                    if (RequestSender.this.source == null) {
                        Logger.normal(this, "Local transfer failed: " + e.getReason() + "\u00a0: " + RetrievalException.getErrString(e.getReason()) + "): " + e + " from " + next, (Throwable)e);
                    }
                    if (!prb.abortedLocally()) {
                        next.localRejectedOverload("TransferFailedRequest" + e.getReason(), RequestSender.this.realTimeFlag);
                    }
                    RequestSender.this.node.failureTable.onFinalFailure(RequestSender.this.key, next, RequestSender.this.htl, RequestSender.this.origHTL, FailureTable.RECENTLY_FAILED_TIME, FailureTable.REJECT_TIME, RequestSender.this.source);
                    if (!wasFork) {
                        RequestSender.this.finish(4, next, false);
                    }
                    int reason = e.getReason();
                    boolean bl = timeout = !br.senderAborted() && (reason == 5 || reason == 11 || reason == 4 || reason == 12);
                    if (timeout) {
                        if (logMINOR) {
                            Logger.minor(this, "Timeout transferring data : " + e, (Throwable)e);
                        }
                        next.transferFailed(e.getErrString(), RequestSender.this.realTimeFlag);
                    } else {
                        RequestSender.this.node.failureTable.onFinalFailure(RequestSender.this.key, next, RequestSender.this.htl, RequestSender.this.origHTL, FailureTable.RECENTLY_FAILED_TIME, FailureTable.REJECT_TIME, RequestSender.this.source);
                    }
                    if (!prb.abortedLocally()) {
                        RequestSender.this.node.nodeStats.failedBlockReceive(true, timeout, RequestSender.this.realTimeFlag, RequestSender.this.source == null);
                    }
                }
                catch (Throwable t) {
                    Logger.error(this, "Failed on " + this, t);
                    if (!wasFork) {
                        RequestSender.this.finish(8, next, true);
                    }
                }
                finally {
                    if (wasFork) {
                        next.noLongerRoutingTo(RequestSender.this.origTag, false);
                    }
                }
            }
        });
    }

    private boolean handleRejectedOverload(Message msg, boolean wasFork, PeerNode next) {
        this.forwardRejectedOverload();
        ++this.rejectOverloads;
        if (msg.getBoolean("isLocal")) {
            long t = this.timeSinceSentForTimeout();
            this.node.failureTable.onFailed(this.key, next, this.htl, t, t);
            next.localRejectedOverload("ForwardRejectedOverload2", this.realTimeFlag);
            Logger.normal(this, "Local RejectedOverload after Accepted, moving on to next peer");
            next.noLongerRoutingTo(this.origTag, false);
            this.node.failureTable.onFinalFailure(this.key, next, this.htl, this.origHTL, FailureTable.RECENTLY_FAILED_TIME, FailureTable.REJECT_TIME, this.source);
            if (!wasFork) {
                this.finish(6, next, false);
            }
            return false;
        }
        return true;
    }

    private void handleRouteNotFound(Message msg, PeerNode next) {
        short newHtl = msg.getShort("hopsToLive");
        if (newHtl < 0) {
            newHtl = 0;
        }
        if (newHtl < this.htl) {
            this.htl = newHtl;
        }
        next.successNotOverload(this.realTimeFlag);
        int t = this.timeSinceSent();
        this.node.failureTable.onFailed(this.key, next, this.htl, t, t);
        next.noLongerRoutingTo(this.origTag, false);
    }

    private void handleDataNotFound(Message msg, boolean wasFork, PeerNode next) {
        next.successNotOverload(this.realTimeFlag);
        this.node.failureTable.onFinalFailure(this.key, next, this.htl, this.origHTL, FailureTable.RECENTLY_FAILED_TIME, FailureTable.REJECT_TIME, this.source);
        if (!wasFork) {
            this.finish(3, next, false);
        } else {
            next.noLongerRoutingTo(this.origTag, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecentlyFailed(Message msg, boolean wasFork, PeerNode next) {
        int timeLeft;
        next.successNotOverload(this.realTimeFlag);
        int origTimeLeft = timeLeft = msg.getInt("timeLeft");
        if (timeLeft <= 0) {
            if (timeLeft == 0) {
                if (logMINOR) {
                    Logger.minor(this, "RecentlyFailed: timeout already consumed on " + this);
                }
            } else {
                Logger.error(this, "Impossible: timeLeft=" + timeLeft);
            }
            origTimeLeft = 0;
            timeLeft = 0;
        }
        long timeSinceSent = Math.max(0, this.timeSinceSent());
        timeLeft = (int)((long)timeLeft - timeSinceSent);
        if ((timeLeft -= origTimeLeft / 100) < 0) {
            timeLeft = 0;
        }
        RequestSender requestSender = this;
        synchronized (requestSender) {
            this.killedByRecentlyFailed = true;
        }
        this.node.failureTable.onFinalFailure(this.key, next, this.htl, this.origHTL, timeLeft, FailureTable.REJECT_TIME, this.source);
        next.noLongerRoutingTo(this.origTag, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSSK(PeerNode next, boolean wasFork, byte[] headers, byte[] sskData) {
        try {
            this.block = new SSKBlock(sskData, headers, (NodeSSK)this.key, false);
            this.node.storeShallow(this.block, this.canWriteClientCache, this.canWriteDatastore, false);
            if (this.node.random.nextInt(200) == 0) {
                this.node.queueRandomReinsert(this.block);
            }
            RequestSender requestSender = this;
            synchronized (requestSender) {
                this.finalHeaders = headers;
                this.finalSskData = sskData;
            }
            this.finish(0, next, false);
        }
        catch (SSKVerifyException e) {
            Logger.error(this, "Failed to verify: " + e + " from " + next, (Throwable)e);
            if (!wasFork) {
                this.finish(5, next, false);
            } else {
                next.noLongerRoutingTo(this.origTag, false);
            }
            return;
        }
        catch (KeyCollisionException e) {
            Logger.normal(this, "Collision on " + this);
            this.block = this.node.fetch((NodeSSK)this.key, false, this.canWriteClientCache, this.canWriteClientCache, this.canWriteDatastore, false, null);
            if (this.block != null) {
                headers = this.block.getRawHeaders();
                sskData = this.block.getRawData();
            }
            RequestSender requestSender = this;
            synchronized (requestSender) {
                if (this.finalHeaders == null || this.finalSskData == null) {
                    this.finalHeaders = headers;
                    this.finalSskData = sskData;
                }
            }
            this.finish(0, next, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean finishSSKFromGetOffer(PeerNode next, byte[] headers, byte[] sskData) {
        try {
            this.block = new SSKBlock(sskData, headers, (NodeSSK)this.key, false);
            RequestSender requestSender = this;
            synchronized (requestSender) {
                this.finalHeaders = headers;
                this.finalSskData = sskData;
            }
            this.node.storeShallow(this.block, this.canWriteClientCache, this.canWriteDatastore, this.tryOffersOnly);
            if (this.node.random.nextInt(200) == 0) {
                this.node.queueRandomReinsert(this.block);
            }
            this.finish(0, next, true);
            return true;
        }
        catch (SSKVerifyException e) {
            Logger.error(this, "Failed to verify (from get offer): " + e + " from " + next, (Throwable)e);
            return false;
        }
        catch (KeyCollisionException e) {
            Logger.normal(this, "Collision (from get offer) on " + this);
            this.finish(0, next, true);
            return false;
        }
    }

    @Override
    protected Message createDataRequest() {
        Message req = !this.isSSK ? DMT.createFNPCHKDataRequest(this.uid, this.htl, (NodeCHK)this.key) : DMT.createFNPSSKDataRequest(this.uid, this.htl, (NodeSSK)this.key, this.pubKey == null);
        req.addSubMessage(DMT.createFNPRealTimeFlag(this.realTimeFlag));
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAndCommit(byte[] headers, byte[] data) throws KeyVerifyException {
        if (!this.isSSK) {
            CHKBlock block = new CHKBlock(data, headers, (NodeCHK)this.key);
            RequestSender requestSender = this;
            synchronized (requestSender) {
                this.finalHeaders = headers;
            }
            if (logMINOR) {
                Logger.minor(this, "Verified");
            }
            this.node.storeShallow(block, this.canWriteClientCache, this.canWriteDatastore, this.tryOffersOnly);
            if (this.node.random.nextInt(200) == 0) {
                this.node.queueRandomReinsert(block);
            }
        } else {
            Object block = this;
            synchronized (block) {
                this.finalHeaders = headers;
                this.finalSskData = data;
            }
            try {
                block = new SSKBlock(data, headers, (NodeSSK)this.key, false);
                if (logMINOR) {
                    Logger.minor(this, "Verified SSK");
                }
                this.node.storeShallow((SSKBlock)block, this.canWriteClientCache, this.canWriteDatastore, this.tryOffersOnly);
            }
            catch (KeyCollisionException e) {
                Logger.normal(this, "Collision on " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forwardRejectedOverload() {
        RequestSender requestSender = this;
        synchronized (requestSender) {
            if (this.hasForwardedRejectedOverload) {
                return;
            }
            this.hasForwardedRejectedOverload = true;
            this.notifyAll();
        }
        this.fireReceivedRejectOverload();
    }

    public PartiallyReceivedBlock getPRB() {
        return this.prb;
    }

    public boolean transferStarted() {
        return this.prb != null;
    }

    public synchronized short waitUntilStatusChange(short mask) {
        if (mask == 7) {
            throw new IllegalArgumentException("Cannot ignore all!");
        }
        block2: while (true) {
            long now = System.currentTimeMillis();
            long deadline = now + (this.realTimeFlag ? TimeUnit.MINUTES.toMillis(5L) : TimeUnit.MINUTES.toMillis(21L));
            while (true) {
                short current = mask;
                if (this.hasForwardedRejectedOverload) {
                    current = (short)(current | 1);
                }
                if (this.prb != null) {
                    current = (short)(current | 2);
                }
                if (this.status != -1 || this.sentAbortDownstreamTransfers) {
                    current = (short)(current | 4);
                }
                if (current != mask) {
                    return current;
                }
                try {
                    if (now >= deadline) {
                        Logger.error(this, "Waited more than 5 minutes for status change on " + this + " current = " + current + " and there was no change.");
                        continue block2;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Waiting for status change on " + this + " current is " + current + " status is " + this.status);
                    }
                    this.wait(deadline - now);
                    now = System.currentTimeMillis();
                    if (now < deadline) continue;
                    Logger.error(this, "Waited more than 5 minutes for status change on " + this + " current = " + current + ", maybe nobody called notify()");
                }
                catch (InterruptedException interruptedException) {
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int code, PeerNode next, boolean fromOfferedKey) {
        boolean shouldUnlock;
        boolean doOpennet;
        if (logMINOR) {
            Logger.minor(this, "finish(" + code + ") on " + this + " from " + next);
        }
        RequestSender requestSender = this;
        synchronized (requestSender) {
            if (this.status != -1) {
                if (logMINOR) {
                    Logger.minor(this, "Status already set to " + this.status + " - returning on " + this + " would be setting " + code + " from " + next);
                }
                if (next != null) {
                    next.noLongerRoutingTo(this.origTag, fromOfferedKey);
                }
                return;
            }
            boolean bl = doOpennet = code == 0 && !fromOfferedKey && !this.isSSK;
            if (doOpennet) {
                this.origTag.waitingForOpennet(next);
            }
            if (next != null) {
                next.noLongerRoutingTo(this.origTag, fromOfferedKey);
            }
            this.status = code;
            if (this.status == 0) {
                this.successFrom = next;
            }
            this.notifyAll();
        }
        boolean bl = shouldUnlock = doOpennet && next != null;
        if (this.status == 0) {
            if (!this.isSSK && this.transferTime > 0L && logMINOR) {
                long timeTaken = System.currentTimeMillis() - this.startTime;
                MedianMeanRunningAverage medianMeanRunningAverage = avgTimeTaken;
                synchronized (medianMeanRunningAverage) {
                    avgTimeTaken.report(timeTaken);
                    avgTimeTakenTransfer.report(this.transferTime);
                    if (logMINOR) {
                        Logger.minor(this, "Successful CHK request took " + timeTaken + " average " + avgTimeTaken);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Successful CHK request transfer " + this.transferTime + " average " + avgTimeTakenTransfer);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Search phase: median " + (avgTimeTaken.currentValue() - avgTimeTakenTransfer.currentValue()) + "ms, mean " + (avgTimeTaken.meanValue() - avgTimeTakenTransfer.meanValue()) + "ms");
                    }
                }
            }
            if (next != null) {
                next.onSuccess(false, this.isSSK);
            }
            this.node.nodeStats.requestCompleted(true, this.source != null, this.isSSK);
            this.fireRequestSenderFinished(code, fromOfferedKey);
            if (doOpennet && this.finishOpennet(next)) {
                shouldUnlock = false;
            }
        } else {
            this.node.nodeStats.requestCompleted(false, this.source != null, this.isSSK);
            this.fireRequestSenderFinished(code, fromOfferedKey);
        }
        if (shouldUnlock) {
            next.noLongerRoutingTo(this.origTag, fromOfferedKey);
        }
        RequestSender requestSender2 = this;
        synchronized (requestSender2) {
            this.opennetFinished = true;
            this.notifyAll();
        }
    }

    AsyncMessageCallback finishOpennetOnAck(final PeerNode next) {
        return new AsyncMessageCallback(){
            private boolean completed;

            @Override
            public void sent() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acknowledged() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    if (this.completed) {
                        return;
                    }
                    this.completed = true;
                }
                RequestSender.this.origTag.finishedWaitingForOpennet(next);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnected() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    if (this.completed) {
                        return;
                    }
                    this.completed = true;
                }
                RequestSender.this.origTag.finishedWaitingForOpennet(next);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fatalError() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    if (this.completed) {
                        return;
                    }
                    this.completed = true;
                }
                RequestSender.this.origTag.finishedWaitingForOpennet(next);
            }
        };
    }

    void ackOpennet(PeerNode next) {
        Message msg = DMT.createFNPOpennetCompletedAck(this.uid);
        try {
            next.sendAsync(msg, this.finishOpennetOnAck(next), this);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    private long randomDelayFinishOpennetLocal() {
        double pingTime = this.node.nodeStats.getBwlimitDelayTimeRT() + this.node.nodeStats.nodePinger.averagePingTime();
        pingTime = Math.min(pingTime, MAX_PING_TIME);
        double delay = (this.node.random.nextGaussian() * 0.5 + 3.0) * pingTime;
        return Math.max((long)delay, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean finishOpennet(final PeerNode next) {
        Object ref2;
        try {
            byte[] byArray = OpennetManager.waitForOpennetNoderef(false, next, this.uid, this, this.node);
            if (byArray == null) {
                this.ackOpennet(next);
                boolean bl = false;
                return bl;
            }
            OpennetManager om = this.node.getOpennet();
            if (om == null) {
                this.ackOpennet(next);
                boolean bl = false;
                return bl;
            }
            ref2 = OpennetManager.validateNoderef(byArray, 0, byArray.length, next, false);
            if (ref2 == null) {
                this.ackOpennet(next);
                boolean bl = false;
                return bl;
            }
            if (this.node.addNewOpennetNode((SimpleFieldSet)ref2, OpennetManager.ConnectionType.PATH_FOLDING) == null) {
                if (logMINOR) {
                    Logger.minor(this, "Don't want noderef on " + this);
                }
                RequestSender requestSender = this;
                synchronized (requestSender) {
                    this.opennetNoderef = byArray;
                }
                if (this.source == null) {
                    long delay = this.randomDelayFinishOpennetLocal();
                    if (logMINOR) {
                        Logger.minor(this, "Delaying opennet completion for " + TimeUtil.formatTime(delay, 2, true));
                    }
                    this.node.ticker.queueTimedJob(new Runnable(){

                        @Override
                        public void run() {
                            RequestSender.this.ackOpennet(next);
                        }
                    }, delay);
                } else if (this.origTag.shouldStop()) {
                    this.origTag.finishedWaitingForOpennet(next);
                }
                boolean bl = false;
                return bl;
            }
            Logger.normal(this, "Added opennet noderef in " + this + " from " + next);
            om.sendOpennetRef(true, this.uid, next, om.crypto.myCompressedFullRef(), this);
            this.origTag.finishedWaitingForOpennet(next);
        }
        catch (FSParseException fSParseException) {
            Logger.error(this, "Could not parse opennet noderef for " + this + " from " + next, (Throwable)fSParseException);
            this.ackOpennet(next);
            boolean ref2 = false;
            return ref2;
        }
        catch (PeerParseException peerParseException) {
            Logger.error(this, "Could not parse opennet noderef for " + this + " from " + next, (Throwable)peerParseException);
            this.ackOpennet(next);
            boolean ref2 = false;
            return ref2;
        }
        catch (ReferenceSignatureVerificationException referenceSignatureVerificationException) {
            Logger.error(this, "Bad signature on opennet noderef for " + this + " from " + next + " : " + referenceSignatureVerificationException, (Throwable)referenceSignatureVerificationException);
            this.ackOpennet(next);
            boolean ref2 = false;
            return ref2;
        }
        catch (NotConnectedException notConnectedException) {
            if (logMINOR) {
                Logger.minor(this, "Not connected sending ConnectReply on " + this + " to " + next);
            }
            this.origTag.finishedWaitingForOpennet(next);
        }
        catch (OpennetManager.WaitedTooLongForOpennetNoderefException waitedTooLongForOpennetNoderefException) {
            Logger.error(this, "RequestSender timed out waiting for noderef from " + next + " for " + this);
            this.origTag.timedOutToHandlerButContinued();
            Logger.warning(this, "RequestSender timed out waiting for noderef from " + next + " for " + this);
            ref2 = this;
            synchronized (ref2) {
                this.opennetTimedOut = true;
                this.opennetFinished = true;
                this.notifyAll();
            }
            try {
                OpennetManager.waitForOpennetNoderef(false, next, this.uid, this, this.node);
            }
            catch (OpennetManager.WaitedTooLongForOpennetNoderefException e1) {
                Logger.error(this, "RequestSender FATAL TIMEOUT out waiting for noderef from " + next + " for " + this);
                next.fatalTimeout(this.origTag, false);
                this.ackOpennet(next);
                boolean bl = true;
                return bl;
            }
            this.ackOpennet(next);
        }
        finally {
            RequestSender requestSender = this;
            synchronized (requestSender) {
                this.opennetFinished = true;
                this.notifyAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] waitForOpennetNoderef() throws OpennetManager.WaitedTooLongForOpennetNoderefException {
        RequestSender requestSender = this;
        synchronized (requestSender) {
            long startTime = System.currentTimeMillis();
            while (true) {
                if (this.opennetFinished) {
                    if (this.opennetTimedOut) {
                        throw new OpennetManager.WaitedTooLongForOpennetNoderefException();
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Grabbing opennet noderef on " + this, (Throwable)new Exception("debug"));
                    }
                    byte[] ref = this.opennetNoderef;
                    this.opennetNoderef = null;
                    return ref;
                }
                try {
                    int waitTime = (int)Math.min(Integer.MAX_VALUE, OPENNET_TIMEOUT + startTime - System.currentTimeMillis());
                    if (waitTime <= 0) break;
                    this.wait(waitTime);
                }
                catch (InterruptedException e) {}
            }
            if (logMINOR) {
                Logger.minor(this, "Took too long waiting for opennet ref on " + this);
            }
            return null;
        }
    }

    public synchronized PeerNode successFrom() {
        return this.successFrom;
    }

    public synchronized byte[] getHeaders() {
        return this.finalHeaders;
    }

    public int getStatus() {
        return this.status;
    }

    public short getHTL() {
        return this.htl;
    }

    final synchronized byte[] getSSKData() {
        return this.finalSskData;
    }

    public SSKBlock getSSKBlock() {
        return this.block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        if (logMINOR) {
            Logger.minor(this, "Sent bytes: " + x + " for " + this + " isSSK=" + this.isSSK, (Throwable)new Exception("debug"));
        }
        this.node.nodeStats.requestSentBytes(this.isSSK, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSentBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.requestReceivedBytes(this.isSSK, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReceivedBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesReceived;
        }
    }

    synchronized boolean hasForwarded() {
        return this.hasForwarded;
    }

    @Override
    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.requestSentBytes(this.isSSK, -x);
    }

    synchronized int getRecentlyFailedTimeLeft() {
        return this.recentlyFailedTimeLeft;
    }

    public boolean isLocalRequestSearch() {
        return this.source == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(RequestSenderListener l) {
        boolean sentFinished;
        boolean reject = false;
        boolean transfer = false;
        boolean sentTransferCancel = false;
        boolean sentFinishedFromOfferedKey = false;
        Object object = this.listeners;
        synchronized (object) {
            sentTransferCancel = this.sentAbortDownstreamTransfers;
            if (!sentTransferCancel) {
                this.listeners.add(l);
                if (logMINOR) {
                    Logger.minor(this, "Added listener " + l + " to " + this);
                }
            }
            reject = this.sentReceivedRejectOverload;
            transfer = this.sentCHKTransferBegins;
            sentFinished = this.sentRequestSenderFinished;
            sentFinishedFromOfferedKey = this.completedFromOfferedKey;
        }
        boolean bl = transfer = transfer && this.transferStarted();
        if (reject) {
            l.onReceivedRejectOverload();
        }
        if (transfer) {
            l.onCHKTransferBegins();
        }
        if (sentTransferCancel) {
            l.onAbortDownstreamTransfers(this.abortDownstreamTransfersReason, this.abortDownstreamTransfersDesc);
        }
        if (sentFinished) {
            int status;
            object = this;
            synchronized (object) {
                status = this.status;
            }
            if (status != -1) {
                l.onRequestSenderFinished(status, sentFinishedFromOfferedKey, this);
            } else {
                Logger.error(this, "sentFinished is true but status is still NOT_FINISHED?!?! on " + this, (Throwable)new Exception("error"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireReceivedRejectOverload() {
        ArrayList<RequestSenderListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.sentReceivedRejectOverload) {
                return;
            }
            this.sentReceivedRejectOverload = true;
            for (RequestSenderListener l : this.listeners) {
                try {
                    l.onReceivedRejectOverload();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCHKTransferBegins() {
        ArrayList<RequestSenderListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.sentCHKTransferBegins) {
                return;
            }
            this.sentCHKTransferBegins = true;
            for (RequestSenderListener l : this.listeners) {
                try {
                    l.onCHKTransferBegins();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRequestSenderFinished(int status, boolean fromOfferedKey) {
        this.origTag.setRequestSenderFinished(status);
        ArrayList<RequestSenderListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.sentRequestSenderFinished) {
                Logger.error(this, "Request sender finished twice: " + status + ", " + fromOfferedKey + " on " + this);
                return;
            }
            this.sentRequestSenderFinished = true;
            this.completedFromOfferedKey = fromOfferedKey;
            if (logMINOR) {
                Logger.minor(this, "Notifying " + this.listeners.size() + " listeners of status " + status);
            }
            for (RequestSenderListener l : this.listeners) {
                try {
                    l.onRequestSenderFinished(status, fromOfferedKey, this);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught: " + t, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassignToSelfOnTimeout(boolean fromOfferedKey) {
        RequestSenderListener[] list;
        ArrayList<RequestSenderListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.sentCHKTransferBegins) {
                Logger.error(this, "Transfer started, not dumping listeners when reassigning to self on timeout (race condition?) on " + this);
                return;
            }
            list = this.listeners.toArray(new RequestSenderListener[this.listeners.size()]);
            this.listeners.clear();
        }
        for (RequestSenderListener l : list) {
            l.onRequestSenderFinished(6, fromOfferedKey, this);
        }
        this.origTag.timedOutToHandlerButContinued();
    }

    @Override
    public int getPriority() {
        return NativeThread.HIGH_PRIORITY;
    }

    public PeerNode transferringFrom() {
        return this.transferringFrom;
    }

    public synchronized boolean abortedDownstreamTransfers() {
        return this.sentAbortDownstreamTransfers;
    }

    public long fetchTimeout() {
        return this.incomingSearchTimeout;
    }

    public synchronized void setTransferCoalesced() {
        this.transferCoalesced = true;
    }

    public synchronized boolean isTransferCoalesced() {
        return this.transferCoalesced;
    }

    @Override
    protected void onAccepted(PeerNode next) {
        this.onAccepted(next, false, this.htl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAccepted(PeerNode next, boolean forked, short htl) {
        MainLoopCallback cb;
        RequestSender requestSender = this;
        synchronized (requestSender) {
            this.receivingAsync = true;
            this.searchTimeout = this.calculateTimeout(htl);
            cb = new MainLoopCallback(next, forked, this.searchTimeout);
        }
        cb.schedule();
    }

    @Override
    protected long getAcceptedTimeout() {
        return ACCEPTED_TIMEOUT;
    }

    @Override
    protected void timedOutWhileWaiting(double load) {
        this.htl = (short)(this.htl - (short)Math.max(0, this.hopsForFatalTimeoutWaitingForPeer()));
        if (this.htl < 0) {
            this.htl = 0;
        }
        if (logMINOR) {
            if (this.source != null) {
                Logger.minor(this, "Timed out while waiting for a slot on " + this);
            } else {
                Logger.minor(this, "Local request timed out while waiting for a slot on " + this);
            }
        }
        this.finish(1, null, false);
        this.node.failureTable.onFinalFailure(this.key, null, this.htl, this.origHTL, -1L, -1L, this.source);
    }

    @Override
    protected boolean isInsert() {
        return false;
    }

    @Override
    protected void handleAcceptedRejectedTimeout(final PeerNode next, final UIDTag origTag) {
        final short htl = this.htl;
        origTag.handlingTimeout(next);
        long timeout = TimeUnit.MINUTES.toMillis(1L);
        MessageFilter mf = this.makeAcceptedRejectedFilter(next, timeout, origTag);
        try {
            this.node.usm.addAsyncFilter(mf, new SlowAsyncMessageFilterCallback(){

                @Override
                public void onMatched(Message m) {
                    if (m.getSpec() == DMT.FNPRejectedLoop || m.getSpec() == DMT.FNPRejectedOverload) {
                        next.noLongerRoutingTo(origTag, false);
                    } else {
                        RequestSender.this.onAccepted(next, true, htl);
                    }
                }

                @Override
                public boolean shouldTimeout() {
                    return false;
                }

                @Override
                public void onTimeout() {
                    Logger.error(this, "Fatal timeout waiting for Accepted/Rejected from " + next + " on " + RequestSender.this);
                    next.fatalTimeout(origTag, false);
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                    next.noLongerRoutingTo(origTag, false);
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                    next.noLongerRoutingTo(origTag, false);
                }

                @Override
                public int getPriority() {
                    return NativeThread.NORM_PRIORITY;
                }
            }, this);
        }
        catch (DisconnectedException e) {
            next.noLongerRoutingTo(origTag, false);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        avgTimeTaken = new MedianMeanRunningAverage();
        avgTimeTakenTransfer = new MedianMeanRunningAverage();
        MAX_PING_TIME = OPENNET_TIMEOUT / 10L;
    }

    static enum OFFER_STATUS {
        FETCHING,
        TWO_STAGE_TIMEOUT,
        FATAL,
        TRY_ANOTHER,
        KEEP;

    }

    private class MainLoopCallback
    implements SlowAsyncMessageFilterCallback {
        private final PeerNode waitingFor;
        private final boolean noReroute;
        private final long deadline;
        public byte[] sskData;
        public byte[] headers;
        final long searchTimeout;

        public MainLoopCallback(PeerNode source, boolean noReroute, long searchTimeout) {
            this.waitingFor = source;
            this.noReroute = noReroute;
            this.searchTimeout = searchTimeout;
            this.deadline = System.currentTimeMillis() + searchTimeout;
        }

        @Override
        public void onMatched(Message msg) {
            assert (this.waitingFor == msg.getSource());
            BaseSender.DO action = RequestSender.this.handleMessage(msg, this.noReroute, this.waitingFor, this);
            if (action == BaseSender.DO.FINISHED) {
                return;
            }
            if (action == BaseSender.DO.NEXT_PEER) {
                if (!this.noReroute) {
                    RequestSender.this.routeRequests();
                }
            } else {
                this.schedule();
            }
        }

        public void schedule() {
            long now = System.currentTimeMillis();
            int timeout = (int)Math.min(Integer.MAX_VALUE, this.deadline - now);
            if (timeout >= 0) {
                MessageFilter mf = RequestSender.this.createMessageFilter(timeout, this.waitingFor);
                try {
                    RequestSender.this.node.usm.addAsyncFilter(mf, this, RequestSender.this);
                }
                catch (DisconnectedException e) {
                    this.onDisconnect(RequestSender.this.lastNode);
                }
            } else {
                this.onTimeout();
            }
        }

        @Override
        public boolean shouldTimeout() {
            if (this.noReroute) {
                return false;
            }
            return false;
        }

        @Override
        public void onTimeout() {
            BaseSender.DO action;
            Logger.warning(this, "Timed out after waiting " + this.searchTimeout + " on " + RequestSender.this.uid + " from " + this.waitingFor + " (" + RequestSender.this.gotMessages + " messages; last=" + RequestSender.this.lastMessage + ") for " + RequestSender.this.uid + " noReroute=" + this.noReroute);
            if (this.noReroute) {
                this.waitingFor.localRejectedOverload("FatalTimeoutForked", RequestSender.this.realTimeFlag);
            } else {
                this.waitingFor.localRejectedOverload("FatalTimeout", RequestSender.this.realTimeFlag);
                RequestSender.this.forwardRejectedOverload();
                RequestSender.this.node.failureTable.onFinalFailure(RequestSender.this.key, this.waitingFor, RequestSender.this.htl, RequestSender.this.origHTL, FailureTable.RECENTLY_FAILED_TIME, FailureTable.REJECT_TIME, RequestSender.this.source);
                RequestSender.this.finish(6, this.waitingFor, false);
            }
            long deadline = System.currentTimeMillis() + this.searchTimeout;
            do {
                Message msg;
                try {
                    int timeout = (int)Math.min(Integer.MAX_VALUE, deadline - System.currentTimeMillis());
                    msg = RequestSender.this.node.usm.waitFor(RequestSender.this.createMessageFilter(timeout, this.waitingFor), RequestSender.this);
                }
                catch (DisconnectedException e) {
                    Logger.normal(this, "Disconnected from " + this.waitingFor + " while waiting for reply on " + this);
                    this.waitingFor.noLongerRoutingTo(RequestSender.this.origTag, false);
                    return;
                }
                if (msg == null) {
                    Logger.error(this, "Fatal timeout waiting for reply after Accepted on " + this + " from " + this.waitingFor);
                    this.waitingFor.fatalTimeout(RequestSender.this.origTag, false);
                    return;
                }
                action = RequestSender.this.handleMessage(msg, this.noReroute, this.waitingFor, this);
                if (action != BaseSender.DO.FINISHED) continue;
                return;
            } while (action != BaseSender.DO.NEXT_PEER);
            this.waitingFor.noLongerRoutingTo(RequestSender.this.origTag, false);
        }

        @Override
        public void onDisconnect(PeerContext ctx) {
            Logger.normal(this, "Disconnected from " + this.waitingFor + " while waiting for data on " + RequestSender.this.uid);
            this.waitingFor.noLongerRoutingTo(RequestSender.this.origTag, false);
            if (this.noReroute) {
                return;
            }
            RequestSender.this.routeRequests();
        }

        @Override
        public void onRestarted(PeerContext ctx) {
            this.onDisconnect(ctx);
        }

        @Override
        public int getPriority() {
            return NativeThread.NORM_PRIORITY;
        }

        public String toString() {
            return super.toString() + ":" + this.waitingFor + ":" + this.noReroute + ":" + RequestSender.this;
        }
    }
}

