/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.ToadletContextImpl;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import freenet.support.api.RandomAccessBucket;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Date;
import java.text.ParseException;
import javax.imageio.ImageIO;

public class ImageCreatorToadlet
extends Toadlet {
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 100;
    public static final Date LAST_MODIFIED = new Date(1248256659000L);

    protected ImageCreatorToadlet(HighLevelSimpleClient client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMethodGET(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        boolean needsGeneration = true;
        if (ctx.getHeaders().containsKey("if-modified-since")) {
            try {
                if (ToadletContextImpl.parseHTTPDate(ctx.getHeaders().get("if-modified-since")).compareTo(LAST_MODIFIED) == 0) {
                    ctx.sendReplyHeadersStatic(304, "Not Modified", null, "image/png", 0L, LAST_MODIFIED);
                    needsGeneration = false;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (needsGeneration) {
            Rectangle2D bounds;
            int requiredWidth;
            String text = req.getParam("text");
            int n = req.getParam("width").compareTo("") != 0 ? Integer.parseInt(req.getParam("width").endsWith("px") ? req.getParam("width").substring(0, req.getParam("width").length() - 2) : req.getParam("width")) : (requiredWidth = 100);
            int requiredHeight = req.getParam("height").compareTo("") != 0 ? Integer.parseInt(req.getParam("height").endsWith("px") ? req.getParam("height").substring(0, req.getParam("height").length() - 2) : req.getParam("height")) : 100;
            BufferedImage buffer = new BufferedImage(requiredWidth, requiredHeight, 1);
            Graphics2D g2 = buffer.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontRenderContext fc = g2.getFontRenderContext();
            float size = 1.0f;
            g2.setFont(g2.getFont().deriveFont(size));
            int width = 0;
            int height = 0;
            while (width < requiredWidth && height < requiredHeight) {
                bounds = g2.getFont().getStringBounds(text, fc);
                width = (int)bounds.getWidth();
                height = (int)bounds.getHeight();
                g2.setFont(g2.getFont().deriveFont(size += 1.0f));
            }
            g2.setFont(g2.getFont().deriveFont(size - 1.0f));
            bounds = g2.getFont().getStringBounds(text, fc);
            g2.setColor(new Color(0, 0, 0));
            g2.fillRect(0, 0, width, height);
            g2.setColor(new Color(255, 255, 255));
            g2.drawString(text, (int)((double)(requiredWidth / 2) - bounds.getWidth() / 2.0), (int)((double)(requiredHeight / 2) + bounds.getHeight() / 4.0));
            RandomAccessBucket data = ctx.getBucketFactory().makeBucket(-1L);
            try (OutputStream os = data.getOutputStream();){
                ImageIO.write((RenderedImage)buffer, "png", os);
            }
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            ctx.sendReplyHeadersStatic(200, "OK", headers, "image/png", data.size(), LAST_MODIFIED);
            ctx.writeData(data);
        }
    }

    @Override
    public String path() {
        return "/imagecreator/";
    }
}

