/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.node.Node;
import freenet.node.RequestStarter;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;

public class ModifyPersistentRequest
extends FCPMessage {
    static final String NAME = "ModifyPersistentRequest";
    final String identifier;
    final boolean global;
    final short priorityClass;
    final String clientToken;

    ModifyPersistentRequest(SimpleFieldSet fs) throws MessageInvalidException {
        block5: {
            this.global = fs.getBoolean("Global", false);
            this.identifier = fs.get("Identifier");
            this.clientToken = fs.get("ClientToken");
            if (this.identifier == null) {
                throw new MessageInvalidException(5, "Missing field: Identifier", null, this.global);
            }
            String prio = fs.get("PriorityClass");
            if (prio != null) {
                try {
                    this.priorityClass = Short.parseShort(prio);
                    if (!RequestStarter.isValidPriorityClass(this.priorityClass)) {
                        throw new MessageInvalidException(8, "Invalid priority class " + this.priorityClass + " - range is " + 6 + " to " + 0, this.identifier, this.global);
                    }
                    break block5;
                }
                catch (NumberFormatException e) {
                    throw new MessageInvalidException(6, "Could not parse PriorityClass: " + e.getMessage(), this.identifier, this.global);
                }
            }
            this.priorityClass = (short)-1;
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.put("Global", this.global);
        fs.put("PriorityClass", this.priorityClass);
        if (this.clientToken != null) {
            fs.putSingle("ClientToken", this.clientToken);
        }
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        ClientRequest req = handler.getRebootRequest(this.global, handler, this.identifier);
        if (req == null) {
            try {
                node.clientCore.clientContext.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        ClientRequest req = handler.getForeverRequest(ModifyPersistentRequest.this.global, handler, ModifyPersistentRequest.this.identifier);
                        if (req == null) {
                            Logger.error(this, "Huh ? the request is null!");
                            ProtocolErrorMessage msg = new ProtocolErrorMessage(15, false, null, ModifyPersistentRequest.this.identifier, ModifyPersistentRequest.this.global);
                            handler.outputHandler.queue(msg);
                            return false;
                        }
                        req.modifyRequest(ModifyPersistentRequest.this.clientToken, ModifyPersistentRequest.this.priorityClass, handler.server);
                        return true;
                    }
                }, NativeThread.NORM_PRIORITY);
            }
            catch (PersistenceDisabledException e) {
                ProtocolErrorMessage msg = new ProtocolErrorMessage(15, false, null, this.identifier, this.global);
                handler.outputHandler.queue(msg);
            }
        } else {
            req.modifyRequest(this.clientToken, this.priorityClass, node.clientCore.getFCPServer());
        }
    }
}

