/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.client.async.StreamGenerator;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SingleFileStreamGenerator
implements StreamGenerator {
    private final Bucket bucket;
    private final boolean persistent;
    private static volatile boolean logMINOR;

    SingleFileStreamGenerator(Bucket bucket, boolean persistent) {
        this.bucket = bucket;
        this.persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream os, ClientContext context) throws IOException {
        try {
            if (logMINOR) {
                Logger.minor(this, "Generating Stream", (Throwable)new Exception("debug"));
            }
            try (InputStream data = this.bucket.getInputStream();){
                FileUtil.copy(data, os, -1L);
            }
            os.close();
            this.bucket.free();
            if (logMINOR) {
                Logger.minor(this, "Stream completely generated", (Throwable)new Exception("debug"));
            }
        }
        finally {
            Closer.close(this.bucket);
            Closer.close(os);
        }
    }

    @Override
    public long size() {
        return this.bucket.size();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

