/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.optimization;

import org.spaceroots.mantissa.optimization.CostException;
import org.spaceroots.mantissa.optimization.DirectSearchOptimizer;
import org.spaceroots.mantissa.optimization.PointCostPair;

public class NelderMead
extends DirectSearchOptimizer {
    private double rho;
    private double khi;
    private double gamma;
    private double sigma;

    public NelderMead() {
        this.rho = 1.0;
        this.khi = 2.0;
        this.gamma = 0.5;
        this.sigma = 0.5;
    }

    public NelderMead(double rho, double khi, double gamma, double sigma) {
        this.rho = rho;
        this.khi = khi;
        this.gamma = gamma;
        this.sigma = sigma;
    }

    @Override
    protected void iterateSimplex() throws CostException {
        int j;
        int n = this.simplex.length - 1;
        double smallest = this.simplex[0].cost;
        double secondLargest = this.simplex[n - 1].cost;
        double largest = this.simplex[n].cost;
        double[] xLargest = this.simplex[n].point;
        double[] centroid = new double[n];
        for (int i = 0; i < n; ++i) {
            double[] x = this.simplex[i].point;
            for (j = 0; j < n; ++j) {
                int n2 = j;
                centroid[n2] = centroid[n2] + x[j];
            }
        }
        double scaling = 1.0 / (double)n;
        j = 0;
        while (j < n) {
            int n3 = j++;
            centroid[n3] = centroid[n3] * scaling;
        }
        double[] xR = new double[n];
        for (int j2 = 0; j2 < n; ++j2) {
            xR[j2] = centroid[j2] + this.rho * (centroid[j2] - xLargest[j2]);
        }
        double costR = this.evaluateCost(xR);
        if (smallest <= costR && costR < secondLargest) {
            this.replaceWorstPoint(new PointCostPair(xR, costR));
        } else if (costR < smallest) {
            double[] xE = new double[n];
            for (int j3 = 0; j3 < n; ++j3) {
                xE[j3] = centroid[j3] + this.khi * (xR[j3] - centroid[j3]);
            }
            double costE = this.evaluateCost(xE);
            if (costE < costR) {
                this.replaceWorstPoint(new PointCostPair(xE, costE));
            } else {
                this.replaceWorstPoint(new PointCostPair(xR, costR));
            }
        } else {
            double costC;
            double[] xC;
            if (costR < largest) {
                xC = new double[n];
                for (int j4 = 0; j4 < n; ++j4) {
                    xC[j4] = centroid[j4] + this.gamma * (xR[j4] - centroid[j4]);
                }
                costC = this.evaluateCost(xC);
                if (costC <= costR) {
                    this.replaceWorstPoint(new PointCostPair(xC, costC));
                    return;
                }
            } else {
                xC = new double[n];
                for (int j5 = 0; j5 < n; ++j5) {
                    xC[j5] = centroid[j5] - this.gamma * (centroid[j5] - xLargest[j5]);
                }
                costC = this.evaluateCost(xC);
                if (costC < largest) {
                    this.replaceWorstPoint(new PointCostPair(xC, costC));
                    return;
                }
            }
            double[] xSmallest = this.simplex[0].point;
            for (int i = 1; i < this.simplex.length; ++i) {
                double[] x = this.simplex[i].point;
                for (int j6 = 0; j6 < n; ++j6) {
                    x[j6] = xSmallest[j6] + this.sigma * (x[j6] - xSmallest[j6]);
                }
                this.simplex[i] = new PointCostPair(x, Double.NaN);
            }
            this.evaluateSimplex();
        }
    }
}

