/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.functions.vectorial;

import java.io.Serializable;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.vectorial.ComputableFunction;
import org.spaceroots.mantissa.functions.vectorial.SampledFunction;
import org.spaceroots.mantissa.functions.vectorial.VectorialValuedPair;

public class ComputableFunctionSampler
implements SampledFunction,
Serializable {
    private ComputableFunction function;
    private double begin;
    private double step;
    private int n;
    private static final long serialVersionUID = 1368582688313212821L;

    public ComputableFunctionSampler(ComputableFunction function, double begin, double step, int n) {
        this.function = function;
        this.begin = begin;
        this.step = step;
        this.n = n;
    }

    public ComputableFunctionSampler(ComputableFunction function, double[] range, int n) {
        this.function = function;
        this.begin = range[0];
        this.step = (range[1] - range[0]) / (double)(n - 1);
        this.n = n;
    }

    public ComputableFunctionSampler(ComputableFunction function, double[] range, double step, boolean adjustStep) {
        this.function = function;
        this.begin = range[0];
        if (adjustStep) {
            this.n = (int)Math.ceil((range[1] - range[0]) / step);
            this.step = (range[1] - range[0]) / (double)(this.n - 1);
        } else {
            this.n = (int)Math.floor((range[1] - range[0]) / step);
            this.step = step;
        }
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public int getDimension() {
        return this.function.getDimension();
    }

    @Override
    public VectorialValuedPair samplePointAt(int index) throws ArrayIndexOutOfBoundsException, FunctionException {
        if (index < 0 || index >= this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        double x = this.begin + (double)index * this.step;
        return new VectorialValuedPair(x, this.function.valueAt(x));
    }
}

