/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ObjectInfo;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;

public class FrozenObjectInfo
implements ObjectInfo {
    private final Db4oDatabase _sourceDatabase;
    private final long _uuidLongPart;
    private final long _id;
    private final long _version;
    private final Object _object;

    public FrozenObjectInfo(Object object, long id, Db4oDatabase sourceDatabase, long uuidLongPart, long version) {
        this._sourceDatabase = sourceDatabase;
        this._uuidLongPart = uuidLongPart;
        this._id = id;
        this._version = version;
        this._object = object;
    }

    private FrozenObjectInfo(ObjectReference ref, VirtualAttributes virtualAttributes) {
        this(ref == null ? null : ref.getObject(), ref == null ? -1L : (long)ref.getID(), virtualAttributes == null ? null : virtualAttributes.i_database, virtualAttributes == null ? -1L : virtualAttributes.i_uuid, ref == null ? 0L : ref.getVersion());
    }

    public FrozenObjectInfo(Transaction trans, ObjectReference ref) {
        this(ref, ref == null ? null : ref.virtualAttributes(trans, true));
    }

    @Override
    public long getInternalID() {
        return this._id;
    }

    @Override
    public Object getObject() {
        return this._object;
    }

    @Override
    public Db4oUUID getUUID() {
        if (this._sourceDatabase == null) {
            return null;
        }
        return new Db4oUUID(this._uuidLongPart, this._sourceDatabase.getSignature());
    }

    @Override
    public long getVersion() {
        return this._version;
    }

    public long sourceDatabaseId(Transaction trans) {
        if (this._sourceDatabase == null) {
            return -1L;
        }
        return this._sourceDatabase.getID(trans);
    }

    public long uuidLongPart() {
        return this._uuidLongPart;
    }
}

