/*
 * Decompiled with CFR 0.152.
 */
package viz.graphics;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.util.Random;
import viz.graphics.BranchDrawer;
import viz.graphics.BufferedImageF;

public class TreeDrawer {
    BranchDrawer m_branchDrawer = new BranchDrawer();
    public boolean m_bViewBlockTree = false;
    public boolean m_bRootAtTop = false;
    int m_nJitter;
    Random m_random = new Random();
    BufferedImageF m_image;
    int m_nTreeWidth = 1;
    public float LINE_WIDTH_SCALE = 20.0f;

    public void setBranchDrawer(BranchDrawer bd) {
        this.m_branchDrawer = bd;
    }

    public BranchDrawer getBranchDrawer() {
        return this.m_branchDrawer;
    }

    public void setJitter(int nJitter) {
        this.m_nJitter = nJitter;
    }

    public void setImage(BufferedImageF image) {
        this.m_image = image;
    }

    void drawBlockTree(float[] nX, float[] nY, int[] color, Graphics2D g, float fScaleX, float fScaleY) {
        if (nX == null || nY == null) {
            return;
        }
        if (this.m_nJitter <= 0) {
            int i = 0;
            while (i < nX.length - 4) {
                if (this.m_bRootAtTop) {
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY), (int)(nX[i] * fScaleX), (int)(nY[i + 1] * fScaleY), 0.0f, 0.0f);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i + 1] * fScaleY), (int)(nX[i + 3] * fScaleX), (int)(nY[i + 1] * fScaleY), 0.0f, 0.0f);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i + 3] * fScaleX), (int)(nY[i + 2] * fScaleY), (int)(nX[i + 3] * fScaleX), (int)(nY[i + 3] * fScaleY), 0.0f, 0.0f);
                } else {
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nY[i] * fScaleX), (int)(nX[i] * fScaleY), (int)(nY[i + 1] * fScaleX), (int)(nX[i] * fScaleY), 0.0f, 0.0f);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nY[i + 1] * fScaleX), (int)(nX[i] * fScaleY), (int)(nY[i + 1] * fScaleX), (int)(nX[i + 3] * fScaleY), 0.0f, 0.0f);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nY[i + 2] * fScaleX), (int)(nX[i + 3] * fScaleY), (int)(nY[i + 3] * fScaleX), (int)(nX[i + 3] * fScaleY), 0.0f, 0.0f);
                }
                i += 4;
            }
        } else {
            int[] nXJ = new int[nX.length];
            int i = 0;
            while (i < nX.length) {
                nXJ[i] = (int)(nX[i] * fScaleX) + this.m_random.nextInt(this.m_nJitter);
                ++i;
            }
            i = 0;
            while (i < nX.length - 4) {
                if (this.m_bRootAtTop) {
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY), (int)(nX[i] * fScaleX), (int)(nY[i + 1] * fScaleY), 0.0f, 0.0f);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i + 1] * fScaleY), (int)(nX[i + 3] * fScaleX), (int)(nY[i + 1] * fScaleY), 0.0f, 0.0f);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i + 3] * fScaleX), (int)(nY[i + 2] * fScaleY), (int)(nX[i + 3] * fScaleX), (int)(nY[i + 3] * fScaleY), 0.0f, 0.0f);
                } else {
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY), (int)(nX[i + 1] * fScaleX), (int)(nY[i] * fScaleY), 0.0f, 0.0f);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i + 1] * fScaleX), (int)(nY[i] * fScaleY), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 3] * fScaleY), 0.0f, 0.0f);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i + 2] * fScaleX), (int)(nY[i + 3] * fScaleY), (int)(nX[i + 3] * fScaleX), (int)(nY[i + 3] * fScaleY), 0.0f, 0.0f);
                }
                i += 4;
            }
        }
    }

    void drawBlockTree(float[] nX, float[] nY, float[] fLineWidth, float[] fTopLineWidth, int[] color, Graphics2D g, float fScaleX, float fScaleY) {
        if (nX == null || nY == null) {
            return;
        }
        if (this.m_nJitter <= 0) {
            int i = 0;
            while (i < nX.length - 2) {
                if (i % 4 != 3) {
                    if (i % 4 == 0 || i % 4 == 2) {
                        float fTopWidth2;
                        float fWidth = fLineWidth[i] * this.LINE_WIDTH_SCALE;
                        float fTopWidth = fTopLineWidth[i] * this.LINE_WIDTH_SCALE;
                        BasicStroke stroke = new BasicStroke(fWidth, 0, 2);
                        g.setStroke(stroke);
                        if (this.m_bViewBlockTree) {
                            if (i % 4 == 0) {
                                this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fTopWidth / 2.0f), fTopWidth, fWidth);
                            } else {
                                this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fTopWidth / 2.0f), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), fWidth, fTopWidth);
                            }
                        } else if (i % 4 == 0) {
                            fTopWidth2 = fTopLineWidth[i + 2] * this.LINE_WIDTH_SCALE;
                            if (nY[i + 1] <= nY[i + 2]) {
                                this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)), fTopWidth, fWidth);
                            } else {
                                this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)), fTopWidth, fWidth);
                            }
                        } else {
                            fTopWidth2 = fTopLineWidth[i - 2] * this.LINE_WIDTH_SCALE;
                            if (nY[i - 1] <= nY[i]) {
                                this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), fWidth, fTopWidth);
                            } else {
                                this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), fWidth, fTopWidth);
                            }
                        }
                    } else if (i % 4 == 1 && this.m_bViewBlockTree) {
                        BasicStroke stroke = new BasicStroke(this.m_nTreeWidth, 0, 2);
                        g.setStroke(stroke);
                        this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY), 0.0f, 0.0f);
                    }
                }
                ++i;
            }
        } else {
            int[] nXJ = new int[nX.length];
            int i = 0;
            while (i < nX.length) {
                nXJ[i] = (int)(nX[i] * fScaleX) + this.m_random.nextInt(this.m_nJitter);
                ++i;
            }
            i = 0;
            while (i < nX.length - 1) {
                if (i % 4 != 3) {
                    this.m_branchDrawer.draw(this.m_image, color[i], g, nXJ[i], (int)(nY[i] * fScaleY), nXJ[i + 1], (int)(nY[i + 1] * fScaleY), 0.0f, 0.0f);
                }
                if (i % 4 == 0 || i % 4 == 2) {
                    float fWidth = fLineWidth[i] * this.LINE_WIDTH_SCALE;
                    BasicStroke stroke = new BasicStroke(fWidth, 0, 2);
                    g.setStroke(stroke);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, nXJ[i], (int)(nY[i] * fScaleY - fWidth / 2.0f), nXJ[i + 1], (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), fWidth, fTopLineWidth[i] * this.LINE_WIDTH_SCALE);
                } else if (i % 4 == 1) {
                    BasicStroke stroke = new BasicStroke(this.m_nTreeWidth, 0, 2);
                    g.setStroke(stroke);
                    this.m_branchDrawer.draw(this.m_image, color[i], g, nXJ[i], (int)(nY[i] * fScaleY), nXJ[i + 1], (int)(nY[i + 1] * fScaleY), 0.0f, 0.0f);
                }
                ++i;
            }
        }
    }

    void drawTriangleTree(float[] nX, float[] nY, int[] color, Graphics2D g, float fScaleX, float fScaleY) {
        if (nX == null || nY == null) {
            return;
        }
        if (this.m_bRootAtTop) {
            int i = 0;
            while (i < nX.length - 4) {
                float fWidth = 0.0f;
                float fTopWidth = 0.0f;
                float fTopWidth2 = 0.0f;
                if (i % 4 != 3 && (i % 4 == 0 || i % 4 == 2)) {
                    if (i % 4 == 0) {
                        if (nX[i + 1] < nX[i + 2]) {
                            this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX - fWidth / 2.0f), (int)(nY[i] * fScaleY), (int)((double)(nX[i + 1] + nX[i + 2]) / 2.0 * (double)fScaleX - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nY[i + 1] * fScaleY) - 1, 0.0f, 0.0f);
                        } else {
                            this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX - fWidth / 2.0f), (int)(nY[i] * fScaleY), (int)((double)(nX[i + 1] + nX[i + 2]) / 2.0 * (double)fScaleX - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nY[i + 1] * fScaleY) - 1, 0.0f, 0.0f);
                        }
                    } else if (nX[i - 1] < nX[i]) {
                        this.m_branchDrawer.draw(this.m_image, color[i], g, (int)((double)(nX[i] + nX[i - 1]) / 2.0 * (double)fScaleX - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nY[i] * fScaleY) - 1, (int)(nX[i + 1] * fScaleX - fWidth / 2.0f), (int)(nY[i + 1] * fScaleY) - 1, 0.0f, 0.0f);
                    } else {
                        this.m_branchDrawer.draw(this.m_image, color[i], g, (int)((double)(nX[i] + nX[i - 1]) / 2.0 * (double)fScaleX - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nY[i] * fScaleY) - 1, (int)(nX[i + 1] * fScaleX - fWidth / 2.0f), (int)(nY[i + 1] * fScaleY) - 1, 0.0f, 0.0f);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < nX.length - 4) {
                float fWidth = 0.0f;
                float fTopWidth = 0.0f;
                float fTopWidth2 = 0.0f;
                if (i % 4 != 3 && (i % 4 == 0 || i % 4 == 2)) {
                    if (i % 4 == 0) {
                        if (nY[i + 1] < nY[i + 2]) {
                            this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)), 0.0f, 0.0f);
                        } else {
                            this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)), 0.0f, 0.0f);
                        }
                    } else if (nY[i - 1] < nY[i]) {
                        this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), 0.0f, 0.0f);
                    } else {
                        this.m_branchDrawer.draw(this.m_image, color[i], g, (int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), 0.0f, 0.0f);
                    }
                }
                ++i;
            }
        }
    }

    public void draw(int i, float[][] fLinesX, float[][] fLinesY, float[][] fLineWidth, float[][] fTopLineWidth, int[][] nLineColor, Graphics2D g, float fScaleX, float fScaleY) {
        if (this.m_bViewBlockTree) {
            if (fLineWidth == null) {
                this.drawBlockTree(fLinesX[i], fLinesY[i], nLineColor[i], g, fScaleX, fScaleY);
            } else if (this.m_bRootAtTop) {
                this.drawBlockTree(fLinesX[i], fLinesY[i], fLineWidth[i], fTopLineWidth[i], nLineColor[i], g, fScaleX, fScaleY);
            } else {
                this.drawBlockTree(fLinesY[i], fLinesX[i], fLineWidth[i], fTopLineWidth[i], nLineColor[i], g, fScaleX, fScaleY);
            }
        } else if (fLineWidth == null) {
            if (this.m_bRootAtTop) {
                this.drawTriangleTree(fLinesX[i], fLinesY[i], nLineColor[i], g, fScaleX, fScaleY);
            } else {
                this.drawTriangleTree(fLinesY[i], fLinesX[i], nLineColor[i], g, fScaleX, fScaleY);
            }
        } else if (this.m_bRootAtTop) {
            this.drawBlockTree(fLinesX[i], fLinesY[i], fLineWidth[i], fTopLineWidth[i], nLineColor[i], g, fScaleX, fScaleY);
        } else {
            this.drawBlockTree(fLinesY[i], fLinesX[i], fLineWidth[i], fTopLineWidth[i], nLineColor[i], g, fScaleX, fScaleY);
        }
    }
}

