/*
 * Decompiled with CFR 0.152.
 */
package jam.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Properties;
import javax.swing.JTextField;

public class Utils {
    public static double getDoubleFromTextField(JTextField textField, double defaultValue) {
        double value = defaultValue;
        try {
            value = Double.parseDouble(textField.getText());
        }
        catch (NumberFormatException nfe) {
            textField.setText(String.valueOf(defaultValue));
        }
        return value;
    }

    public static void centerComponent(Component component, Component reference) {
        Point referencePosition;
        Dimension referenceSize;
        Dimension componentSize = component.getSize();
        if (reference != null && reference.isShowing()) {
            referenceSize = reference.getSize();
            referencePosition = reference.getLocationOnScreen();
        } else {
            referenceSize = Toolkit.getDefaultToolkit().getScreenSize();
            referencePosition = new Point(0, 0);
        }
        component.setBounds(referencePosition.x + Math.abs(referenceSize.width - componentSize.width) / 2, referencePosition.y + Math.abs(referenceSize.height - componentSize.height) / 2, componentSize.width, componentSize.height);
    }

    public static void showWaitCursor(Component component) {
        Utils.showPredefinedCursor(component, 3);
    }

    public static void showPredefinedCursor(Component component, int cursor) {
        component.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    public static void showDefaultCursor(Component component) {
        Utils.showPredefinedCursor(component, 0);
    }

    public static String getEnv(String name) {
        Properties jvmEnv = System.getProperties();
        Properties envVars = new Properties();
        try {
            if (jvmEnv.getProperty("os.name").toLowerCase().indexOf("win") != -1) {
                envVars.load(Runtime.getRuntime().exec("set").getInputStream());
            } else {
                try {
                    envVars.load(Runtime.getRuntime().exec("/usr/bin/env").getInputStream());
                }
                catch (Throwable t) {
                    envVars.load(Runtime.getRuntime().exec("/bin/env").getInputStream());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return envVars.getProperty(name);
    }
}

