/*
 * Decompiled with CFR 0.152.
 */
package jam.disclosure;

import jam.util.IconUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;

public class SlideOpenPanel
extends JPanel {
    ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int delta = (int)Math.ceil((double)(SlideOpenPanel.this.target - SlideOpenPanel.this.topPanel.getHeight()) / 10.0);
            if (delta > 0) {
                Dimension size = SlideOpenPanel.this.topPanel.getPreferredSize();
                size.height = Math.min(size.height + delta, SlideOpenPanel.this.target);
                SlideOpenPanel.this.topPanel.setPreferredSize(size);
                SlideOpenPanel.this.topPanel.revalidate();
                SlideOpenPanel.this.revalidate();
                SlideOpenPanel.this.repaint();
            } else {
                SlideOpenPanel.this.stopAnimation();
            }
        }
    };
    private final JPanel topPanel;
    private final JButton doneButton;
    private JPanel utilityPanel = null;
    private Timer timer = null;
    private int animationSpeed = 10;
    private int target;
    private boolean hiding;
    private static BufferedImage backgroundImage = null;
    private static Icon closeIcon = IconUtils.getIcon(SlideOpenPanel.class, "images/close.png");

    static {
        try {
            backgroundImage = IconUtils.getBufferedImage(SlideOpenPanel.class, "images/utilityBackground.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SlideOpenPanel(JPanel mainPanel) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel(new BorderLayout()){

            @Override
            public void paint(Graphics graphics) {
                graphics.drawImage(backgroundImage, 0, 0, this.getWidth(), this.getHeight(), null);
                super.paint(graphics);
            }
        };
        this.topPanel.setOpaque(false);
        this.topPanel.setVisible(false);
        this.topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.add((Component)this.topPanel, "North");
        this.add((Component)mainPanel, "Center");
        this.doneButton = new JButton(closeIcon);
        Dimension d = this.doneButton.getPreferredSize();
        this.doneButton.setPreferredSize(new Dimension(26, 26));
        this.adjustComponent(this.doneButton);
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlideOpenPanel.this.hideUtilityPanel();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "doClose");
        this.getActionMap().put("doClose", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SlideOpenPanel.this.doneButton.doClick();
            }
        });
    }

    public void showUtilityPanel(JPanel utilityPanel) {
        if (utilityPanel == null) {
            return;
        }
        this.utilityPanel = utilityPanel;
        this.topPanel.removeAll();
        this.topPanel.add((Component)utilityPanel, "Center");
        this.topPanel.add((Component)this.doneButton, "East");
        Dimension size = this.topPanel.getPreferredSize();
        this.target = utilityPanel.getPreferredSize().height + 9;
        size.height = 0;
        this.topPanel.setPreferredSize(size);
        this.topPanel.setVisible(true);
        this.hiding = false;
        this.startAnimation();
    }

    public void hideUtilityPanel() {
        this.target = 0;
        this.hiding = true;
        this.utilityPanel = null;
        this.startAnimation();
    }

    public JPanel getUtilityPanel() {
        return this.utilityPanel;
    }

    protected void adjustComponent(JComponent comp) {
        Font font = UIManager.getFont("SmallSystemFont");
        if (font != null) {
            comp.setFont(font);
        }
        comp.putClientProperty("JComponent.sizeVariant", "small");
        if (comp instanceof JButton) {
            comp.putClientProperty("JButton.buttonType", "roundRect");
            comp.setFocusable(false);
        }
        if (comp instanceof JComboBox) {
            comp.putClientProperty("JComboBox.isSquare", Boolean.TRUE);
            comp.setFocusable(false);
        }
        if (comp instanceof JCheckBox) {
            comp.setFocusable(false);
        }
    }

    private void startAnimation() {
        this.timer = new Timer(this.animationSpeed, this.listener);
        this.timer.setRepeats(true);
        this.timer.setCoalesce(false);
        this.timer.start();
    }

    private void stopAnimation() {
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
        if (this.hiding) {
            this.topPanel.setVisible(false);
        }
    }
}

